macro(config_compiler_and_linker)
    if (CMAKE_COMPILER_IS_GNUCXX)
      set(CMAKE_CXX_FLAGS_DEBUG          "-O0 -fno-inline")
      set(CMAKE_CXX_FLAGS_RELEASE        "-O2")
      set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "-O2 -fno-inline")
      set(CMAKE_CXX_FLAGS_MINSIZEREL     "-Os -s")
      set(cxx_base_flags "-g -std=c++11 -Wall -Wshadow -fPIC -pipe")
      set(cxx_exceptions_flags "-fexceptions")
      set(cxx_no_exceptions_flags "-fno-exceptions")
      set(cxx_no_rtti_flags "-fno-rtti")
      set(cxx_strict_flags
        "-Wextra -Wno-unused-parameter -Wno-missing-field-initializers")
    endif()

    if (CMAKE_COMPILER_IS_GNUC)
      set(CMAKE_C_FLAGS_DEBUG          "-O0 -fno-inline")
      set(CMAKE_C_FLAGS_RELEASE        "-O2")
      set(CMAKE_C_FLAGS_RELWITHDEBINFO "-O2 -fno-inline")
      set(CMAKE_C_FLAGS_MINSIZEREL     "-Os -s")
      set(c_base_flags "-g -std=c99 -Wall -Wshadow")
      set(c_strict_flags
        "-Wextra -Wno-unused-parameter -Wno-missing-field-initializers")
    endif()

    set(c_default "${CMAKE_C_FLAGS} ${c_base_flags}")
    set(c_strict "${c_default} ${c_strict_flags}")

    set(cxx_exception
      "${CMAKE_CXX_FLAGS} ${cxx_base_flags} ${cxx_exceptions_flags}")
    set(cxx_no_exception
      "${CMAKE_CXX_FLAGS} ${cxx_base_flags} ${cxx_no_exceptions_flags}")
    set(cxx_default "${cxx_exception}")
    set(cxx_strict "${cxx_default} ${cxx_strict_flags}")
endmacro()


# Helper functions

function(cxx_library_with_type name type cxx_flags)
  add_library(${name} ${type} ${ARGN})
  set_target_properties(${name}
    PROPERTIES
    COMPILE_FLAGS "${cxx_flags}")
endfunction()

function(cxx_shared_library name cxx_flags)
  cxx_library_with_type(${name} SHARED "${cxx_flags}" ${ARGN})
endfunction()

function(cxx_library name cxx_flags)
  cxx_library_with_type(${name} "" "${cxx_flags}" ${ARGN})
endfunction()

function(cxx_executable_with_flags name cxx_flags libs)
  add_executable(${name} ${ARGN})
  if (cxx_flags)
    set_target_properties(${name}
      PROPERTIES
      COMPILE_FLAGS "${cxx_flags}")
  endif()

  foreach (lib ${libs})
    target_link_libraries(${name} ${lib})
  endforeach()
endfunction()

function(cxx_executable name dir libs)
  cxx_executable_with_flags(${name} "${cxx_default}" "${libs}" "${dir}/${name}.cc" ${ARGN})
endfunction()

function(cxx_test_with_flags name cxx_flags libs)
  cxx_executable_with_flags(${name} "${cxx_flags}" "${libs}" ${ARGN})
  add_test(${name} ${name})
endfunction()

function(cxx_test name dir libs)
  cxx_test_with_flags("${name}" "${cxx_default}" "${libs}"
    "${dir}/${name}.cc" ${ARGN})
endfunction()

function(c_executable_with_flags name c_flags libs)
  add_executable(${name} ${ARGN})
  if (c_flags)
    set_target_properties(${name}
      PROPERTIES
      COMPILE_FLAGS "${c_flags}")
  endif()

  foreach (lib ${libs})
    target_link_libraries(${name} ${lib})
  endforeach()
endfunction()

function(c_executable name dir libs)
  c_executable_with_flags(${name} "${c_default}" "${libs}" "${dir}/${name}.c" ${ARGN})
endfunction()
