/*
 *
 * Copyright 2015, OpenIO
 *
 */

#ifndef OIOFS_INTERNAL_INODE_H_
#define OIOFS_INTERNAL_INODE_H_

#include <oio_core.h>

#include <sys/stat.h>

#include <map>
#include <string>
#include <atomic>

#include "src/page_list.h"

struct PageList;

struct Inode {
  explicit Inode(ino_t ino_no, struct oio_url_s *oio_url)
    : ino(ino_no), url(oio_url), mode(0), uid(0), gid(0), size(0),
      unflushed_size(0),
      atime(0), mtime(0), ctime(0), nlink(0), generation(0),
      refcount(0), dirty(false) {}

  ~Inode() {
    oio_url_pclean(&url);
  }

  /* Increment reference counter */
  void ref();
  /* Decrement reference counter by `count` and return the new value */
  int unref(int count = 1);

  bool is_dir() const {
    return (mode & S_IFMT) == S_IFDIR;
  }

  bool is_file() const {
    return (mode & S_IFMT) == S_IFREG;
  }

  bool is_symlink() const {
    return (mode & S_IFMT) == S_IFLNK;
  }

  void flush();

  ino_t ino;
  struct oio_url_s *url;

  uint32_t mode;
  uid_t uid;
  gid_t gid;
  uint64_t size;
  /* Size of the file to consider until the file metadata is flushed */
  uint64_t unflushed_size;

  uint32_t atime;
  uint32_t mtime;
  uint32_t ctime;

  int32_t nlink;

  std::string symlink;

  uint32_t generation;

  std::atomic_int refcount;

  PageList pagelist;

  /* True if some file handles have not been flushed */
  bool dirty;
};

#endif  // OIOFS_INTERNAL_INODE_H_
