/*
 *
 * Copyright 2015, OpenIO SAS
 *
 */

#include "src/meta/server.h"
#include <sys/stat.h>
#include <stdint.h>
#include <grpc++/grpc++.h>
#include <hiredis/hiredis.h>
#include <iostream>
#include <sstream>
#include <cstring>
#include <string>
#include "src/meta/service.h"

namespace oiofs {

Server::Server(std::shared_ptr<grpc::Server> grpc_server) {
  grpc_server_ = std::move(grpc_server);
}

void Server::Wait() {
  grpc_server_->Wait();
}

void Server::Shutdown() {
  grpc_server_->Shutdown();
}

}  // namespace oiofs
