/*
 *
 * Copyright 2015, OpenIO
 *
 */

#include "src/meta/server_builder.h"
#include <grpc++/grpc++.h>
#include "src/meta/service.h"

#include <string>
#include <sstream>

namespace oiofs {

ServerBuilder::ServerBuilder() : service_(nullptr) {}

ServerBuilder::~ServerBuilder() {
  if (service_ != nullptr)
    delete service_;
}

void ServerBuilder::AddListeningPort(std::string &addr) {
  addrs_.push_back(addr);
}

void ServerBuilder::SetRedisHost(std::string &addr) {
  // TODO(fvennetier): check we got an IP address, not a hostname
  redis_addr_ = addr;
}

void ServerBuilder::SetRedisPort(int port) {
  redis_port_ = port;
}

void ServerBuilder::AddSentinels(std::string &sentinels) {
  std::stringstream whole(sentinels);
  std::string item;
  while (std::getline(whole, item, ',')) {
    auto sep = item.find(':');
    if (sep != std::string::npos) {
      sentinels_.push_back(std::make_pair(item.substr(0, sep),
            std::stoi(item.substr(sep+1))));
    }
  }
}

void ServerBuilder::SetSentinelMasterName(std::string &master) {
  sentinel_master_name_ = master;
}

std::unique_ptr<Server> ServerBuilder::BuildAndStart() {
  grpc::ServerBuilder grpc_builder;
  for (auto addr = addrs_.begin(); addr != addrs_.end(); addr++) {
    grpc_builder.AddListeningPort(*addr, grpc::InsecureServerCredentials());
  }
  service_ = new MetaServiceImpl(redis_addr_, redis_port_,
      sentinels_, sentinel_master_name_);
  grpc_builder.RegisterService(service_);
  std::unique_ptr<grpc::Server> grpc_server(grpc_builder.BuildAndStart());

  std::unique_ptr<Server> server(new Server(std::move(grpc_server)));
  return server;
}

}  // namespace oiofs
