/*
 *
 * Copyright 2015, OpenIO
 *
 */

#ifndef OIOFS_INTERNAL_META_SERVER_BUILDER_H_
#define OIOFS_INTERNAL_META_SERVER_BUILDER_H_

#include <grpc++/grpc++.h>
#include <list>
#include <memory>
#include <string>
#include <utility>
#include <vector>
#include "src/meta/server.h"
#include "src/meta/service.h"

namespace oiofs {

class ServerBuilder {
 public:
  ServerBuilder();
  ~ServerBuilder();

  void AddListeningPort(std::string &addr);
  void SetRedisHost(std::string &addr);
  void SetRedisPort(int port);
  void AddSentinels(std::string &sentinels);
  void SetSentinelMasterName(std::string &master);
  std::unique_ptr<Server> BuildAndStart();

 private:
  std::vector<std::string> addrs_;
  std::string sentinel_master_name_;
  std::list<std::pair<std::string, int>> sentinels_;
  std::string redis_addr_;  // Must be an IP address, not a hostname
  int redis_port_;
  MetaService::Service *service_;
};
}  // namespace oiofs

#endif  // OIOFS_INTERNAL_META_SERVER_BUILDER_H_
