/*
 *
 * Copyright 2015, OpenIO SAS
 *
 */

#ifndef OIOFS_INTERNAL_META_SERVICE_H_
#define OIOFS_INTERNAL_META_SERVICE_H_

#define GLOG_NO_ABBREVIATED_SEVERITIES
#include <glog/logging.h>

#include <list>
#include <string>
#include <utility>
#include "./meta.grpc.pb.h"
#include "src/meta/backend.h"

namespace oiofs {

class MetaServiceImpl final : public MetaService::Service {
 public:
  explicit MetaServiceImpl(
      std::string redis_addr, int redis_port,
      std::list<std::pair<std::string, int>> sentinels,
      std::string sentinel_master_name) {
    backend_ = new Backend(redis_addr, redis_port,
        sentinels, sentinel_master_name);
  }
  ~MetaServiceImpl() {
    delete backend_;
  }

  grpc::Status Lookup(grpc::ServerContext *context, const LookupRequest *request,
      LookupReply *reply) override;

  grpc::Status Getattr(grpc::ServerContext *context, const GetattrRequest *request,
    GetattrReply *reply) override;

  grpc::Status Setattr(grpc::ServerContext *context, const SetattrRequest *request,
    SetattrReply *reply) override;

  grpc::Status Create(grpc::ServerContext* context, const CreateRequest* request,
      CreateReply *reply) override;

  grpc::Status Open(grpc::ServerContext* context, const OpenRequest* request,
      OpenReply *reply) override;

  grpc::Status Mkdir(grpc::ServerContext* context, const MkdirRequest* request,
      MkdirReply* reply) override;

  grpc::Status Mknod(grpc::ServerContext* context, const MknodRequest* request,
      MknodReply* reply) override;

  grpc::Status Symlink(grpc::ServerContext* context, const SymlinkRequest* request,
    SymlinkReply* reply) override;

  grpc::Status Link(grpc::ServerContext* context, const LinkRequest* request,
      LinkReply* reply) override;

  grpc::Status Unlink(grpc::ServerContext* context, const UnlinkRequest* request,
    UnlinkReply* reply) override;

  grpc::Status Rename(grpc::ServerContext* context, const RenameRequest* request,
      RenameReply* reply) override;

  grpc::Status Readdir(grpc::ServerContext* context, const ReaddirRequest* request,
      ReaddirReply* reply) override;

  grpc::Status Rmdir(grpc::ServerContext *context, const RmdirRequest *request,
      RmdirReply *reply) override;

  grpc::Status Flush(grpc::ServerContext *context, const FlushRequest *request,
      FlushReply *reply) override;

  grpc::Status Forget(grpc::ServerContext *context, const ForgetRequest *request,
      ForgetReply *reply) override;

  grpc::Status Mkfs(grpc::ServerContext *context, const MkfsRequest *request,
      MkfsReply *reply) override;

 private:
  Backend *backend_;
};

}  // namespace oiofs

#endif  // OIOFS_INTERNAL_META_SERVICE_H_
