/*
 *
 * Copyright 2015, OpenIO
 *
 */

#include <getopt.h>
#include <grpc++/grpc++.h>
#include <cstdlib>
#include <iostream>
#include <string>
#include "src/oiofs_defaults.h"
#include "src/meta/client.h"


void print_help(const char *prog_name) {
  printf("Usage: %s [OPTION]... CONTAINER_URL\n", prog_name);
  printf("\nOptions:\n");
  printf("\t-d, --debug             Enable debug traces (not implemented)\n");
  printf("\t-h, --help              Print this help\n");
  printf("\t-V, --version           Print version information\n");
  printf("\t-s, --oiofs-server      Force oiofs server address\n");
}

void print_version(const char *prog_name) {
  // TODO(fvennetier): generate version string
  printf("Not implemented\n");
}

int main(int argc, char *argv[]) {
  int rc = 0;
  int c;
  char srv_addr[256] = {0};

  static struct option long_options[] = {
    {"help", no_argument, nullptr, 'h'},
    {"verbose", no_argument, nullptr, 'v'},
    {"version", no_argument, nullptr, 'V'},
    {"oiofs-server", 1, nullptr, 's'},
    {0, 0, 0, 0}
  };

  google::InitGoogleLogging(argv[0]);

  while (1) {
    int option_index = 0;

    c = getopt_long(argc, argv, "hvVs:", long_options, &option_index);
    if (-1 == c) {
      break;
    }

    switch (c) {
    case 'v':
      fLI::FLAGS_v++;
      break;
    case 'h':
      print_help(argv[0]);
      exit(EXIT_SUCCESS);
    case 'V':
      print_version(argv[0]);
      exit(EXIT_SUCCESS);
    case 's':
      strncpy(srv_addr, optarg, sizeof(srv_addr));
      break;
    case '?':
      break;
    default:
      printf("?? getopt returned character code 0%o ??\n", c);
    }
  }

  if (optind >= argc) {
    printf("Missing argument CONTAINER_URL\n");
    print_help(argv[0]);
    exit(EXIT_FAILURE);
  }

  std::string container_url(argv[optind]);
  if (srv_addr != NULL && srv_addr[0] != '\0') {
    std::string srv_addr_str(srv_addr);
    rc = oiofs::mkfs(container_url, &srv_addr_str);
  } else {
    rc = oiofs::mkfs(container_url);
  }

  if (rc == 0) {
    printf("Successfully created filesystem for [%s]\n",
        container_url.c_str());
  }

  return rc;
}
