/*
 *
 * Copyright 2015, OpenIO
 *
 */

#include <oiofs/oiofs.h>
#include <sys/stat.h>
#include "src/meta/client.h"

struct oiofs_mount_info {
 public:
  oiofs_mount_info()
    : mounted_(false),
      client_(nullptr) {}

  ~oiofs_mount_info() {
    shutdown();
  }


  int init() {
    int result;

    // TODO(fvennetier): add constructor parameters
    client_ = new oiofs::Client();
    init_ = true;

    result = client_->Init();
    if (0 != result) {
      shutdown();
    } else {
      init_ = true;
    }
    return result;
  }

  int mount() {
    int result;

    if (!init_) {
      result = init();
      if (0 != result) {
        return result;
      }
    }

    result = client_->Mount();
    if (0 != result) {
      shutdown();
      return result;
    } else {
      mounted_ = true;
      return 0;
    }
  }

  int unmount() {
    if (!mounted_) {
      return -ENOTCONN;
    }
    shutdown();
    return 0;
  }

  void shutdown() {
    if (mounted_) {
      client_->Unmount();
      mounted_ = false;
    }

    if (init_) {
      client_->Shutdown();
      init_ = false;
    }

    if (client_) {
      delete client_;
      client_ = nullptr;
    }
  }

  bool is_initialized() const {
    return init_;
  }

  bool is_mounted() {
    return mounted_;
  }

  oiofs::Client* client() { return client_; }

 private:
  bool mounted_;
  bool init_;
  oiofs::Client* client_;
};

struct oiofs_dir_result {};

int oiofs_create(struct oiofs_mount_info** mount_info) {
  *mount_info = new oiofs_mount_info();
  return 0;
}

int oiofs_mount(struct oiofs_mount_info* mount_info) {
  return mount_info->mount();
}

int oiofs_unmount(struct oiofs_mount_info* mount_info) {
  return mount_info->unmount();
}

int oiofs_release(struct oiofs_mount_info* mount_info) {
  if (mount_info->is_mounted()) {
    return -EISCONN;
  }
  delete mount_info;
  return 0;
}

int oiofs_statfs(struct oiofs_mount_info* mount_info, const char* path, struct statvfs *stat_buf) {
  if (!mount_info->is_mounted())
    return -ENOTCONN;
  return 0;
}

int oiofs_stat(struct oiofs_mount_info* mount_info, const char* path, struct stat* stat_buf) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_fstat(struct oiofs_mount_info* mount_info, int fd, struct stat* stat_buf) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_unlink(struct oiofs_mount_info* mount_info, const char* path) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_rename(struct oiofs_mount_info* mount_info, const char* src, const char* dst) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_opendir(struct oiofs_mount_info* mount_info, const char* path,
    struct oiofs_dir_result **dir_result) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_mkdir(struct oiofs_mount_info* mount_info, const char* path, mode_t mode) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_rmdir(struct oiofs_mount_info* mount_info, const char* path) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_open(struct oiofs_mount_info* mount_info, Inode *in, int flags, mode_t mode,
    int uid, int gid, FileHandle **out) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return mount_info->client()->Open(in, flags, mode, uid, gid, out);
}

int oiofs_read(struct oiofs_mount_info* mount_info, int fd, char* buf, int64_t size,
    int64_t offset) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_write(struct oiofs_mount_info* mount_info, int fd, const char* buf, int64_t size,
    int64_t offset) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_close(struct oiofs_mount_info* mount_info, int fd) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_link(struct oiofs_mount_info *mount_info, const char *existing, const char *newname) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_symlink(struct oiofs_mount_info *mount_info, const char *existing, const char *newname) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_readlink(struct oiofs_mount_info *mount_info, const char *path, char *buf, int64_t size) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_setattr(struct oiofs_mount_info *mount_info, const char *path, struct stat *attr,
    int mask) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_chmod(struct oiofs_mount_info *mount_info, const char *path, mode_t mode) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}

int oiofs_chown(struct oiofs_mount_info *mount_info, const char *path, int uid, int gid) {
  if (!mount_info->is_mounted()) {
    return -ENOTCONN;
  }
  return 0;
}
