/*
 *
 * Copyright 2015, OpenIO
 *
 */

#ifndef OIOFS_PAGE_LIST_H_
#define OIOFS_PAGE_LIST_H_

#include <sys/types.h>
#include <list>

struct fdpage {
  off_t offset;
  size_t bytes;
  bool loaded;

  explicit fdpage(off_t start = 0, size_t size = 0, bool is_loaded = false)
    : offset(start), bytes(size), loaded(is_loaded) {}

  off_t next() const { return (offset + bytes); }
  off_t end() const { return (0 < bytes ? offset + bytes - 1 : 0); }
};

typedef std::list<struct fdpage*> fdpage_list_t;

class PageList {
 public:
  static void FreeList(fdpage_list_t& list);

  explicit PageList(size_t size = 0, bool is_loaded = false);
  ~PageList();

  bool Init(size_t size, bool is_loaded);
  size_t Size() const;
  bool Resize(size_t size, bool is_loaded);
  bool IsPageLoaded(off_t start = 0, size_t size = 0) const;
  bool SetPageLoadedStatus(off_t start, size_t size, bool is_loaded = true,
      bool is_compressed = true);
  bool FindUnloadedPage(off_t start, off_t& resstart, size_t& ressize) const;
  size_t GetTotalUnloadedPageSize(off_t start = 0, size_t size = 0) const;
  int GetUnloadedPages(fdpage_list_t& unloaded_list, off_t start = 0,
      size_t size = 0) const;

 private:
  fdpage_list_t pages;
  void Clear();
  bool Compress();
  /** Ensure there is a page starting at `new_pos` */
  bool Parse(off_t new_pos);
};

#endif  // OIOFS_PAGE_LIST_H_
