import json
import ansible.runner
import sys

SUPPORTED_IFACES = [
    "hd",  # IDE Hard Disk
    "sd",  # SCSI disk device
    "vd",  # Virtual disk
]


def run_system_diag():
    try:
        runner = ansible.runner.Runner(
            module_name='setup',
            module_args='',
            pattern='localhost',
            forks=1
        )
        result = runner.run()
        stats = json.dumps(result)
        stats = result["contacted"]["localhost"]["ansible_facts"]
    except:
        sys.exit(1)
    else:
        return(stats)


def get_system_info(stats):
    sysinfo = {}
    sysinfo["proc_cores"] = stats["ansible_processor_cores"]
    sysinfo["proc_count"] = stats["ansible_processor_count"]
    sysinfo["ram"] = stats["ansible_memtotal_mb"]
    sysinfo["ram"] = round(float(sysinfo["ram"]) / 1000) * 1000
    sysinfo["os_family"] = stats["ansible_os_family"]
    sysinfo["os_name"] = stats["ansible_distribution"]
    sysinfo["os_kernel"] = stats["ansible_kernel"]
    sysinfo["os_architecture"] = stats["ansible_architecture"]
    return sysinfo


def get_nw_interfaces(stats):
    ifinfo = []
    interfaces = stats["ansible_interfaces"]
    for inf in interfaces:
        if stats["ansible_"+inf].get("active", None):
            current_stat = stats["ansible_"+inf]
            if not current_stat.get("ipv4", False):
                continue
            ifinfo.append({
                'device': current_stat["device"],
                'ipv4_addr': current_stat["ipv4"]["address"],
                'ipv4_netmask': current_stat["ipv4"]["netmask"],
                'ipv4_network': current_stat["ipv4"]["network"],
                'type': current_stat["type"]
            })
    return ifinfo


def get_disk_info(stats):
    devices = list()
    for name, device in stats["ansible_devices"].iteritems():
        for iface in SUPPORTED_IFACES:
            if name.startswith(iface):
                device['name'] = name
                device['partition_set'] = list()
                for name, part in device['partitions'].iteritems():
                    part['name'] = name
                    device['partition_set'].append(part)
                del device['partitions']
                devices.append(device)
    mounts = stats["ansible_mounts"]
    return devices, mounts
