
# Installation

If you haven't installed the asn1c yet, read the [INSTALL](INSTALL) file for a
short installation guide.

# Documentation

For the list of asn1c command line options, see `asn1c -h` or `man asn1c`.

The comprehensive documentation on this compiler is in [asn1c-usage.pdf](doc/asn1c-usage.pdf).

If you are building the compiler from the sources, the PDFs reside
in the ./doc directory. Normally the file is installed together with the
README.md file you're reading right now.

Please also read the [FAQ](FAQ) file.

An excellent book on ASN.1 is written by Olivier Dubuisson:
"ASN.1 Communication between heterogeneous systems", ISBN:0-12-6333361-0.

# Quick start

(also check out [asn1c-quick.pdf](doc/asn1c-quick.pdf))

After building [and installing] the compiler (see INSTALL), you may use
the asn1c command to compile the ASN.1 specification:

    asn1c <module.asn1>                         # Compile module

If several specifications contain interdependencies, all of them must be
specified:

    asn1c <module1.asn1> <module2.asn1> ...     # Compile interdependent modules

If you are building the asn1c from the sources, the ./examples directory
contains several ASN.1 modules and a script to extract the ASN.1 modules
from RFC documents. Refer to the README file in that directory.
To compile the X.509 PKI module:

    ./asn1c/asn1c -P ./examples/rfc3280-*.asn1  # Compile-n-print

In this example, -P option is used to instruct the compiler to print the
compiled text on the standard output instead of creating multiple .c
and .h files for every ASN.1 type found inside the specified ASN.1 modules.
This is useful for debugging and test automation.

The compiler -E and -EF options are used for testing the parser and
the semantic fixer, respectively. These options will instruct the compiler
to dump out the parsed (and fixed) ASN.1 specification as it was
"understood" by the compiler. It might be useful for checking
whether a particular syntactic construction is properly supported
by the compiler.

    asn1c -EF <module-to-test.asn1>     # Check semantic validity

# Model of operation

The asn1c compiler works by processing the ASN.1 module specifications
in several stages:

1. In the first stage, the ASN.1 file is parsed.
   (Parsing produces an ASN.1 syntax tree for the subsequent levels)
2. In the second stage, the syntax tree is "fixed".
   (Fixing is a process of checking the tree for semantic errors,
   accompanied by the tree transformation into the canonical form)
3. In the third stage, the syntax tree is compiled into the target language.

There are several command-line options reserved for printing the results
after each stage of operation:

    <parser> => print                                       (-E)
    <parser> => <fixer> => print                            (-E -F)
    <parser> => <fixer> => <compiler> => print              (-P)
    <parser> => <fixer> => <compiler> => save-compiled      [default]


-- 
Lev Walkin
vlm@lionet.info
