<!--This file was generated from the python source
Please edit the source to make changes
-->
RabbitMQCollector
=====

Collects data from RabbitMQ through the admin interface

#### Notes
  ** With added support for breaking down queue metrics by vhost, we have
     attempted to keep results generated by existing configurations from
     changing. This means that the old behaviour of clobbering queue metrics
     when a single queue name exists in multiple vhosts still exists if the
     configuration is not updated. If no vhosts block is defined it will also
     keep the metric path as it was historically with no vhost name in it.

        old path => systems.myServer.rabbitmq.queues.myQueue.*
        new path => systems.myServer.rabbitmq.myVhost.queues.myQueue.*

  ** If a [vhosts] section exists but is empty, then no queues will be polled.
  ** To poll all vhosts and all queues, add the following.
  **   [vhosts]
  **   * = *
  **

#### Options

Setting | Default | Description | Type
--------|---------|-------------|-----
byte_unit | byte | Default numeric output(s) | str
cluster | False | If this node is part of a cluster, will collect metrics on the cluster health | bool
enabled | False | Enable collecting these metrics | bool
host | localhost:55672 | Hostname and port to collect from | str
measure_collector_time | False | Collect the collector run time in ms | bool
metrics_blacklist | None | Regex to match metrics to block. Mutually exclusive with metrics_whitelist | NoneType
metrics_whitelist | None | Regex to match metrics to transmit. Mutually exclusive with metrics_blacklist | NoneType
password | guest | Password | str
queues |  | Queues to publish. Leave empty to publish all. | 
queues_ignored |  | A list of queues or regexes for queue names not to report on. | str
replace_dot | False | A value to replace dot in queue names and vhosts names by | bool
replace_slash | False | A value to replace a slash in queue names and vhosts names by | bool
user | guest | Username | str
vhosts |  | A list of vhosts and queues for which we want to collect | 

#### Example Output

```
servers.hostname.rabbitmq.cluster.nodes 3
servers.hostname.rabbitmq.cluster.partitions 0
servers.hostname.rabbitmq.health.disk_free 1
servers.hostname.rabbitmq.health.disk_free_limit 1
servers.hostname.rabbitmq.health.fd_total 2
servers.hostname.rabbitmq.health.fd_used 1
servers.hostname.rabbitmq.health.mem_limit 4
servers.hostname.rabbitmq.health.mem_used 2
servers.hostname.rabbitmq.health.proc_total 1
servers.hostname.rabbitmq.health.proc_used 1
servers.hostname.rabbitmq.health.sockets_total 2
servers.hostname.rabbitmq.health.sockets_used 1
servers.hostname.rabbitmq.key 4
servers.hostname.rabbitmq.more_keys.nested_key 3
servers.hostname.rabbitmq.queues.test_queue.key 2
servers.hostname.rabbitmq.queues.test_queue.more_keys.nested_key 1
```

