#OpenIO Gridadmin Tools
======================

## Description:

OpenIO gridadmin tools provides a set of scripts aimed towards interaction
between the nodes and the dashboard, as well as a mean to register new servers
on the dashboard in the first place.

## Setup:

This module runs on Python 2.7 and requires bash to be installed;

Dependencies:

- Ansible ~1.9, < 2.0 (1.9.4, 1.9.6 tested)
- Requests: ~2.6

To install:

```sh
$ python setup.py
```

## Prerequisites:

Here is a list of steps to check before running the registration script:

1. Make sure the ssh server is up and running
```sh
$ systemctl status sshd
```

2. Make sure the configuration settings match the ones you have set in the dashboard's
conf.cfg. Look for [ANSIBLE] Module and make sure you the ssh service is running on the same port
```sh
$ sudo netstat -lnpa | grep :[port]
```

3. Make sure the user defined in ssh_user in conf.cfg exists. If not, create it:

```sh
$ id -u [user]

$ useradd -m [user]
```

4. Make sure the configured authorized_keys file is present and has the right permissions.
By default, the file is located in /home/[user]/.ssh/authorized_keys:

```sh
$ chmod 600 /home/[user]/.ssh/authorized_keys
$ chmod 700 /home/[user]/.ssh/
```

5. Make sure the user is either in the sudoers file or is root. Moreover in the first case, make
sure that the user can sudo without password:

```sh
cat /etc/sudoers | grep [user]
[user] ALL=(ALL)       NOPASSWD:ALL
```

6. On the admin machine (where the dashboard is), make sure that this line is UNCOMMENTED in /etc/ansible/ansible.cfg:

```sh
$ cat /etc/ansible/ansible.cfg | grep host_key_checking
host_key_checking = False
```

7. Make sure that the hostname of the node is less than 40 characters long. Usually, you would
want a short hostname (up to 8 characters), in order for it to display properly on the dashboard

```sh
$ hostname [host]
```

## Usage

Most of the scripts are not to be interacted with manually. However, in order
for the dashboard to interact with the nodes, you will need to first register
the server. The provided script will help you with that.

General use
```
$ oio-ga-tools-register (options) [host]
```
This will assume the dashboard runs on [host] port 80.

> Advanced example using SSL and a custom port/interface
```
$ oio-ga-tools-register -i eth0 -p 8000 -s 192.168.50.1
```
> This will attempt to register the node with the primary interface **eth0** on a
> dashboard running SSL at 192.168.50.1:8000

Options:

- (-p, --port): Allows to specify a port on which the dashboard is RUNNING
- (-i, --iface): Manually select the primary network interface. By default, the one used to
send the request will be set.
- (-f, --file): Allows to specify the location of the authorized_keys file used to add the ssh public key of the dashboard on the server.  By default, /home/[current_user]/.ssh/authorized_keys will be used.
- (-s, --secure): Contact the administration server in secure mode (using SSL)
