import os
import simplejson as json
from shlex import shlex
from glob import glob
from gridadmin_tools.utils import run_shell


class Migration(object):
    """
        Namespace import V1 utility
        This is obsolete, please use V2 instead
    """

    namespace = None

    def __init__(self, namespace, key, location=None):
        self.namespace = namespace
        self.key = key
        self.location = location

    def _get_local_services(self, namespace):
        return run_shell(['openio', 'cluster', 'local', 'list',
                                        '-f', 'json', '--oio-ns', namespace])

    def _get_cluster_services(self, namespace):
        return run_shell(['openio', 'cluster', 'local', 'conf',
                                        '-f', 'json', '--oio-ns', namespace])

    def _get_namespace_conf(self, namespace):
        return run_shell(['openio', 'cluster', 'show',
                                        '-f', 'json', '--oio-ns', namespace])

    def _get_local_gridinit_data(self, namespace):
        return run_shell(['gridinit_cmd', 'status2', '@%s' % namespace])

    def _get_lsof_output(self):
        cmd = 'lsof -i -P | grep LISTEN | grep openio'
        return run_shell(cmd, shell=True)

    def _get_misc_data(self, namespace):
        # Try to fetch random files to get missing config for redis mainly
        # Maybe needs to be completed
        # TODO: Error handling, ZK
        extra_data = {"ports": {}, "zookeeper": {"port_ranges": []}}
        if self.location:
            conf_dir = self.loc.get('sysconfdir', None)
            if conf_dir:
                base_path = os.path.join(os.path.abspath(conf_dir), namespace)
        else:
            base_path = os.path.join("/etc/oio/sds", namespace)

        # Redis/ Redissentinel
        files = glob("%s/redis*/redis*.conf" % (base_path))
        if len(files) > 1:
            for cfile in files:
                with open(cfile) as f:
                    sc_type = "redis"
                    if "redissentinel" in cfile:
                        sc_type = "redissentinel"
                    for line in f:
                        if line.startswith("port "):
                            extra_data['ports'][sc_type] = line.split(' ')[1]
                            break
        # Zookeeper
        files = glob("%s/zookeeper*/zoo.cfg" % base_path)

        if len(files) > 0:
            with open(files[0]) as f:
                for line in f:
                    if line.startswith("clientPort="):
                        extra_data['zookeeper']["client_port"]\
                            = line.split('=')[1]
                    elif line.startswith("server."):
                        extra_data['zookeeper']['port_ranges'].append(line)
        return extra_data

    def _kvparse(self, it):  # TODO: move to utils
        it = iter(it)
        while True:
            a = next(it)
            next(it)
            b = next(it)
            yield a, b

    def _get_location(self, location):
        with open(os.path.abspath(location)) as f:
            return dict((k, v) for k, v in self._kvparse(shlex(f.read())))

    def get(self):
        data = dict(
            grid=self._get_local_gridinit_data(self.namespace),
            lsof=self._get_lsof_output(),
            cluster=json.loads(self._get_cluster_services(self.namespace)),
            local=json.loads(self._get_local_services(self.namespace)),
            ns_conf=json.loads(self._get_namespace_conf(self.namespace)),
            extra=self._get_misc_data(self.namespace),
            key=self.key
        )
        if self.location:
            self.loc = json.dumps(self._get_location(self.location))
            data['location'] = json.loads(self.loc)
        return data
