import json
import os
from gridadmin_tools.utils import run_shell

SUPPORTED_IFACES = [
    "hd",  # IDE Hard Disk
    "sd",  # SCSI disk device
    "vd",  # Virtual disk
    "xvd",  # Xen virtual disk
    "nvme"  # NVME volume
]


def run_system_diag():
    if not os.path.exists('/etc/ansible/hosts'):
        raise Exception("File /etc/ansible/hosts not found. Please create one to proceed")
    data = run_shell(['ansible', 'localhost', '-m', 'setup'])
    try:
        data = data.split('localhost | success >> ')
        if len(data) == 1:
            data = data[0].split('localhost | SUCCESS => ')
        data = json.loads(data[1])
    except Exception as e:
        raise Exception("An error occured when parsing ansible facts: %s" % e)

    return data['ansible_facts']


def get_system_info(stats):
    sysinfo = {}
    sysinfo["proc_cores"] = stats["ansible_processor_cores"]
    sysinfo["proc_count"] = stats["ansible_processor_count"]
    sysinfo["ram"] = stats["ansible_memtotal_mb"]
    sysinfo["ram"] = round(float(sysinfo["ram"]) / 1000) * 1000
    sysinfo["os_family"] = stats["ansible_os_family"]
    sysinfo["os_name"] = stats["ansible_distribution"]
    sysinfo["os_kernel"] = stats["ansible_kernel"]
    sysinfo["os_architecture"] = stats["ansible_architecture"]
    sysinfo["virt_type"] = stats.get('ansible_virtualization_type', None)
    sysinfo["memtotal"] = stats.get('ansible_memtotal_mb', 0)
    return sysinfo


def get_nw_interfaces(stats):
    ifinfo = []
    interfaces = stats["ansible_interfaces"]
    for inf in interfaces:
        if stats.get("ansible_%s" % inf) and \
                stats["ansible_%s" % inf].get("active", None):
            current_stat = stats["ansible_"+inf]
            if not current_stat.get("ipv4", False):
                continue
            ifinfo.append({
                'device': current_stat["device"],
                'ipv4_addr': current_stat["ipv4"]["address"],
                'ipv4_netmask': current_stat["ipv4"]["netmask"],
                'ipv4_network': current_stat["ipv4"]["network"],
                'type': current_stat["type"]
            })
    return ifinfo


def get_disk_info(stats):
    devices = list()
    for name, device in stats["ansible_devices"].iteritems():
        for iface in SUPPORTED_IFACES:
            if name.startswith(iface):
                device['name'] = name
                device['partition_set'] = list()
                for name, part in device['partitions'].iteritems():
                    part['name'] = name
                    device['partition_set'].append(part)
                del device['partitions']
                devices.append(device)
    mounts = stats["ansible_mounts"]
    for i, m in enumerate(mounts):
        if m['uuid'] == "":
            mounts[i]['uuid'] = "NA"
    return (devices, mounts,)
