from optparse import OptionParser
from requests import post
from requests.exceptions import HTTPError
import simplejson as json
import subprocess
import os

HTTP_REQUEST_TIMEOUT = 1000


def make_parser(arg_list, remove_null=False):
    """
        Creates a basic option parser from argument list
    """
    parser = OptionParser()

    for el in arg_list:
        if not isinstance(el, tuple):
            raise ValueError("You need to declare options as tuples")
        if not len(el) == 3:
            raise ValueError("Not enough info for option %s" % el['name'])
        if el[0].startswith(str(':')):
            parser.add_option("-%s" % el[0][1], "--%s" % el[0][1:],
                              help=el[1], action="store_true")
        else:
            try:
                parser.add_option('-%s' % el[0][0], '--%s' % el[0],
                                  dest=el[0], help=el[1],
                                  metavar=el[0])
            except ValueError as e:
                raise e

    (args, opts) = parser.parse_args()
    args = vars(args)

    for opt in arg_list:
        if opt[2] and not args.get(opt[0], None):
            raise ValueError("Option --%s/-%s is required"
                             % (opt[0], opt[0][0]))
        elif remove_null and args.get(opt[0], False) is None:
            del args[opt[0]]

    return (args, opts)


def make_request(host, port=80, route=str(), data={}, secure=False):
    """
        Makes a POST request to the provided host/port and returns
        the result if successful
    """
    PREFIX = str('https') if secure else str('http')
    if port == 80 and secure:
        port = 443
    url = "%s://%s:%s/%s" % (PREFIX, host, port, route)
    headers = {'Content-Type': 'application/json'}
    res = post(url, headers=headers, data=json.dumps(data), timeout=HTTP_REQUEST_TIMEOUT)
    if res.status_code / 100 != 2:
        raise HTTPError("\nERROR [%s] %s \n%s" % (res.status_code, url, res.text))
    return res


def run_shell(cmd, throw=True, buffer=True, env=None, shell=False):
    """
        Shamelessly adapted from the PBR module
    """
    if buffer:
        out_location = subprocess.PIPE
        err_location = subprocess.PIPE
    else:
        out_location = None
        err_location = None

    newenv = os.environ.copy()
    if env:
        newenv.update(env)
    try:
        output = subprocess.Popen(cmd, stdout=out_location,
                                  stderr=err_location, env=newenv, shell=shell)
    except Exception as e:
        if throw:
            raise e
        else:
            return None
    out = output.communicate()
    if output.returncode and throw:
        raise Exception("%s returned %d" % (cmd, output.returncode))
    if len(out) == 0 or not out[0] or not out[0].strip():
        return ''
    return out[0].strip().decode('utf-8', 'replace')
