# -*- ruby -*-
# encoding: utf-8
$LOAD_PATH.push File.expand_path('../src/ruby/lib', __FILE__)
require 'grpc/version'

Gem::Specification.new do |s|
  s.name          = 'grpc'
  s.version       = GRPC::VERSION
  s.authors       = ['gRPC Authors']
  s.email         = 'temiola@google.com'
  s.homepage      = 'https://github.com/google/grpc/tree/master/src/ruby'
  s.summary       = 'GRPC system in Ruby'
  s.description   = 'Send RPCs from Ruby using GRPC'
  s.license       = 'BSD-3-Clause'

  s.required_ruby_version = '>= 2.0.0'

  s.files = %w( Makefile .yardopts )
  s.files += %w( etc/roots.pem )
  s.files += Dir.glob('src/ruby/bin/**/*')
  s.files += Dir.glob('src/ruby/ext/**/*')
  s.files += Dir.glob('src/ruby/lib/**/*')
  s.files += Dir.glob('src/ruby/pb/**/*')
  s.files += Dir.glob('include/grpc/**/*')
  s.test_files = Dir.glob('src/ruby/spec/**/*')
  s.bindir = 'src/ruby/bin'
  s.require_paths = %w( src/ruby/bin src/ruby/lib src/ruby/pb )
  s.platform      = Gem::Platform::RUBY

  s.add_dependency 'google-protobuf', '~> 3.0.2'
  s.add_dependency 'googleauth',      '~> 0.5.1'

  s.add_development_dependency 'bundler',            '~> 1.9'
  s.add_development_dependency 'facter',             '~> 2.4'
  s.add_development_dependency 'logging',            '~> 2.0'
  s.add_development_dependency 'simplecov',          '~> 0.9'
  s.add_development_dependency 'rake',               '~> 10.4'
  s.add_development_dependency 'rake-compiler',      '~> 0.9'
  s.add_development_dependency 'rake-compiler-dock', '~> 0.5.1'
  s.add_development_dependency 'rspec',              '~> 3.2'
  s.add_development_dependency 'rubocop',            '~> 0.30.0'
  s.add_development_dependency 'signet',             '~> 0.7.0'

  s.extensions = %w(src/ruby/ext/grpc/extconf.rb)

  s.files += %w( include/grpc/support/alloc.h )
  s.files += %w( include/grpc/support/atm.h )
  s.files += %w( include/grpc/support/atm_gcc_atomic.h )
  s.files += %w( include/grpc/support/atm_gcc_sync.h )
  s.files += %w( include/grpc/support/atm_windows.h )
  s.files += %w( include/grpc/support/avl.h )
  s.files += %w( include/grpc/support/cmdline.h )
  s.files += %w( include/grpc/support/cpu.h )
  s.files += %w( include/grpc/support/histogram.h )
  s.files += %w( include/grpc/support/host_port.h )
  s.files += %w( include/grpc/support/log.h )
  s.files += %w( include/grpc/support/log_windows.h )
  s.files += %w( include/grpc/support/port_platform.h )
  s.files += %w( include/grpc/support/slice.h )
  s.files += %w( include/grpc/support/slice_buffer.h )
  s.files += %w( include/grpc/support/string_util.h )
  s.files += %w( include/grpc/support/subprocess.h )
  s.files += %w( include/grpc/support/sync.h )
  s.files += %w( include/grpc/support/sync_generic.h )
  s.files += %w( include/grpc/support/sync_posix.h )
  s.files += %w( include/grpc/support/sync_windows.h )
  s.files += %w( include/grpc/support/thd.h )
  s.files += %w( include/grpc/support/time.h )
  s.files += %w( include/grpc/support/tls.h )
  s.files += %w( include/grpc/support/tls_gcc.h )
  s.files += %w( include/grpc/support/tls_msvc.h )
  s.files += %w( include/grpc/support/tls_pthread.h )
  s.files += %w( include/grpc/support/useful.h )
  s.files += %w( include/grpc/impl/codegen/alloc.h )
  s.files += %w( include/grpc/impl/codegen/atm.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_atomic.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_sync.h )
  s.files += %w( include/grpc/impl/codegen/atm_windows.h )
  s.files += %w( include/grpc/impl/codegen/log.h )
  s.files += %w( include/grpc/impl/codegen/port_platform.h )
  s.files += %w( include/grpc/impl/codegen/slice.h )
  s.files += %w( include/grpc/impl/codegen/slice_buffer.h )
  s.files += %w( include/grpc/impl/codegen/sync.h )
  s.files += %w( include/grpc/impl/codegen/sync_generic.h )
  s.files += %w( include/grpc/impl/codegen/sync_posix.h )
  s.files += %w( include/grpc/impl/codegen/sync_windows.h )
  s.files += %w( include/grpc/impl/codegen/time.h )
  s.files += %w( src/core/lib/profiling/timers.h )
  s.files += %w( src/core/lib/support/backoff.h )
  s.files += %w( src/core/lib/support/block_annotate.h )
  s.files += %w( src/core/lib/support/env.h )
  s.files += %w( src/core/lib/support/murmur_hash.h )
  s.files += %w( src/core/lib/support/stack_lockfree.h )
  s.files += %w( src/core/lib/support/string.h )
  s.files += %w( src/core/lib/support/string_windows.h )
  s.files += %w( src/core/lib/support/thd_internal.h )
  s.files += %w( src/core/lib/support/time_precise.h )
  s.files += %w( src/core/lib/support/tmpfile.h )
  s.files += %w( src/core/lib/profiling/basic_timers.c )
  s.files += %w( src/core/lib/profiling/stap_timers.c )
  s.files += %w( src/core/lib/support/alloc.c )
  s.files += %w( src/core/lib/support/avl.c )
  s.files += %w( src/core/lib/support/backoff.c )
  s.files += %w( src/core/lib/support/cmdline.c )
  s.files += %w( src/core/lib/support/cpu_iphone.c )
  s.files += %w( src/core/lib/support/cpu_linux.c )
  s.files += %w( src/core/lib/support/cpu_posix.c )
  s.files += %w( src/core/lib/support/cpu_windows.c )
  s.files += %w( src/core/lib/support/env_linux.c )
  s.files += %w( src/core/lib/support/env_posix.c )
  s.files += %w( src/core/lib/support/env_windows.c )
  s.files += %w( src/core/lib/support/histogram.c )
  s.files += %w( src/core/lib/support/host_port.c )
  s.files += %w( src/core/lib/support/log.c )
  s.files += %w( src/core/lib/support/log_android.c )
  s.files += %w( src/core/lib/support/log_linux.c )
  s.files += %w( src/core/lib/support/log_posix.c )
  s.files += %w( src/core/lib/support/log_windows.c )
  s.files += %w( src/core/lib/support/murmur_hash.c )
  s.files += %w( src/core/lib/support/slice.c )
  s.files += %w( src/core/lib/support/slice_buffer.c )
  s.files += %w( src/core/lib/support/stack_lockfree.c )
  s.files += %w( src/core/lib/support/string.c )
  s.files += %w( src/core/lib/support/string_posix.c )
  s.files += %w( src/core/lib/support/string_util_windows.c )
  s.files += %w( src/core/lib/support/string_windows.c )
  s.files += %w( src/core/lib/support/subprocess_posix.c )
  s.files += %w( src/core/lib/support/subprocess_windows.c )
  s.files += %w( src/core/lib/support/sync.c )
  s.files += %w( src/core/lib/support/sync_posix.c )
  s.files += %w( src/core/lib/support/sync_windows.c )
  s.files += %w( src/core/lib/support/thd.c )
  s.files += %w( src/core/lib/support/thd_posix.c )
  s.files += %w( src/core/lib/support/thd_windows.c )
  s.files += %w( src/core/lib/support/time.c )
  s.files += %w( src/core/lib/support/time_posix.c )
  s.files += %w( src/core/lib/support/time_precise.c )
  s.files += %w( src/core/lib/support/time_windows.c )
  s.files += %w( src/core/lib/support/tls_pthread.c )
  s.files += %w( src/core/lib/support/tmpfile_msys.c )
  s.files += %w( src/core/lib/support/tmpfile_posix.c )
  s.files += %w( src/core/lib/support/tmpfile_windows.c )
  s.files += %w( src/core/lib/support/wrap_memcpy.c )
  s.files += %w( include/grpc/byte_buffer.h )
  s.files += %w( include/grpc/byte_buffer_reader.h )
  s.files += %w( include/grpc/compression.h )
  s.files += %w( include/grpc/grpc.h )
  s.files += %w( include/grpc/grpc_posix.h )
  s.files += %w( include/grpc/grpc_security_constants.h )
  s.files += %w( include/grpc/status.h )
  s.files += %w( include/grpc/impl/codegen/byte_buffer.h )
  s.files += %w( include/grpc/impl/codegen/byte_buffer_reader.h )
  s.files += %w( include/grpc/impl/codegen/compression_types.h )
  s.files += %w( include/grpc/impl/codegen/connectivity_state.h )
  s.files += %w( include/grpc/impl/codegen/grpc_types.h )
  s.files += %w( include/grpc/impl/codegen/propagation_bits.h )
  s.files += %w( include/grpc/impl/codegen/status.h )
  s.files += %w( include/grpc/impl/codegen/alloc.h )
  s.files += %w( include/grpc/impl/codegen/atm.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_atomic.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_sync.h )
  s.files += %w( include/grpc/impl/codegen/atm_windows.h )
  s.files += %w( include/grpc/impl/codegen/log.h )
  s.files += %w( include/grpc/impl/codegen/port_platform.h )
  s.files += %w( include/grpc/impl/codegen/slice.h )
  s.files += %w( include/grpc/impl/codegen/slice_buffer.h )
  s.files += %w( include/grpc/impl/codegen/sync.h )
  s.files += %w( include/grpc/impl/codegen/sync_generic.h )
  s.files += %w( include/grpc/impl/codegen/sync_posix.h )
  s.files += %w( include/grpc/impl/codegen/sync_windows.h )
  s.files += %w( include/grpc/impl/codegen/time.h )
  s.files += %w( include/grpc/grpc_security.h )
  s.files += %w( include/grpc/census.h )
  s.files += %w( src/core/lib/channel/channel_args.h )
  s.files += %w( src/core/lib/channel/channel_stack.h )
  s.files += %w( src/core/lib/channel/channel_stack_builder.h )
  s.files += %w( src/core/lib/channel/compress_filter.h )
  s.files += %w( src/core/lib/channel/connected_channel.h )
  s.files += %w( src/core/lib/channel/context.h )
  s.files += %w( src/core/lib/channel/http_client_filter.h )
  s.files += %w( src/core/lib/channel/http_server_filter.h )
  s.files += %w( src/core/lib/compression/algorithm_metadata.h )
  s.files += %w( src/core/lib/compression/message_compress.h )
  s.files += %w( src/core/lib/debug/trace.h )
  s.files += %w( src/core/lib/http/format_request.h )
  s.files += %w( src/core/lib/http/httpcli.h )
  s.files += %w( src/core/lib/http/parser.h )
  s.files += %w( src/core/lib/iomgr/closure.h )
  s.files += %w( src/core/lib/iomgr/endpoint.h )
  s.files += %w( src/core/lib/iomgr/endpoint_pair.h )
  s.files += %w( src/core/lib/iomgr/error.h )
  s.files += %w( src/core/lib/iomgr/ev_epoll_linux.h )
  s.files += %w( src/core/lib/iomgr/ev_poll_and_epoll_posix.h )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.h )
  s.files += %w( src/core/lib/iomgr/ev_posix.h )
  s.files += %w( src/core/lib/iomgr/exec_ctx.h )
  s.files += %w( src/core/lib/iomgr/executor.h )
  s.files += %w( src/core/lib/iomgr/iocp_windows.h )
  s.files += %w( src/core/lib/iomgr/iomgr.h )
  s.files += %w( src/core/lib/iomgr/iomgr_internal.h )
  s.files += %w( src/core/lib/iomgr/iomgr_posix.h )
  s.files += %w( src/core/lib/iomgr/load_file.h )
  s.files += %w( src/core/lib/iomgr/network_status_tracker.h )
  s.files += %w( src/core/lib/iomgr/polling_entity.h )
  s.files += %w( src/core/lib/iomgr/pollset.h )
  s.files += %w( src/core/lib/iomgr/pollset_set.h )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.h )
  s.files += %w( src/core/lib/iomgr/pollset_windows.h )
  s.files += %w( src/core/lib/iomgr/resolve_address.h )
  s.files += %w( src/core/lib/iomgr/sockaddr.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_posix.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_utils.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_windows.h )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.h )
  s.files += %w( src/core/lib/iomgr/socket_windows.h )
  s.files += %w( src/core/lib/iomgr/tcp_client.h )
  s.files += %w( src/core/lib/iomgr/tcp_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_server.h )
  s.files += %w( src/core/lib/iomgr/tcp_windows.h )
  s.files += %w( src/core/lib/iomgr/time_averaged_stats.h )
  s.files += %w( src/core/lib/iomgr/timer.h )
  s.files += %w( src/core/lib/iomgr/timer_heap.h )
  s.files += %w( src/core/lib/iomgr/udp_server.h )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.h )
  s.files += %w( src/core/lib/iomgr/workqueue.h )
  s.files += %w( src/core/lib/iomgr/workqueue_posix.h )
  s.files += %w( src/core/lib/iomgr/workqueue_windows.h )
  s.files += %w( src/core/lib/json/json.h )
  s.files += %w( src/core/lib/json/json_common.h )
  s.files += %w( src/core/lib/json/json_reader.h )
  s.files += %w( src/core/lib/json/json_writer.h )
  s.files += %w( src/core/lib/surface/api_trace.h )
  s.files += %w( src/core/lib/surface/call.h )
  s.files += %w( src/core/lib/surface/call_test_only.h )
  s.files += %w( src/core/lib/surface/channel.h )
  s.files += %w( src/core/lib/surface/channel_init.h )
  s.files += %w( src/core/lib/surface/channel_stack_type.h )
  s.files += %w( src/core/lib/surface/completion_queue.h )
  s.files += %w( src/core/lib/surface/event_string.h )
  s.files += %w( src/core/lib/surface/init.h )
  s.files += %w( src/core/lib/surface/lame_client.h )
  s.files += %w( src/core/lib/surface/server.h )
  s.files += %w( src/core/lib/transport/byte_stream.h )
  s.files += %w( src/core/lib/transport/connectivity_state.h )
  s.files += %w( src/core/lib/transport/metadata.h )
  s.files += %w( src/core/lib/transport/metadata_batch.h )
  s.files += %w( src/core/lib/transport/static_metadata.h )
  s.files += %w( src/core/lib/transport/transport.h )
  s.files += %w( src/core/lib/transport/transport_impl.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_table.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_errors.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/incoming_metadata.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/internal.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/status_conversion.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_map.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/timeout_encoding.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.h )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.h )
  s.files += %w( src/core/lib/security/context/security_context.h )
  s.files += %w( src/core/lib/security/credentials/composite/composite_credentials.h )
  s.files += %w( src/core/lib/security/credentials/credentials.h )
  s.files += %w( src/core/lib/security/credentials/fake/fake_credentials.h )
  s.files += %w( src/core/lib/security/credentials/google_default/google_default_credentials.h )
  s.files += %w( src/core/lib/security/credentials/iam/iam_credentials.h )
  s.files += %w( src/core/lib/security/credentials/jwt/json_token.h )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_credentials.h )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_verifier.h )
  s.files += %w( src/core/lib/security/credentials/oauth2/oauth2_credentials.h )
  s.files += %w( src/core/lib/security/credentials/plugin/plugin_credentials.h )
  s.files += %w( src/core/lib/security/credentials/ssl/ssl_credentials.h )
  s.files += %w( src/core/lib/security/transport/auth_filters.h )
  s.files += %w( src/core/lib/security/transport/handshake.h )
  s.files += %w( src/core/lib/security/transport/secure_endpoint.h )
  s.files += %w( src/core/lib/security/transport/security_connector.h )
  s.files += %w( src/core/lib/security/transport/tsi_error.h )
  s.files += %w( src/core/lib/security/util/b64.h )
  s.files += %w( src/core/lib/security/util/json_util.h )
  s.files += %w( src/core/lib/tsi/fake_transport_security.h )
  s.files += %w( src/core/lib/tsi/ssl_transport_security.h )
  s.files += %w( src/core/lib/tsi/ssl_types.h )
  s.files += %w( src/core/lib/tsi/transport_security.h )
  s.files += %w( src/core/lib/tsi/transport_security_interface.h )
  s.files += %w( src/core/ext/client_config/client_channel.h )
  s.files += %w( src/core/ext/client_config/client_channel_factory.h )
  s.files += %w( src/core/ext/client_config/client_config.h )
  s.files += %w( src/core/ext/client_config/connector.h )
  s.files += %w( src/core/ext/client_config/initial_connect_string.h )
  s.files += %w( src/core/ext/client_config/lb_policy.h )
  s.files += %w( src/core/ext/client_config/lb_policy_factory.h )
  s.files += %w( src/core/ext/client_config/lb_policy_registry.h )
  s.files += %w( src/core/ext/client_config/parse_address.h )
  s.files += %w( src/core/ext/client_config/resolver.h )
  s.files += %w( src/core/ext/client_config/resolver_factory.h )
  s.files += %w( src/core/ext/client_config/resolver_registry.h )
  s.files += %w( src/core/ext/client_config/subchannel.h )
  s.files += %w( src/core/ext/client_config/subchannel_call_holder.h )
  s.files += %w( src/core/ext/client_config/subchannel_index.h )
  s.files += %w( src/core/ext/client_config/uri_parser.h )
  s.files += %w( src/core/ext/lb_policy/grpclb/load_balancer_api.h )
  s.files += %w( src/core/ext/lb_policy/grpclb/proto/grpc/lb/v1/load_balancer.pb.h )
  s.files += %w( third_party/nanopb/pb.h )
  s.files += %w( third_party/nanopb/pb_common.h )
  s.files += %w( third_party/nanopb/pb_decode.h )
  s.files += %w( third_party/nanopb/pb_encode.h )
  s.files += %w( src/core/ext/load_reporting/load_reporting.h )
  s.files += %w( src/core/ext/load_reporting/load_reporting_filter.h )
  s.files += %w( src/core/ext/census/aggregation.h )
  s.files += %w( src/core/ext/census/census_interface.h )
  s.files += %w( src/core/ext/census/census_rpc_stats.h )
  s.files += %w( src/core/ext/census/gen/census.pb.h )
  s.files += %w( src/core/ext/census/grpc_filter.h )
  s.files += %w( src/core/ext/census/mlog.h )
  s.files += %w( src/core/ext/census/rpc_metric_id.h )
  s.files += %w( src/core/lib/surface/init.c )
  s.files += %w( src/core/lib/channel/channel_args.c )
  s.files += %w( src/core/lib/channel/channel_stack.c )
  s.files += %w( src/core/lib/channel/channel_stack_builder.c )
  s.files += %w( src/core/lib/channel/compress_filter.c )
  s.files += %w( src/core/lib/channel/connected_channel.c )
  s.files += %w( src/core/lib/channel/http_client_filter.c )
  s.files += %w( src/core/lib/channel/http_server_filter.c )
  s.files += %w( src/core/lib/compression/compression.c )
  s.files += %w( src/core/lib/compression/message_compress.c )
  s.files += %w( src/core/lib/debug/trace.c )
  s.files += %w( src/core/lib/http/format_request.c )
  s.files += %w( src/core/lib/http/httpcli.c )
  s.files += %w( src/core/lib/http/parser.c )
  s.files += %w( src/core/lib/iomgr/closure.c )
  s.files += %w( src/core/lib/iomgr/endpoint.c )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_posix.c )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_windows.c )
  s.files += %w( src/core/lib/iomgr/error.c )
  s.files += %w( src/core/lib/iomgr/ev_epoll_linux.c )
  s.files += %w( src/core/lib/iomgr/ev_poll_and_epoll_posix.c )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.c )
  s.files += %w( src/core/lib/iomgr/ev_posix.c )
  s.files += %w( src/core/lib/iomgr/exec_ctx.c )
  s.files += %w( src/core/lib/iomgr/executor.c )
  s.files += %w( src/core/lib/iomgr/iocp_windows.c )
  s.files += %w( src/core/lib/iomgr/iomgr.c )
  s.files += %w( src/core/lib/iomgr/iomgr_posix.c )
  s.files += %w( src/core/lib/iomgr/iomgr_windows.c )
  s.files += %w( src/core/lib/iomgr/load_file.c )
  s.files += %w( src/core/lib/iomgr/network_status_tracker.c )
  s.files += %w( src/core/lib/iomgr/polling_entity.c )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.c )
  s.files += %w( src/core/lib/iomgr/pollset_windows.c )
  s.files += %w( src/core/lib/iomgr/resolve_address_posix.c )
  s.files += %w( src/core/lib/iomgr/resolve_address_windows.c )
  s.files += %w( src/core/lib/iomgr/sockaddr_utils.c )
  s.files += %w( src/core/lib/iomgr/socket_utils_common_posix.c )
  s.files += %w( src/core/lib/iomgr/socket_utils_linux.c )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.c )
  s.files += %w( src/core/lib/iomgr/socket_windows.c )
  s.files += %w( src/core/lib/iomgr/tcp_client_posix.c )
  s.files += %w( src/core/lib/iomgr/tcp_client_windows.c )
  s.files += %w( src/core/lib/iomgr/tcp_posix.c )
  s.files += %w( src/core/lib/iomgr/tcp_server_posix.c )
  s.files += %w( src/core/lib/iomgr/tcp_server_windows.c )
  s.files += %w( src/core/lib/iomgr/tcp_windows.c )
  s.files += %w( src/core/lib/iomgr/time_averaged_stats.c )
  s.files += %w( src/core/lib/iomgr/timer.c )
  s.files += %w( src/core/lib/iomgr/timer_heap.c )
  s.files += %w( src/core/lib/iomgr/udp_server.c )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.c )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix_noop.c )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_eventfd.c )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_nospecial.c )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.c )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.c )
  s.files += %w( src/core/lib/iomgr/workqueue_posix.c )
  s.files += %w( src/core/lib/iomgr/workqueue_windows.c )
  s.files += %w( src/core/lib/json/json.c )
  s.files += %w( src/core/lib/json/json_reader.c )
  s.files += %w( src/core/lib/json/json_string.c )
  s.files += %w( src/core/lib/json/json_writer.c )
  s.files += %w( src/core/lib/surface/alarm.c )
  s.files += %w( src/core/lib/surface/api_trace.c )
  s.files += %w( src/core/lib/surface/byte_buffer.c )
  s.files += %w( src/core/lib/surface/byte_buffer_reader.c )
  s.files += %w( src/core/lib/surface/call.c )
  s.files += %w( src/core/lib/surface/call_details.c )
  s.files += %w( src/core/lib/surface/call_log_batch.c )
  s.files += %w( src/core/lib/surface/channel.c )
  s.files += %w( src/core/lib/surface/channel_init.c )
  s.files += %w( src/core/lib/surface/channel_ping.c )
  s.files += %w( src/core/lib/surface/channel_stack_type.c )
  s.files += %w( src/core/lib/surface/completion_queue.c )
  s.files += %w( src/core/lib/surface/event_string.c )
  s.files += %w( src/core/lib/surface/lame_client.c )
  s.files += %w( src/core/lib/surface/metadata_array.c )
  s.files += %w( src/core/lib/surface/server.c )
  s.files += %w( src/core/lib/surface/validate_metadata.c )
  s.files += %w( src/core/lib/surface/version.c )
  s.files += %w( src/core/lib/transport/byte_stream.c )
  s.files += %w( src/core/lib/transport/connectivity_state.c )
  s.files += %w( src/core/lib/transport/metadata.c )
  s.files += %w( src/core/lib/transport/metadata_batch.c )
  s.files += %w( src/core/lib/transport/static_metadata.c )
  s.files += %w( src/core/lib/transport/transport.c )
  s.files += %w( src/core/lib/transport/transport_op_string.c )
  s.files += %w( src/core/ext/transport/chttp2/server/secure/server_secure_chttp2.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_plugin.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_table.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/incoming_metadata.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/parsing.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/status_conversion.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_lists.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_map.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/timeout_encoding.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.c )
  s.files += %w( src/core/ext/transport/chttp2/transport/writing.c )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.c )
  s.files += %w( src/core/lib/http/httpcli_security_connector.c )
  s.files += %w( src/core/lib/security/context/security_context.c )
  s.files += %w( src/core/lib/security/credentials/composite/composite_credentials.c )
  s.files += %w( src/core/lib/security/credentials/credentials.c )
  s.files += %w( src/core/lib/security/credentials/credentials_metadata.c )
  s.files += %w( src/core/lib/security/credentials/fake/fake_credentials.c )
  s.files += %w( src/core/lib/security/credentials/google_default/credentials_posix.c )
  s.files += %w( src/core/lib/security/credentials/google_default/credentials_windows.c )
  s.files += %w( src/core/lib/security/credentials/google_default/google_default_credentials.c )
  s.files += %w( src/core/lib/security/credentials/iam/iam_credentials.c )
  s.files += %w( src/core/lib/security/credentials/jwt/json_token.c )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_credentials.c )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_verifier.c )
  s.files += %w( src/core/lib/security/credentials/oauth2/oauth2_credentials.c )
  s.files += %w( src/core/lib/security/credentials/plugin/plugin_credentials.c )
  s.files += %w( src/core/lib/security/credentials/ssl/ssl_credentials.c )
  s.files += %w( src/core/lib/security/transport/client_auth_filter.c )
  s.files += %w( src/core/lib/security/transport/handshake.c )
  s.files += %w( src/core/lib/security/transport/secure_endpoint.c )
  s.files += %w( src/core/lib/security/transport/security_connector.c )
  s.files += %w( src/core/lib/security/transport/server_auth_filter.c )
  s.files += %w( src/core/lib/security/transport/tsi_error.c )
  s.files += %w( src/core/lib/security/util/b64.c )
  s.files += %w( src/core/lib/security/util/json_util.c )
  s.files += %w( src/core/lib/surface/init_secure.c )
  s.files += %w( src/core/lib/tsi/fake_transport_security.c )
  s.files += %w( src/core/lib/tsi/ssl_transport_security.c )
  s.files += %w( src/core/lib/tsi/transport_security.c )
  s.files += %w( src/core/ext/transport/chttp2/client/secure/secure_channel_create.c )
  s.files += %w( src/core/ext/client_config/channel_connectivity.c )
  s.files += %w( src/core/ext/client_config/client_channel.c )
  s.files += %w( src/core/ext/client_config/client_channel_factory.c )
  s.files += %w( src/core/ext/client_config/client_config.c )
  s.files += %w( src/core/ext/client_config/client_config_plugin.c )
  s.files += %w( src/core/ext/client_config/connector.c )
  s.files += %w( src/core/ext/client_config/default_initial_connect_string.c )
  s.files += %w( src/core/ext/client_config/initial_connect_string.c )
  s.files += %w( src/core/ext/client_config/lb_policy.c )
  s.files += %w( src/core/ext/client_config/lb_policy_factory.c )
  s.files += %w( src/core/ext/client_config/lb_policy_registry.c )
  s.files += %w( src/core/ext/client_config/parse_address.c )
  s.files += %w( src/core/ext/client_config/resolver.c )
  s.files += %w( src/core/ext/client_config/resolver_factory.c )
  s.files += %w( src/core/ext/client_config/resolver_registry.c )
  s.files += %w( src/core/ext/client_config/subchannel.c )
  s.files += %w( src/core/ext/client_config/subchannel_call_holder.c )
  s.files += %w( src/core/ext/client_config/subchannel_index.c )
  s.files += %w( src/core/ext/client_config/uri_parser.c )
  s.files += %w( src/core/ext/transport/chttp2/server/insecure/server_chttp2.c )
  s.files += %w( src/core/ext/transport/chttp2/server/insecure/server_chttp2_posix.c )
  s.files += %w( src/core/ext/transport/chttp2/client/insecure/channel_create.c )
  s.files += %w( src/core/ext/transport/chttp2/client/insecure/channel_create_posix.c )
  s.files += %w( src/core/ext/lb_policy/grpclb/load_balancer_api.c )
  s.files += %w( src/core/ext/lb_policy/grpclb/proto/grpc/lb/v1/load_balancer.pb.c )
  s.files += %w( third_party/nanopb/pb_common.c )
  s.files += %w( third_party/nanopb/pb_decode.c )
  s.files += %w( third_party/nanopb/pb_encode.c )
  s.files += %w( src/core/ext/lb_policy/pick_first/pick_first.c )
  s.files += %w( src/core/ext/lb_policy/round_robin/round_robin.c )
  s.files += %w( src/core/ext/resolver/dns/native/dns_resolver.c )
  s.files += %w( src/core/ext/resolver/sockaddr/sockaddr_resolver.c )
  s.files += %w( src/core/ext/load_reporting/load_reporting.c )
  s.files += %w( src/core/ext/load_reporting/load_reporting_filter.c )
  s.files += %w( src/core/ext/census/context.c )
  s.files += %w( src/core/ext/census/gen/census.pb.c )
  s.files += %w( src/core/ext/census/grpc_context.c )
  s.files += %w( src/core/ext/census/grpc_filter.c )
  s.files += %w( src/core/ext/census/grpc_plugin.c )
  s.files += %w( src/core/ext/census/initialize.c )
  s.files += %w( src/core/ext/census/mlog.c )
  s.files += %w( src/core/ext/census/operation.c )
  s.files += %w( src/core/ext/census/placeholders.c )
  s.files += %w( src/core/ext/census/tracing.c )
  s.files += %w( src/core/plugin_registry/grpc_plugin_registry.c )
  s.files += %w( third_party/boringssl/crypto/aes/internal.h )
  s.files += %w( third_party/boringssl/crypto/asn1/asn1_locl.h )
  s.files += %w( third_party/boringssl/crypto/bio/internal.h )
  s.files += %w( third_party/boringssl/crypto/bn/internal.h )
  s.files += %w( third_party/boringssl/crypto/bn/rsaz_exp.h )
  s.files += %w( third_party/boringssl/crypto/bytestring/internal.h )
  s.files += %w( third_party/boringssl/crypto/cipher/internal.h )
  s.files += %w( third_party/boringssl/crypto/conf/conf_def.h )
  s.files += %w( third_party/boringssl/crypto/conf/internal.h )
  s.files += %w( third_party/boringssl/crypto/curve25519/internal.h )
  s.files += %w( third_party/boringssl/crypto/des/internal.h )
  s.files += %w( third_party/boringssl/crypto/dh/internal.h )
  s.files += %w( third_party/boringssl/crypto/digest/internal.h )
  s.files += %w( third_party/boringssl/crypto/digest/md32_common.h )
  s.files += %w( third_party/boringssl/crypto/directory.h )
  s.files += %w( third_party/boringssl/crypto/ec/internal.h )
  s.files += %w( third_party/boringssl/crypto/ec/p256-x86_64-table.h )
  s.files += %w( third_party/boringssl/crypto/evp/internal.h )
  s.files += %w( third_party/boringssl/crypto/internal.h )
  s.files += %w( third_party/boringssl/crypto/modes/internal.h )
  s.files += %w( third_party/boringssl/crypto/obj/obj_dat.h )
  s.files += %w( third_party/boringssl/crypto/obj/obj_xref.h )
  s.files += %w( third_party/boringssl/crypto/pkcs8/internal.h )
  s.files += %w( third_party/boringssl/crypto/rand/internal.h )
  s.files += %w( third_party/boringssl/crypto/rsa/internal.h )
  s.files += %w( third_party/boringssl/crypto/test/scoped_types.h )
  s.files += %w( third_party/boringssl/crypto/test/test_util.h )
  s.files += %w( third_party/boringssl/crypto/x509/charmap.h )
  s.files += %w( third_party/boringssl/crypto/x509/vpm_int.h )
  s.files += %w( third_party/boringssl/crypto/x509v3/ext_dat.h )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_int.h )
  s.files += %w( third_party/boringssl/include/openssl/aead.h )
  s.files += %w( third_party/boringssl/include/openssl/aes.h )
  s.files += %w( third_party/boringssl/include/openssl/arm_arch.h )
  s.files += %w( third_party/boringssl/include/openssl/asn1.h )
  s.files += %w( third_party/boringssl/include/openssl/asn1_mac.h )
  s.files += %w( third_party/boringssl/include/openssl/asn1t.h )
  s.files += %w( third_party/boringssl/include/openssl/base.h )
  s.files += %w( third_party/boringssl/include/openssl/base64.h )
  s.files += %w( third_party/boringssl/include/openssl/bio.h )
  s.files += %w( third_party/boringssl/include/openssl/blowfish.h )
  s.files += %w( third_party/boringssl/include/openssl/bn.h )
  s.files += %w( third_party/boringssl/include/openssl/buf.h )
  s.files += %w( third_party/boringssl/include/openssl/buffer.h )
  s.files += %w( third_party/boringssl/include/openssl/bytestring.h )
  s.files += %w( third_party/boringssl/include/openssl/cast.h )
  s.files += %w( third_party/boringssl/include/openssl/chacha.h )
  s.files += %w( third_party/boringssl/include/openssl/cipher.h )
  s.files += %w( third_party/boringssl/include/openssl/cmac.h )
  s.files += %w( third_party/boringssl/include/openssl/conf.h )
  s.files += %w( third_party/boringssl/include/openssl/cpu.h )
  s.files += %w( third_party/boringssl/include/openssl/crypto.h )
  s.files += %w( third_party/boringssl/include/openssl/curve25519.h )
  s.files += %w( third_party/boringssl/include/openssl/des.h )
  s.files += %w( third_party/boringssl/include/openssl/dh.h )
  s.files += %w( third_party/boringssl/include/openssl/digest.h )
  s.files += %w( third_party/boringssl/include/openssl/dsa.h )
  s.files += %w( third_party/boringssl/include/openssl/dtls1.h )
  s.files += %w( third_party/boringssl/include/openssl/ec.h )
  s.files += %w( third_party/boringssl/include/openssl/ec_key.h )
  s.files += %w( third_party/boringssl/include/openssl/ecdh.h )
  s.files += %w( third_party/boringssl/include/openssl/ecdsa.h )
  s.files += %w( third_party/boringssl/include/openssl/engine.h )
  s.files += %w( third_party/boringssl/include/openssl/err.h )
  s.files += %w( third_party/boringssl/include/openssl/evp.h )
  s.files += %w( third_party/boringssl/include/openssl/ex_data.h )
  s.files += %w( third_party/boringssl/include/openssl/hkdf.h )
  s.files += %w( third_party/boringssl/include/openssl/hmac.h )
  s.files += %w( third_party/boringssl/include/openssl/lhash.h )
  s.files += %w( third_party/boringssl/include/openssl/lhash_macros.h )
  s.files += %w( third_party/boringssl/include/openssl/md4.h )
  s.files += %w( third_party/boringssl/include/openssl/md5.h )
  s.files += %w( third_party/boringssl/include/openssl/mem.h )
  s.files += %w( third_party/boringssl/include/openssl/obj.h )
  s.files += %w( third_party/boringssl/include/openssl/obj_mac.h )
  s.files += %w( third_party/boringssl/include/openssl/objects.h )
  s.files += %w( third_party/boringssl/include/openssl/opensslfeatures.h )
  s.files += %w( third_party/boringssl/include/openssl/opensslv.h )
  s.files += %w( third_party/boringssl/include/openssl/ossl_typ.h )
  s.files += %w( third_party/boringssl/include/openssl/pem.h )
  s.files += %w( third_party/boringssl/include/openssl/pkcs12.h )
  s.files += %w( third_party/boringssl/include/openssl/pkcs7.h )
  s.files += %w( third_party/boringssl/include/openssl/pkcs8.h )
  s.files += %w( third_party/boringssl/include/openssl/poly1305.h )
  s.files += %w( third_party/boringssl/include/openssl/pqueue.h )
  s.files += %w( third_party/boringssl/include/openssl/rand.h )
  s.files += %w( third_party/boringssl/include/openssl/rc4.h )
  s.files += %w( third_party/boringssl/include/openssl/rsa.h )
  s.files += %w( third_party/boringssl/include/openssl/safestack.h )
  s.files += %w( third_party/boringssl/include/openssl/sha.h )
  s.files += %w( third_party/boringssl/include/openssl/srtp.h )
  s.files += %w( third_party/boringssl/include/openssl/ssl.h )
  s.files += %w( third_party/boringssl/include/openssl/ssl3.h )
  s.files += %w( third_party/boringssl/include/openssl/stack.h )
  s.files += %w( third_party/boringssl/include/openssl/stack_macros.h )
  s.files += %w( third_party/boringssl/include/openssl/thread.h )
  s.files += %w( third_party/boringssl/include/openssl/time_support.h )
  s.files += %w( third_party/boringssl/include/openssl/tls1.h )
  s.files += %w( third_party/boringssl/include/openssl/type_check.h )
  s.files += %w( third_party/boringssl/include/openssl/x509.h )
  s.files += %w( third_party/boringssl/include/openssl/x509_vfy.h )
  s.files += %w( third_party/boringssl/include/openssl/x509v3.h )
  s.files += %w( third_party/boringssl/ssl/internal.h )
  s.files += %w( third_party/boringssl/ssl/test/async_bio.h )
  s.files += %w( third_party/boringssl/ssl/test/packeted_bio.h )
  s.files += %w( third_party/boringssl/ssl/test/scoped_types.h )
  s.files += %w( third_party/boringssl/ssl/test/test_config.h )
  s.files += %w( src/boringssl/err_data.c )
  s.files += %w( third_party/boringssl/crypto/aes/aes.c )
  s.files += %w( third_party/boringssl/crypto/aes/mode_wrappers.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_bitstr.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_bool.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_bytes.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_d2i_fp.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_dup.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_enum.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_gentm.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_i2d_fp.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_int.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_mbstr.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_object.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_octet.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_print.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_strnid.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_time.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_type.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_utctm.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_utf8.c )
  s.files += %w( third_party/boringssl/crypto/asn1/asn1_lib.c )
  s.files += %w( third_party/boringssl/crypto/asn1/asn1_par.c )
  s.files += %w( third_party/boringssl/crypto/asn1/asn_pack.c )
  s.files += %w( third_party/boringssl/crypto/asn1/bio_asn1.c )
  s.files += %w( third_party/boringssl/crypto/asn1/bio_ndef.c )
  s.files += %w( third_party/boringssl/crypto/asn1/f_enum.c )
  s.files += %w( third_party/boringssl/crypto/asn1/f_int.c )
  s.files += %w( third_party/boringssl/crypto/asn1/f_string.c )
  s.files += %w( third_party/boringssl/crypto/asn1/t_bitst.c )
  s.files += %w( third_party/boringssl/crypto/asn1/t_pkey.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_dec.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_enc.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_fre.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_new.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_prn.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_typ.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_utl.c )
  s.files += %w( third_party/boringssl/crypto/asn1/x_bignum.c )
  s.files += %w( third_party/boringssl/crypto/asn1/x_long.c )
  s.files += %w( third_party/boringssl/crypto/base64/base64.c )
  s.files += %w( third_party/boringssl/crypto/bio/bio.c )
  s.files += %w( third_party/boringssl/crypto/bio/bio_mem.c )
  s.files += %w( third_party/boringssl/crypto/bio/buffer.c )
  s.files += %w( third_party/boringssl/crypto/bio/connect.c )
  s.files += %w( third_party/boringssl/crypto/bio/fd.c )
  s.files += %w( third_party/boringssl/crypto/bio/file.c )
  s.files += %w( third_party/boringssl/crypto/bio/hexdump.c )
  s.files += %w( third_party/boringssl/crypto/bio/pair.c )
  s.files += %w( third_party/boringssl/crypto/bio/printf.c )
  s.files += %w( third_party/boringssl/crypto/bio/socket.c )
  s.files += %w( third_party/boringssl/crypto/bio/socket_helper.c )
  s.files += %w( third_party/boringssl/crypto/bn/add.c )
  s.files += %w( third_party/boringssl/crypto/bn/asm/x86_64-gcc.c )
  s.files += %w( third_party/boringssl/crypto/bn/bn.c )
  s.files += %w( third_party/boringssl/crypto/bn/bn_asn1.c )
  s.files += %w( third_party/boringssl/crypto/bn/cmp.c )
  s.files += %w( third_party/boringssl/crypto/bn/convert.c )
  s.files += %w( third_party/boringssl/crypto/bn/ctx.c )
  s.files += %w( third_party/boringssl/crypto/bn/div.c )
  s.files += %w( third_party/boringssl/crypto/bn/exponentiation.c )
  s.files += %w( third_party/boringssl/crypto/bn/gcd.c )
  s.files += %w( third_party/boringssl/crypto/bn/generic.c )
  s.files += %w( third_party/boringssl/crypto/bn/kronecker.c )
  s.files += %w( third_party/boringssl/crypto/bn/montgomery.c )
  s.files += %w( third_party/boringssl/crypto/bn/mul.c )
  s.files += %w( third_party/boringssl/crypto/bn/prime.c )
  s.files += %w( third_party/boringssl/crypto/bn/random.c )
  s.files += %w( third_party/boringssl/crypto/bn/rsaz_exp.c )
  s.files += %w( third_party/boringssl/crypto/bn/shift.c )
  s.files += %w( third_party/boringssl/crypto/bn/sqrt.c )
  s.files += %w( third_party/boringssl/crypto/buf/buf.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/asn1_compat.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/ber.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/cbb.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/cbs.c )
  s.files += %w( third_party/boringssl/crypto/chacha/chacha_generic.c )
  s.files += %w( third_party/boringssl/crypto/chacha/chacha_vec.c )
  s.files += %w( third_party/boringssl/crypto/cipher/aead.c )
  s.files += %w( third_party/boringssl/crypto/cipher/cipher.c )
  s.files += %w( third_party/boringssl/crypto/cipher/derive_key.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_aes.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_chacha20poly1305.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_des.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_null.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_rc2.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_rc4.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_ssl3.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_tls.c )
  s.files += %w( third_party/boringssl/crypto/cipher/tls_cbc.c )
  s.files += %w( third_party/boringssl/crypto/cmac/cmac.c )
  s.files += %w( third_party/boringssl/crypto/conf/conf.c )
  s.files += %w( third_party/boringssl/crypto/cpu-arm.c )
  s.files += %w( third_party/boringssl/crypto/cpu-intel.c )
  s.files += %w( third_party/boringssl/crypto/crypto.c )
  s.files += %w( third_party/boringssl/crypto/curve25519/curve25519.c )
  s.files += %w( third_party/boringssl/crypto/curve25519/x25519-x86_64.c )
  s.files += %w( third_party/boringssl/crypto/des/des.c )
  s.files += %w( third_party/boringssl/crypto/dh/check.c )
  s.files += %w( third_party/boringssl/crypto/dh/dh.c )
  s.files += %w( third_party/boringssl/crypto/dh/dh_asn1.c )
  s.files += %w( third_party/boringssl/crypto/dh/params.c )
  s.files += %w( third_party/boringssl/crypto/digest/digest.c )
  s.files += %w( third_party/boringssl/crypto/digest/digests.c )
  s.files += %w( third_party/boringssl/crypto/directory_posix.c )
  s.files += %w( third_party/boringssl/crypto/directory_win.c )
  s.files += %w( third_party/boringssl/crypto/dsa/dsa.c )
  s.files += %w( third_party/boringssl/crypto/dsa/dsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec_asn1.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec_key.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec_montgomery.c )
  s.files += %w( third_party/boringssl/crypto/ec/oct.c )
  s.files += %w( third_party/boringssl/crypto/ec/p224-64.c )
  s.files += %w( third_party/boringssl/crypto/ec/p256-64.c )
  s.files += %w( third_party/boringssl/crypto/ec/p256-x86_64.c )
  s.files += %w( third_party/boringssl/crypto/ec/simple.c )
  s.files += %w( third_party/boringssl/crypto/ec/util-64.c )
  s.files += %w( third_party/boringssl/crypto/ec/wnaf.c )
  s.files += %w( third_party/boringssl/crypto/ecdh/ecdh.c )
  s.files += %w( third_party/boringssl/crypto/ecdsa/ecdsa.c )
  s.files += %w( third_party/boringssl/crypto/ecdsa/ecdsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/engine/engine.c )
  s.files += %w( third_party/boringssl/crypto/err/err.c )
  s.files += %w( third_party/boringssl/crypto/evp/algorithm.c )
  s.files += %w( third_party/boringssl/crypto/evp/digestsign.c )
  s.files += %w( third_party/boringssl/crypto/evp/evp.c )
  s.files += %w( third_party/boringssl/crypto/evp/evp_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/evp_ctx.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_dsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_ec.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_ec_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_rsa.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_rsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/pbkdf.c )
  s.files += %w( third_party/boringssl/crypto/evp/sign.c )
  s.files += %w( third_party/boringssl/crypto/ex_data.c )
  s.files += %w( third_party/boringssl/crypto/hkdf/hkdf.c )
  s.files += %w( third_party/boringssl/crypto/hmac/hmac.c )
  s.files += %w( third_party/boringssl/crypto/lhash/lhash.c )
  s.files += %w( third_party/boringssl/crypto/md4/md4.c )
  s.files += %w( third_party/boringssl/crypto/md5/md5.c )
  s.files += %w( third_party/boringssl/crypto/mem.c )
  s.files += %w( third_party/boringssl/crypto/modes/cbc.c )
  s.files += %w( third_party/boringssl/crypto/modes/cfb.c )
  s.files += %w( third_party/boringssl/crypto/modes/ctr.c )
  s.files += %w( third_party/boringssl/crypto/modes/gcm.c )
  s.files += %w( third_party/boringssl/crypto/modes/ofb.c )
  s.files += %w( third_party/boringssl/crypto/obj/obj.c )
  s.files += %w( third_party/boringssl/crypto/obj/obj_xref.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_all.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_info.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_lib.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_oth.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_pk8.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_pkey.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_x509.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_xaux.c )
  s.files += %w( third_party/boringssl/crypto/pkcs8/p5_pbe.c )
  s.files += %w( third_party/boringssl/crypto/pkcs8/p5_pbev2.c )
  s.files += %w( third_party/boringssl/crypto/pkcs8/p8_pkey.c )
  s.files += %w( third_party/boringssl/crypto/pkcs8/pkcs8.c )
  s.files += %w( third_party/boringssl/crypto/poly1305/poly1305.c )
  s.files += %w( third_party/boringssl/crypto/poly1305/poly1305_arm.c )
  s.files += %w( third_party/boringssl/crypto/poly1305/poly1305_vec.c )
  s.files += %w( third_party/boringssl/crypto/rand/rand.c )
  s.files += %w( third_party/boringssl/crypto/rand/urandom.c )
  s.files += %w( third_party/boringssl/crypto/rand/windows.c )
  s.files += %w( third_party/boringssl/crypto/rc4/rc4.c )
  s.files += %w( third_party/boringssl/crypto/refcount_c11.c )
  s.files += %w( third_party/boringssl/crypto/refcount_lock.c )
  s.files += %w( third_party/boringssl/crypto/rsa/blinding.c )
  s.files += %w( third_party/boringssl/crypto/rsa/padding.c )
  s.files += %w( third_party/boringssl/crypto/rsa/rsa.c )
  s.files += %w( third_party/boringssl/crypto/rsa/rsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/rsa/rsa_impl.c )
  s.files += %w( third_party/boringssl/crypto/sha/sha1.c )
  s.files += %w( third_party/boringssl/crypto/sha/sha256.c )
  s.files += %w( third_party/boringssl/crypto/sha/sha512.c )
  s.files += %w( third_party/boringssl/crypto/stack/stack.c )
  s.files += %w( third_party/boringssl/crypto/thread.c )
  s.files += %w( third_party/boringssl/crypto/thread_none.c )
  s.files += %w( third_party/boringssl/crypto/thread_pthread.c )
  s.files += %w( third_party/boringssl/crypto/thread_win.c )
  s.files += %w( third_party/boringssl/crypto/time_support.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_digest.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_sign.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_strex.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_verify.c )
  s.files += %w( third_party/boringssl/crypto/x509/asn1_gen.c )
  s.files += %w( third_party/boringssl/crypto/x509/by_dir.c )
  s.files += %w( third_party/boringssl/crypto/x509/by_file.c )
  s.files += %w( third_party/boringssl/crypto/x509/i2d_pr.c )
  s.files += %w( third_party/boringssl/crypto/x509/pkcs7.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_crl.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_req.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_x509.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_x509a.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_att.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_cmp.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_d2.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_def.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_ext.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_lu.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_obj.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_r2x.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_req.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_set.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_trs.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_txt.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_v3.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_vfy.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_vpm.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509cset.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509name.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509rset.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509spki.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509type.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_algor.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_all.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_attrib.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_crl.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_exten.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_info.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_name.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_pkey.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_pubkey.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_req.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_sig.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_spki.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_val.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_x509.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_x509a.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_cache.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_data.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_lib.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_map.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_node.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_tree.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_akey.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_akeya.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_alt.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_bcons.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_bitst.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_conf.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_cpols.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_crld.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_enum.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_extku.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_genn.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_ia5.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_info.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_int.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_lib.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_ncons.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pci.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pcia.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pcons.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pku.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pmaps.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_prn.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_purp.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_skey.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_sxnet.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_utl.c )
  s.files += %w( third_party/boringssl/ssl/custom_extensions.c )
  s.files += %w( third_party/boringssl/ssl/d1_both.c )
  s.files += %w( third_party/boringssl/ssl/d1_clnt.c )
  s.files += %w( third_party/boringssl/ssl/d1_lib.c )
  s.files += %w( third_party/boringssl/ssl/d1_meth.c )
  s.files += %w( third_party/boringssl/ssl/d1_pkt.c )
  s.files += %w( third_party/boringssl/ssl/d1_srtp.c )
  s.files += %w( third_party/boringssl/ssl/d1_srvr.c )
  s.files += %w( third_party/boringssl/ssl/dtls_record.c )
  s.files += %w( third_party/boringssl/ssl/pqueue/pqueue.c )
  s.files += %w( third_party/boringssl/ssl/s3_both.c )
  s.files += %w( third_party/boringssl/ssl/s3_clnt.c )
  s.files += %w( third_party/boringssl/ssl/s3_enc.c )
  s.files += %w( third_party/boringssl/ssl/s3_lib.c )
  s.files += %w( third_party/boringssl/ssl/s3_meth.c )
  s.files += %w( third_party/boringssl/ssl/s3_pkt.c )
  s.files += %w( third_party/boringssl/ssl/s3_srvr.c )
  s.files += %w( third_party/boringssl/ssl/ssl_aead_ctx.c )
  s.files += %w( third_party/boringssl/ssl/ssl_asn1.c )
  s.files += %w( third_party/boringssl/ssl/ssl_buffer.c )
  s.files += %w( third_party/boringssl/ssl/ssl_cert.c )
  s.files += %w( third_party/boringssl/ssl/ssl_cipher.c )
  s.files += %w( third_party/boringssl/ssl/ssl_ecdh.c )
  s.files += %w( third_party/boringssl/ssl/ssl_file.c )
  s.files += %w( third_party/boringssl/ssl/ssl_lib.c )
  s.files += %w( third_party/boringssl/ssl/ssl_rsa.c )
  s.files += %w( third_party/boringssl/ssl/ssl_session.c )
  s.files += %w( third_party/boringssl/ssl/ssl_stat.c )
  s.files += %w( third_party/boringssl/ssl/t1_enc.c )
  s.files += %w( third_party/boringssl/ssl/t1_lib.c )
  s.files += %w( third_party/boringssl/ssl/tls_record.c )
  s.files += %w( third_party/zlib/crc32.h )
  s.files += %w( third_party/zlib/deflate.h )
  s.files += %w( third_party/zlib/gzguts.h )
  s.files += %w( third_party/zlib/inffast.h )
  s.files += %w( third_party/zlib/inffixed.h )
  s.files += %w( third_party/zlib/inflate.h )
  s.files += %w( third_party/zlib/inftrees.h )
  s.files += %w( third_party/zlib/trees.h )
  s.files += %w( third_party/zlib/zconf.h )
  s.files += %w( third_party/zlib/zlib.h )
  s.files += %w( third_party/zlib/zutil.h )
  s.files += %w( third_party/zlib/adler32.c )
  s.files += %w( third_party/zlib/compress.c )
  s.files += %w( third_party/zlib/crc32.c )
  s.files += %w( third_party/zlib/deflate.c )
  s.files += %w( third_party/zlib/gzclose.c )
  s.files += %w( third_party/zlib/gzlib.c )
  s.files += %w( third_party/zlib/gzread.c )
  s.files += %w( third_party/zlib/gzwrite.c )
  s.files += %w( third_party/zlib/infback.c )
  s.files += %w( third_party/zlib/inffast.c )
  s.files += %w( third_party/zlib/inflate.c )
  s.files += %w( third_party/zlib/inftrees.c )
  s.files += %w( third_party/zlib/trees.c )
  s.files += %w( third_party/zlib/uncompr.c )
  s.files += %w( third_party/zlib/zutil.c )
end
