# Copyright (C) 2015-2017 OpenIO SAS, as part of OpenIO SDS
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from eventlet.green import socket
from oio.common import exceptions as exc
from oio.conscience.checker.base import BaseChecker


class TcpChecker(BaseChecker):
    def configure(self):
        for k in ['host', 'port']:
            if k not in self.checker_conf:
                raise exc.ConfigurationException(
                    'Missing field "%s" in configuration' % k)
        self.addr = (self.checker_conf['host'], self.checker_conf['port'])

    def _communicate(self, sock):
        """Do something with the already connected socket."""
        pass

    def check(self):
        result = False
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        try:
            sock.connect(self.addr)
            self._communicate(sock)
            result = True
        finally:
            if sock:
                sock.close()
            return result
