/*
OpenIO SDS sqliterepo
Copyright (C) 2014 Worldline, as part of Redcurrant
Copyright (C) 2015-2017 OpenIO SAS, as part of OpenIO SDS

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 3.0 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library.
*/

#ifndef OIO_SDS__sqliterepo__synchro_h
# define OIO_SDS__sqliterepo__synchro_h 1

/**
 * SYNCHRONICITY module :
 *
 * Helps the developper to make use of a ZooKeeper-like server.
 */
#include <zookeeper.h>

#define PATH_MAXLEN 128 + LIMIT_LENGTH_NSNAME

struct sqlx_sync_s;

struct sqlx_sync_vtable_s
{
	void (*clear) (struct sqlx_sync_s *ss);

	GError* (*open) (struct sqlx_sync_s *ss);

	void (*close) (struct sqlx_sync_s *ss);

	int (*acreate) (struct sqlx_sync_s *ss, const char *path, const char *v,
			int vlen, int flags, string_completion_t completion, const void *data);

	int (*adelete) (struct sqlx_sync_s *ss, const char *path, int version,
			void_completion_t completion, const void *data);

	int (*awexists) (struct sqlx_sync_s *ss, const char *path,
			watcher_fn watcher, void* watcherCtx,
			stat_completion_t completion, const void *data);

	int (*awget) (struct sqlx_sync_s *ss, const char *path,
			watcher_fn watcher, void* watcherCtx,
			data_completion_t completion, const void *data);

	int (*awget_children) (struct sqlx_sync_s *ss, const char *path,
			watcher_fn watcher, void* watcherCtx,
			strings_completion_t completion, const void *data);

	int (*awget_siblings) (struct sqlx_sync_s *ss, const char *path,
			watcher_fn watcher, void* watcherCtx,
			strings_completion_t completion, const void *data);
};

struct abstract_sqlx_sync_s
{
	struct sqlx_sync_vtable_s *vtable;
};

void sqlx_sync_clear(struct sqlx_sync_s *ss);

GError * sqlx_sync_open(struct sqlx_sync_s *ss);

void sqlx_sync_close(struct sqlx_sync_s *ss);

int sqlx_sync_acreate (struct sqlx_sync_s *ss, const char *path, const char *v,
		int vlen, int flags, string_completion_t completion, const void *data);

int sqlx_sync_adelete (struct sqlx_sync_s *ss, const char *path, int version,
		void_completion_t completion, const void *data);

int sqlx_sync_awexists(struct sqlx_sync_s *ss, const char *path,
		watcher_fn watcher, void* watcherCtx,
		stat_completion_t completion, const void *data);

int sqlx_sync_awget (struct sqlx_sync_s *ss, const char *path,
		watcher_fn watcher, void* watcherCtx,
		data_completion_t completion, const void *data);

int sqlx_sync_awget_children (struct sqlx_sync_s *ss, const char *path,
		watcher_fn watcher, void* watcherCtx,
		strings_completion_t completion, const void *data);

int sqlx_sync_awget_siblings (struct sqlx_sync_s *ss, const char *path,
		watcher_fn watcher, void* watcherCtx,
		strings_completion_t completion, const void *data);

/** Initiates a sqlx synchronizer based on ZooKeeper.
 * @param url the Zookeeper connection string */
struct sqlx_sync_s * sqlx_sync_create(const char *url);

void sqlx_sync_set_prefix(struct sqlx_sync_s *ss, const gchar *prefix);

void sqlx_sync_set_hash(struct sqlx_sync_s *ss, guint witdth, guint depth);

/* -------------------------------------------------------------------------- */

struct sqlx_name_s;
struct sqlx_name_inline_s;
struct election_manager_s;
struct gridd_client_pool_s;

struct sqlx_peering_s;

typedef void (*sqlx_peering_pipefrom_end_f) (GError *e,
		struct election_manager_s *m, const struct sqlx_name_s *n,
		guint reqid);

typedef void (*sqlx_peering_getvers_end_f) (GError *e,
		struct election_manager_s *m, const struct sqlx_name_s *n,
		guint reqid, GTree *vremote);

/* Represents what an election needs to communicate with its peers. */
struct sqlx_peering_vtable_s
{
	void (*destroy) (struct sqlx_peering_s *self);

	void (*notify) (struct sqlx_peering_s *self);

	/** @return FALSE if no notify() is necessary (i.e. no command deferred) */
	gboolean (*use) (struct sqlx_peering_s *self,
			const char *url,
			const struct sqlx_name_inline_s *n);

	/** @return FALSE if no notify() is necessary (i.e. no command deferred) */
	gboolean (*getvers) (struct sqlx_peering_s *self,
			const char *url,
			const struct sqlx_name_s *n,
			/* for the return */
			struct election_manager_s *manager,
			guint reqid,
			sqlx_peering_getvers_end_f result);

	/** @return FALSE if no notify() is necessary (i.e. no command deferred) */
	gboolean (*pipefrom) (struct sqlx_peering_s *self,
			const char *url,
			const struct sqlx_name_s *n,
			const char *src,
			/* for the return */
			struct election_manager_s *manager,
			guint reqid,
			sqlx_peering_pipefrom_end_f result);
};

struct sqlx_peering_abstract_s
{
	struct sqlx_peering_vtable_s *vtable;
};

void sqlx_peering__destroy (struct sqlx_peering_s *self);

void sqlx_peering__notify (struct sqlx_peering_s *self);

gboolean sqlx_peering__use (struct sqlx_peering_s *self, const char *url,
		const struct sqlx_name_inline_s *n);

gboolean sqlx_peering__getvers (struct sqlx_peering_s *self, const char *url,
		const struct sqlx_name_s *n, struct election_manager_s *manager,
		guint reqid, sqlx_peering_getvers_end_f result);

gboolean sqlx_peering__pipefrom (struct sqlx_peering_s *self, const char *url,
			const struct sqlx_name_s *n, const char *src,
			struct election_manager_s *manager, guint reqid,
			sqlx_peering_pipefrom_end_f result);

struct sqlx_peering_s * sqlx_peering_factory__create_direct (
		struct gridd_client_pool_s *clipool);

void sqlx_peering_direct__set_udp (struct sqlx_peering_s *self, int fd);

#endif /*OIO_SDS__sqliterepo__synchro_h*/
