/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.ServerStats;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ServerStatsTest
extends ZKTestCase {
    private ServerStats.Provider providerMock;

    @Before
    public void setUp() {
        this.providerMock = (ServerStats.Provider)Mockito.mock(ServerStats.Provider.class);
    }

    @Test
    public void testPacketsMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        int incrementCount = 20;
        for (int i = 0; i < incrementCount; ++i) {
            serverStats.incrementPacketsSent();
            serverStats.incrementPacketsReceived();
            serverStats.incrementPacketsReceived();
        }
        Assert.assertEquals((long)incrementCount, (long)serverStats.getPacketsSent());
        Assert.assertEquals((long)(incrementCount * 2), (long)serverStats.getPacketsReceived());
        serverStats.resetRequestCounters();
        this.assertAllPacketsZero(serverStats);
    }

    @Test
    public void testLatencyMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        serverStats.updateLatency(Time.currentElapsedTime() - 1000L);
        serverStats.updateLatency(Time.currentElapsedTime() - 2000L);
        MatcherAssert.assertThat((String)"Max latency check", (Object)2000L, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(serverStats.getMaxLatency())));
        MatcherAssert.assertThat((String)"Min latency check", (Object)1000L, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(serverStats.getMinLatency())));
        MatcherAssert.assertThat((String)"Avg latency check", (Object)1500L, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(serverStats.getAvgLatency())));
        serverStats.resetLatency();
        this.assertAllLatencyZero(serverStats);
    }

    @Test
    public void testFsyncThresholdExceedMetrics() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        int incrementCount = 30;
        for (int i = 0; i < incrementCount; ++i) {
            serverStats.incrementFsyncThresholdExceedCount();
        }
        Assert.assertEquals((long)incrementCount, (long)serverStats.getFsyncThresholdExceedCount());
        serverStats.resetFsyncThresholdExceedCount();
        this.assertFsyncThresholdExceedCountZero(serverStats);
    }

    @Test
    public void testReset() {
        ServerStats serverStats = new ServerStats(this.providerMock);
        this.assertAllPacketsZero(serverStats);
        this.assertAllLatencyZero(serverStats);
        serverStats.incrementPacketsSent();
        serverStats.incrementPacketsReceived();
        serverStats.updateLatency(Time.currentElapsedTime() - 1000L);
        serverStats.reset();
        this.assertAllPacketsZero(serverStats);
        this.assertAllLatencyZero(serverStats);
    }

    private void assertAllPacketsZero(ServerStats serverStats) {
        Assert.assertEquals((long)0L, (long)serverStats.getPacketsSent());
        Assert.assertEquals((long)0L, (long)serverStats.getPacketsReceived());
    }

    private void assertAllLatencyZero(ServerStats serverStats) {
        Assert.assertEquals((long)0L, (long)serverStats.getMaxLatency());
        Assert.assertEquals((long)0L, (long)serverStats.getMinLatency());
        Assert.assertEquals((long)0L, (long)serverStats.getAvgLatency());
    }

    private void assertFsyncThresholdExceedCountZero(ServerStats serverStats) {
        Assert.assertEquals((long)0L, (long)serverStats.getFsyncThresholdExceedCount());
    }
}

