/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.AtomicFileOutputStream;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class QuorumPeerMainTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = Logger.getLogger(QuorumPeerMainTest.class);
    private Servers servers;
    private int numServers = 0;

    @After
    public void tearDown() throws Exception {
        if (this.servers == null || this.servers.mt == null) {
            LOG.info((Object)"No servers to shutdown!");
            return;
        }
        for (int i = 0; i < this.numServers; ++i) {
            if (i >= this.servers.mt.length) continue;
            this.servers.mt[i].shutdown();
        }
    }

    @Test
    public void testQuorum() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q1.start();
        q2.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.waitForOne(zk, ZooKeeper.States.CONNECTED);
        zk.create("/foo_q1", "foobar1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q1", null, null)), (Object)"foobar1");
        zk.close();
        zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.waitForOne(zk, ZooKeeper.States.CONNECTED);
        zk.create("/foo_q2", "foobar2".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q2", null, null)), (Object)"foobar2");
        zk.close();
        q1.shutdown();
        q2.shutdown();
        Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
    }

    @Test
    public void testEarlyLeaderAbandonment() throws Exception {
        int i;
        int i2;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i3 = 0; i3 < 3; ++i3) {
            clientPorts[i3] = PortAssignment.unique();
            sb.append("server." + i3 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
        }
        String quorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        ZooKeeper[] zk = new ZooKeeper[3];
        for (i2 = 0; i2 < 3; ++i2) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, clientPorts[i2], quorumCfgSection);
            mt[i2].start();
            zk[i2] = new ZooKeeper("127.0.0.1:" + clientPorts[i2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        for (i2 = 0; i2 < 3; ++i2) {
            mt[i2].shutdown();
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTING);
        for (i2 = 0; i2 < 3; ++i2) {
            mt[i2].start();
        }
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        int leader = -1;
        Map outstanding = null;
        for (int i4 = 0; i4 < 3; ++i4) {
            if (mt[i4].main.quorumPeer.leader == null) {
                mt[i4].shutdown();
                continue;
            }
            leader = i4;
            outstanding = mt[leader].main.quorumPeer.leader.outstandingProposals;
        }
        try {
            zk[leader].create("/zk" + leader, "zk".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.fail((String)("create /zk" + leader + " should have failed"));
        }
        catch (KeeperException i4) {
            // empty catch block
        }
        Assert.assertTrue((outstanding.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Leader.Proposal)outstanding.values().iterator().next()).request.hdr.getType() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        mt[leader].shutdown();
        this.waitForAll(zk, ZooKeeper.States.CONNECTING);
        for (i = 0; i < 3; ++i) {
            if (i == leader) continue;
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            if (i == leader) continue;
            this.waitForOne(zk[i], ZooKeeper.States.CONNECTED);
            zk[i].create("/zk" + i, "zk".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        mt[leader].start();
        this.waitForAll(zk, ZooKeeper.States.CONNECTED);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == leader) {
                    Assert.assertTrue((String)((j == leader ? "Leader (" + leader + ")" : "Follower " + j) + " should not have /zk" + i), (zk[j].exists("/zk" + i, false) == null ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((String)((j == leader ? "Leader (" + leader + ")" : "Follower " + j) + " does not have /zk" + i), (zk[j].exists("/zk" + i, false) != null ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 3; ++i) {
            zk[i].close();
        }
        for (i = 0; i < 3; ++i) {
            mt[i].shutdown();
        }
    }

    @Test
    public void testHighestZxidJoinLate() throws Exception {
        int i;
        this.numServers = 3;
        this.servers = this.LaunchServers(this.numServers);
        String path = "/hzxidtest";
        int leader = this.servers.findLeader();
        Assert.assertTrue((String)"There should be a leader", (leader >= 0 ? 1 : 0) != 0);
        int nonleader = (leader + 1) % this.numServers;
        byte[] input = new byte[]{1};
        this.servers.zk[leader].create(path + leader, input, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.servers.zk[leader].create(path + nonleader, input, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] output = this.servers.zk[leader].getData(path + nonleader, false, null);
        for (i = 0; i < this.numServers; ++i) {
            if (i == leader) continue;
            this.servers.mt[i].shutdown();
        }
        input[0] = 2;
        this.servers.zk[leader].setData(path + leader, input, -1, null, null);
        Thread.sleep(500L);
        this.servers.mt[leader].shutdown();
        System.gc();
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTING);
        for (i = 0; i < this.numServers; ++i) {
            if (i == leader) continue;
            this.servers.mt[i].start();
        }
        this.waitForOne(this.servers.zk[nonleader], ZooKeeper.States.CONNECTED);
        output = this.servers.zk[nonleader].getData(path + leader, false, null);
        Assert.assertEquals((String)"Expecting old value 1 since 2 isn't committed yet", (long)output[0], (long)1L);
        this.servers.zk[nonleader].setData(path + nonleader, input, -1);
        this.servers.mt[leader].start();
        this.waitForOne(this.servers.zk[leader], ZooKeeper.States.CONNECTED);
        output = this.servers.zk[leader].getData(path + leader, false, null);
        Assert.assertEquals((String)"Validating that the deposed leader has rolled back that change it had written", (long)output[0], (long)1L);
        output = this.servers.zk[leader].getData(path + nonleader, false, null);
        Assert.assertEquals((String)"Validating that the deposed leader caught up on changes it missed", (long)output[0], (long)2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testElectionFraud() throws IOException, InterruptedException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = this.getConsoleAppender(os, Level.INFO);
        Logger qlogger = Logger.getLogger(QuorumPeer.class);
        qlogger.addAppender((Appender)appender);
        this.numServers = 3;
        boolean foundLeading = false;
        boolean foundLooking = false;
        boolean foundFollowing = false;
        try {
            String line;
            this.servers = this.LaunchServers(this.numServers, 500);
            int trueLeader = this.servers.findLeader();
            Assert.assertTrue((String)"There should be a leader", (trueLeader >= 0 ? 1 : 0) != 0);
            int falseLeader = (trueLeader + 1) % this.numServers;
            Assert.assertTrue((String)"All servers should join the quorum", (this.servers.mt[falseLeader].main.quorumPeer.follower != null ? 1 : 0) != 0);
            this.servers.mt[falseLeader].main.quorumPeer.electionAlg.shutdown();
            this.servers.mt[falseLeader].main.quorumPeer.follower.getSocket().close();
            this.waitForOne(this.servers.zk[falseLeader], ZooKeeper.States.CONNECTING);
            this.servers.mt[falseLeader].main.quorumPeer.setPeerState(QuorumPeer.ServerState.LEADING);
            Thread.sleep(2 * this.servers.mt[falseLeader].main.quorumPeer.initLimit * this.servers.mt[falseLeader].main.quorumPeer.tickTime);
            this.servers.mt[falseLeader].main.quorumPeer.startLeaderElection();
            this.servers.zk[falseLeader] = new ZooKeeper("127.0.0.1:" + this.servers.mt[falseLeader].getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            this.waitForOne(this.servers.zk[falseLeader], ZooKeeper.States.CONNECTED);
            Assert.assertTrue((this.servers.mt[trueLeader].main.quorumPeer.leader != null ? 1 : 0) != 0);
            LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
            Pattern leading = Pattern.compile(".*myid=" + falseLeader + ".*LEADING.*");
            Pattern looking = Pattern.compile(".*myid=" + falseLeader + ".*LOOKING.*");
            Pattern following = Pattern.compile(".*myid=" + falseLeader + ".*FOLLOWING.*");
            while ((line = r.readLine()) != null) {
                if (!foundLeading) {
                    foundLeading = leading.matcher(line).matches();
                    continue;
                }
                if (!foundLooking) {
                    foundLooking = looking.matcher(line).matches();
                    continue;
                }
                if (!following.matcher(line).matches()) continue;
                foundFollowing = true;
                break;
            }
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        Assert.assertTrue((String)"falseLeader never attempts to become leader", (boolean)foundLeading);
        Assert.assertTrue((String)"falseLeader never gives up on leadership", (boolean)foundLooking);
        Assert.assertTrue((String)"falseLeader never rejoins the quorum", (boolean)foundFollowing);
    }

    private void waitForOne(ZooKeeper zk, ZooKeeper.States state) throws InterruptedException {
        int iterations = ClientBase.CONNECTION_TIMEOUT / 500;
        while (zk.getState() != state) {
            if (iterations-- == 0) {
                throw new RuntimeException("Waiting too long " + zk.getState() + " != " + state);
            }
            Thread.sleep(500L);
        }
    }

    private void waitForAll(Servers servers, ZooKeeper.States state) throws InterruptedException {
        this.waitForAll(servers.zk, state);
    }

    private void waitForAll(ZooKeeper[] zks, ZooKeeper.States state) throws InterruptedException {
        int iterations = ClientBase.CONNECTION_TIMEOUT / 1000;
        boolean someoneNotConnected = true;
        while (someoneNotConnected) {
            if (iterations-- == 0) {
                ClientBase.logAllStackTraces();
                throw new RuntimeException("Waiting too long");
            }
            someoneNotConnected = false;
            for (ZooKeeper zk : zks) {
                if (zk.getState() == state) continue;
                someoneNotConnected = true;
                break;
            }
            Thread.sleep(1000L);
        }
    }

    private Servers LaunchServers(int numServers) throws IOException, InterruptedException {
        return this.LaunchServers(numServers, null);
    }

    private Servers LaunchServers(int numServers, Integer tickTime) throws IOException, InterruptedException {
        int SERVER_COUNT = numServers;
        Servers svrs = new Servers();
        svrs.clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < SERVER_COUNT; ++i) {
            svrs.clientPorts[i] = PortAssignment.unique();
            sb.append("server." + i + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
        }
        String quorumCfgSection = sb.toString();
        svrs.mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        svrs.zk = new ZooKeeper[SERVER_COUNT];
        for (int i = 0; i < SERVER_COUNT; ++i) {
            svrs.mt[i] = tickTime != null ? new QuorumPeerTestBase.MainThread(i, svrs.clientPorts[i], quorumCfgSection, new HashMap<String, String>(), tickTime) : new QuorumPeerTestBase.MainThread(i, svrs.clientPorts[i], quorumCfgSection);
            svrs.mt[i].start();
            svrs.restartClient(i, this);
        }
        this.waitForAll(svrs, ZooKeeper.States.CONNECTED);
        return svrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadPeerAddressInQuorum() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = this.getConsoleAppender(os, Level.WARN);
        Logger qlogger = Logger.getLogger((String)"org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=fee.fii.foo.fum:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            q1.start();
            boolean isup = ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, 30000L);
            Assert.assertFalse((String)"Server never came up", (boolean)isup);
            q1.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*Cannot open channel to .* at election address .*");
        while ((line = r.readLine()) != null && !(found = p.matcher(line).matches())) {
        }
        Assert.assertTrue((String)"complains about host", (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidIpv6AddressInQuorum() throws Exception {
        String line;
        this.assumeIPv6Available();
        ClientBase.setupTestEnv();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = this.getConsoleAppender(os, Level.INFO);
        appender.setImmediateFlush(true);
        Logger qlogger = Logger.getLogger((String)"org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=[0:0:0:0:0:0:0:1]:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
            q1.start();
            q2.start();
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("[0:0:0:0:0:0:0:1]:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            q1.shutdown();
            q2.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("[0:0:0:0:0:0:0:1]:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        os.close();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*Resolved hostname: 0:0:0:0:0:0:0:1.*");
        while ((line = r.readLine()) != null && !(found = p.matcher(line).matches())) {
        }
        Assert.assertTrue((String)"IPv6 address resolved", (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidIpv6AddressInQuorum() throws Exception {
        String line;
        this.assumeIPv6Available();
        ClientBase.setupTestEnv();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = this.getConsoleAppender(os, Level.INFO);
        appender.setImmediateFlush(true);
        Logger qlogger = Logger.getLogger((String)"org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=[0:0:0:0:0:0:0:1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            q1.start();
            boolean isup = ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, 30000L);
            Assert.assertFalse((String)"Server never came up", (boolean)isup);
            q1.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        os.close();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*QuorumPeerConfig\\$ConfigException.*");
        while ((line = r.readLine()) != null && !(found = p.matcher(line).matches())) {
        }
        Assert.assertTrue((String)"complains about configuration", (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInconsistentPeerType() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = this.getConsoleAppender(os, Level.INFO);
        Logger qlogger = Logger.getLogger((String)"org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            int CLIENT_PORT_QP3 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.3=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer";
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
            QuorumPeerTestBase.MainThread q3 = new QuorumPeerTestBase.MainThread(3, CLIENT_PORT_QP3, quorumCfgSection);
            q1.start();
            q2.start();
            q3.start();
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP3, ClientBase.CONNECTION_TIMEOUT));
            q1.shutdown();
            q2.shutdown();
            q3.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 3 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP3, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean warningPresent = false;
        boolean defaultedToObserver = false;
        Pattern pWarn = Pattern.compile(".*Peer type from servers list.* doesn't match peerType.*");
        Pattern pObserve = Pattern.compile(".*OBSERVING.*");
        while ((line = r.readLine()) != null) {
            if (pWarn.matcher(line).matches()) {
                warningPresent = true;
            }
            if (pObserve.matcher(line).matches()) {
                defaultedToObserver = true;
            }
            if (!warningPresent || !defaultedToObserver) continue;
        }
        Assert.assertTrue((String)"Should warn about inconsistent peer type", (warningPresent && defaultedToObserver ? 1 : 0) != 0);
    }

    @Test
    public void testBadPackets() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        int electionPort1 = PortAssignment.unique();
        int electionPort2 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + electionPort1 + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + electionPort2;
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q1.start();
        q2.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        byte[] b = new byte[4];
        int length = 0x40000000;
        ByteBuffer buff = ByteBuffer.wrap(b);
        buff.putInt(length);
        buff.position(0);
        SocketChannel s = SocketChannel.open(new InetSocketAddress("127.0.0.1", electionPort1));
        s.write(buff);
        s.close();
        buff.position(0);
        s = SocketChannel.open(new InetSocketAddress("127.0.0.1", electionPort2));
        s.write(buff);
        s.close();
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.waitForOne(zk, ZooKeeper.States.CONNECTED);
        zk.create("/foo_q1", "foobar1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(zk.getData("/foo_q1", null, null)), (Object)"foobar1");
        zk.close();
        q1.shutdown();
        q2.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuorumDefaults() throws Exception {
        String line;
        ClientBase.setupTestEnv();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = this.getConsoleAppender(os, Level.INFO);
        appender.setImmediateFlush(true);
        Logger zlogger = Logger.getLogger((String)"org.apache.zookeeper");
        zlogger.addAppender((Appender)appender);
        try {
            int CLIENT_PORT_QP1 = PortAssignment.unique();
            int CLIENT_PORT_QP2 = PortAssignment.unique();
            String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
            QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
            QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
            q1.start();
            q2.start();
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
            q1.shutdown();
            q2.shutdown();
            Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            zlogger.removeAppender((Appender)appender);
        }
        os.close();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean found = false;
        Pattern p = Pattern.compile(".*FastLeaderElection.*");
        while ((line = r.readLine()) != null && !(found = p.matcher(line).matches())) {
        }
        Assert.assertTrue((String)"fastleaderelection used", (boolean)found);
    }

    @Test
    public void testQuorumPeerExitTime() throws Exception {
        long maxwait = 3000L;
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\nserver.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique();
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        q1.start();
        Thread.sleep(30000L);
        long start = Time.currentElapsedTime();
        q1.shutdown();
        long end = Time.currentElapsedTime();
        if (end - start > maxwait) {
            Assert.fail((String)("QuorumPeer took " + (end - start) + " to shutdown, expected " + maxwait));
        }
    }

    static long readLongFromFile(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = "";
        try {
            line = br.readLine();
            long l = Long.parseLong(line);
            return l;
        }
        catch (NumberFormatException e) {
            throw new IOException("Found " + line + " in " + file);
        }
        finally {
            br.close();
        }
    }

    static void writeLongToFile(File file, long value) throws IOException {
        AtomicFileOutputStream out = new AtomicFileOutputStream(file);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out));
        try {
            bw.write(Long.toString(value));
            bw.flush();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write new file " + file), (Throwable)e);
            out.abort();
            throw e;
        }
    }

    @Test
    public void testUpdatingEpoch() throws Exception {
        File currentEpochFile;
        int i;
        this.numServers = 3;
        this.servers = this.LaunchServers(this.numServers);
        for (i = 0; i < 10; ++i) {
            int j;
            for (j = 0; j < this.numServers; ++j) {
                this.servers.mt[j].shutdown();
            }
            this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTING);
            for (j = 0; j < this.numServers; ++j) {
                this.servers.mt[j].start();
            }
            this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTED);
        }
        for (i = 0; i < this.numServers; ++i) {
            currentEpochFile = new File(new File(this.servers.mt[i].dataDir, "version-2"), "currentEpoch");
            LOG.info((Object)("Validating current epoch: " + this.servers.mt[i].dataDir));
            Assert.assertEquals((String)"Current epoch should be 11.", (long)11L, (long)QuorumPeerMainTest.readLongFromFile(currentEpochFile));
        }
        int followerIndex = -1;
        for (int i2 = 0; i2 < this.numServers; ++i2) {
            if (this.servers.mt[i2].main.quorumPeer.leader != null) continue;
            followerIndex = i2;
            break;
        }
        Assert.assertTrue((String)"Found a valid follower", (followerIndex >= 0 && followerIndex < this.numServers ? 1 : 0) != 0);
        QuorumPeerTestBase.MainThread follower = this.servers.mt[followerIndex];
        long zxid = follower.main.quorumPeer.getLastLoggedZxid();
        long epochFromZxid = ZxidUtils.getEpochFromZxid((long)zxid);
        for (int i3 = 0; i3 < this.numServers; ++i3) {
            this.servers.mt[i3].shutdown();
        }
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTING);
        File followerDataDir = new File(follower.dataDir, "version-2");
        currentEpochFile = new File(followerDataDir, "currentEpoch");
        QuorumPeerMainTest.writeLongToFile(currentEpochFile, epochFromZxid - 1L);
        follower.start();
        Assert.assertTrue((boolean)follower.mainFailed.await(10L, TimeUnit.SECONDS));
        File updatingEpochFile = new File(followerDataDir, "updatingEpoch");
        updatingEpochFile.createNewFile();
        for (int i4 = 0; i4 < this.numServers; ++i4) {
            this.servers.mt[i4].start();
        }
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTED);
        Assert.assertNotNull((String)"Make sure the server started with acceptEpoch", (Object)follower.main.quorumPeer.getActiveServer());
        Assert.assertFalse((String)"updatingEpoch file should get deleted", (boolean)updatingEpochFile.exists());
    }

    @Test
    public void testNewFollowerRestartAfterNewEpoch() throws Exception {
        int i;
        this.numServers = 3;
        this.servers = this.LaunchServers(this.numServers);
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTED);
        String inputString = "test";
        byte[] input = inputString.getBytes();
        String path = "/newepochzxidtest";
        this.servers.zk[0].create(path, input, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.servers.zk[0].setData(path, input, -1);
        byte[] output = this.servers.zk[1].getData(path, false, null);
        for (int i2 = 0; i2 < this.numServers; ++i2) {
            this.servers.mt[i2].shutdown();
        }
        LOG.info((Object)"resetting follower");
        QuorumPeerTestBase.MainThread follower = this.servers.mt[0];
        File followerDataDir = new File(follower.dataDir, "version-2");
        for (File file : followerDataDir.listFiles()) {
            LOG.info((Object)("deleting " + file.getName()));
            file.delete();
        }
        for (i = 1; i < this.numServers; ++i) {
            this.servers.mt[i].start();
        }
        for (i = 1; i < this.numServers; ++i) {
            this.waitForOne(this.servers.zk[i], ZooKeeper.States.CONNECTED);
        }
        follower.start();
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTED);
        follower.shutdown();
        follower.start();
        Assert.assertFalse((boolean)follower.mainFailed.await(10L, TimeUnit.SECONDS));
        this.waitForAll(this.servers.zk, ZooKeeper.States.CONNECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataDirAndDataLogDir() throws Exception {
        File dataDir = ClientBase.createEmptyTestDir();
        File dataLogDir = ClientBase.createEmptyTestDir();
        try {
            QuorumPeerConfig configMock = (QuorumPeerConfig)Mockito.mock(QuorumPeerConfig.class);
            Mockito.when((Object)configMock.getDataDir()).thenReturn((Object)dataDir.getAbsolutePath());
            Mockito.when((Object)configMock.getDataLogDir()).thenReturn((Object)dataLogDir.getAbsolutePath());
            QuorumPeer qpMock = (QuorumPeer)Mockito.mock(QuorumPeer.class);
            ((QuorumPeer)Mockito.doCallRealMethod().when((Object)qpMock)).setTxnFactory((FileTxnSnapLog)Matchers.any(FileTxnSnapLog.class));
            Mockito.when((Object)qpMock.getTxnFactory()).thenCallRealMethod();
            InjectableQuorumPeerMain qpMain = new InjectableQuorumPeerMain(qpMock);
            qpMain.runFromConfig(configMock);
            FileTxnSnapLog txnFactory = qpMain.getQuorumPeer().getTxnFactory();
            Assert.assertEquals((Object)(dataLogDir.getAbsolutePath() + "/version-2"), (Object)txnFactory.getDataDir().getAbsolutePath());
            Assert.assertEquals((Object)(dataDir.getAbsolutePath() + "/version-2"), (Object)txnFactory.getSnapDir().getAbsolutePath());
        }
        finally {
            FileUtils.deleteDirectory((File)dataDir);
            FileUtils.deleteDirectory((File)dataLogDir);
        }
    }

    @Test
    public void testFailedTxnAsPartOfQuorumLoss() throws Exception {
        int i;
        int LEADER_TIMEOUT_MS = 10000;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 3;
        this.servers = this.LaunchServers(3);
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTED);
        this.servers.shutDownAllServers();
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTING);
        this.servers.restartAllServersAndClients(this);
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTED);
        int leader = this.servers.findLeader();
        ConcurrentMap outstanding = this.servers.mt[leader].main.quorumPeer.leader.outstandingProposals;
        this.servers.mt[leader].main.quorumPeer.tickTime = 10000;
        LOG.warn((Object)("LEADER " + leader));
        for (i = 0; i < 3; ++i) {
            if (i == leader) continue;
            this.servers.mt[i].shutdown();
        }
        for (i = 0; i < 3; ++i) {
            if (i == leader) continue;
            this.servers.mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            if (i == leader) continue;
            this.servers.restartClient(i, this);
            this.waitForOne(this.servers.zk[i], ZooKeeper.States.CONNECTED);
        }
        try {
            this.servers.zk[leader].create("/zk" + leader, "zk".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.fail((String)("create /zk" + leader + " should have failed"));
        }
        catch (KeeperException i2) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)outstanding.size());
        Leader.Proposal p = (Leader.Proposal)outstanding.values().iterator().next();
        Assert.assertEquals((long)1L, (long)p.request.hdr.getType());
        int sleepTime = 0;
        Long longLeader = new Long(leader);
        while (!p.ackSet.contains(longLeader)) {
            if (sleepTime > 2000) {
                Assert.fail((String)("Transaction not synced to disk within 1 second " + p.ackSet + " expected " + leader));
            }
            Thread.sleep(100L);
            sleepTime += 100;
        }
        LOG.info((Object)("Waiting for leader " + leader + " to timeout followers"));
        sleepTime = 0;
        Follower f = this.servers.mt[leader].main.quorumPeer.follower;
        while (f == null || !f.isRunning()) {
            if (sleepTime > 20000) {
                Assert.fail((String)("Took too long for old leader to time out " + this.servers.mt[leader].main.quorumPeer.getPeerState()));
            }
            Thread.sleep(100L);
            sleepTime += 100;
            f = this.servers.mt[leader].main.quorumPeer.follower;
        }
        int newLeader = this.servers.findLeader();
        Assert.assertTrue((leader != newLeader ? 1 : 0) != 0);
        this.servers.mt[leader].shutdown();
        this.servers.mt[leader].start();
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTED);
        for (int i3 = 0; i3 < 3; ++i3) {
            Assert.assertNull((String)("server " + i3 + " should not have /zk" + leader), (Object)this.servers.zk[i3].exists("/zk" + leader, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderOutOfView() throws Exception {
        ClientBase.setupTestEnv();
        int numServers = 3;
        boolean foundLeading = false;
        boolean foundFollowing = false;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = this.getConsoleAppender(os, Level.DEBUG);
        Logger qlogger = Logger.getLogger((String)"org.apache.zookeeper.server.quorum");
        qlogger.addAppender((Appender)appender);
        try {
            String line;
            int i;
            Servers svrs = new Servers();
            svrs.clientPorts = new int[numServers];
            for (int i2 = 0; i2 < numServers; ++i2) {
                svrs.clientPorts[i2] = PortAssignment.unique();
            }
            String quorumCfgIncomplete = this.getUniquePortCfgForId(1) + "\n" + this.getUniquePortCfgForId(2);
            String quorumCfgComplete = quorumCfgIncomplete + "\n" + this.getUniquePortCfgForId(3);
            svrs.mt = new QuorumPeerTestBase.MainThread[3];
            svrs.mt[0] = new QuorumPeerTestBase.MainThread(1, svrs.clientPorts[0], quorumCfgIncomplete);
            for (int i3 = 1; i3 < numServers; ++i3) {
                svrs.mt[i3] = new QuorumPeerTestBase.MainThread(i3 + 1, svrs.clientPorts[i3], quorumCfgComplete);
            }
            svrs.mt[0].start();
            QuorumPeer quorumPeer1 = this.waitForQuorumPeer(svrs.mt[0], ClientBase.CONNECTION_TIMEOUT);
            Assert.assertTrue((quorumPeer1.getPeerState() == QuorumPeer.ServerState.LOOKING ? 1 : 0) != 0);
            int highestServerIndex = numServers - 1;
            svrs.mt[highestServerIndex].start();
            QuorumPeer quorumPeer3 = this.waitForQuorumPeer(svrs.mt[highestServerIndex], ClientBase.CONNECTION_TIMEOUT);
            Assert.assertTrue((quorumPeer3.getPeerState() == QuorumPeer.ServerState.LOOKING ? 1 : 0) != 0);
            for (i = 1; i < highestServerIndex; ++i) {
                svrs.mt[i].start();
            }
            for (i = 1; i < numServers; ++i) {
                Assert.assertTrue((String)"waiting for server to start", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + svrs.clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
            }
            Assert.assertTrue((svrs.mt[0].getQuorumPeer().getPeerState() == QuorumPeer.ServerState.LOOKING ? 1 : 0) != 0);
            Assert.assertTrue((svrs.mt[highestServerIndex].getQuorumPeer().getPeerState() == QuorumPeer.ServerState.LEADING ? 1 : 0) != 0);
            for (i = 1; i < highestServerIndex; ++i) {
                Assert.assertTrue((svrs.mt[i].getQuorumPeer().getPeerState() == QuorumPeer.ServerState.FOLLOWING ? 1 : 0) != 0);
            }
            LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
            Pattern leading = Pattern.compile(".*myid=1.*QuorumPeer.*LEADING.*");
            Pattern following = Pattern.compile(".*myid=1.*QuorumPeer.*FOLLOWING.*");
            while ((line = r.readLine()) != null && !foundLeading && !foundFollowing) {
                foundLeading = leading.matcher(line).matches();
                foundFollowing = following.matcher(line).matches();
            }
        }
        finally {
            qlogger.removeAppender((Appender)appender);
        }
        Assert.assertFalse((String)"Corrupt peer should never become leader", (boolean)foundLeading);
        Assert.assertFalse((String)"Corrupt peer should not attempt connection to out of view leader", (boolean)foundFollowing);
    }

    private WriterAppender getConsoleAppender(ByteArrayOutputStream os, Level level) {
        String loggingPattern = ((PatternLayout)Logger.getRootLogger().getAppender("CONSOLE").getLayout()).getConversionPattern();
        WriterAppender appender = new WriterAppender((Layout)new PatternLayout(loggingPattern), (OutputStream)os);
        appender.setThreshold((Priority)level);
        return appender;
    }

    private String getUniquePortCfgForId(int id) {
        return String.format("server.%d=127.0.0.1:%d:%d", id, PortAssignment.unique(), PortAssignment.unique());
    }

    private QuorumPeer waitForQuorumPeer(QuorumPeerTestBase.MainThread mainThread, int timeout) throws TimeoutException {
        long start = Time.currentElapsedTime();
        while (true) {
            QuorumPeer quorumPeer;
            QuorumPeer quorumPeer2 = quorumPeer = mainThread.isAlive() ? mainThread.getQuorumPeer() : null;
            if (quorumPeer != null) {
                return quorumPeer;
            }
            if (Time.currentElapsedTime() > start + (long)timeout) {
                LOG.error((Object)"Timed out while waiting for QuorumPeer");
                throw new TimeoutException();
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private class InjectableQuorumPeerMain
    extends QuorumPeerMain {
        QuorumPeer qp;

        InjectableQuorumPeerMain(QuorumPeer qp) {
            this.qp = qp;
        }

        protected QuorumPeer getQuorumPeer() {
            return this.qp;
        }
    }

    private class Servers {
        QuorumPeerTestBase.MainThread[] mt;
        ZooKeeper[] zk;
        int[] clientPorts;

        private Servers() {
        }

        public void shutDownAllServers() throws InterruptedException {
            for (QuorumPeerTestBase.MainThread t : this.mt) {
                t.shutdown();
            }
        }

        public void restartAllServersAndClients(Watcher watcher) throws IOException {
            for (QuorumPeerTestBase.MainThread t : this.mt) {
                if (t.isAlive()) continue;
                t.start();
            }
            for (int i = 0; i < this.zk.length; ++i) {
                this.restartClient(i, watcher);
            }
        }

        public void restartClient(int clientIndex, Watcher watcher) throws IOException {
            this.zk[clientIndex] = new ZooKeeper("127.0.0.1:" + this.clientPorts[clientIndex], ClientBase.CONNECTION_TIMEOUT, watcher);
        }

        public int findLeader() {
            for (int i = 0; i < this.mt.length; ++i) {
                if (this.mt[i].main.quorumPeer.leader == null) continue;
                return i;
            }
            return -1;
        }
    }
}

