/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyModeTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyModeTest.class);
    private static int CONNECTION_TIMEOUT = QuorumBase.CONNECTION_TIMEOUT;
    private QuorumUtil qu = new QuorumUtil(1);

    @Before
    public void setUp() throws Exception {
        System.setProperty("readonlymode.enabled", "true");
        this.qu.startQuorum();
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("readonlymode.enabled", "false");
        this.qu.tearDown();
    }

    @Test(timeout=90000L)
    public void testMultiTransaction() throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String data = "Data to be read in RO mode";
        String node1 = "/tnode1";
        String node2 = "/tnode2";
        zk.create("/tnode1", "Data to be read in RO mode".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        watcher.reset();
        this.qu.shutdown(2);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        Assert.assertEquals((String)"Should be in r-o mode", (Object)ZooKeeper.States.CONNECTEDREADONLY, (Object)zk.getState());
        String remoteData = new String(zk.getData("/tnode1", false, null));
        Assert.assertEquals((String)"Failed to read data in r-o mode", (String)"Data to be read in RO mode", (String)remoteData);
        try {
            Transaction transaction = zk.transaction();
            transaction.setData("/tnode1", "no way".getBytes(), -1);
            transaction.create("/tnode2", "Data to be read in RO mode".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            transaction.commit();
            Assert.fail((String)"Write operation using multi-transaction api has succeeded during RO mode");
        }
        catch (KeeperException.NotReadOnlyException notReadOnlyException) {
            // empty catch block
        }
        Assert.assertNull((String)"Should have created the znode:/tnode2", (Object)zk.exists("/tnode2", false));
    }

    @Test(timeout=90000L)
    public void testReadOnlyClient() throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String data = "Data to be read in RO mode";
        String node = "/tnode";
        zk.create("/tnode", "Data to be read in RO mode".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        watcher.reset();
        this.qu.shutdown(2);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String remoteData = new String(zk.getData("/tnode", false, null));
        Assert.assertEquals((String)"Data to be read in RO mode", (String)remoteData);
        try {
            zk.setData("/tnode", "no way".getBytes(), -1);
            Assert.fail((String)"Write operation has succeeded during RO mode");
        }
        catch (KeeperException.NotReadOnlyException notReadOnlyException) {
            // empty catch block
        }
        watcher.reset();
        this.qu.start(2);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.qu.getPeer((int)2).clientPort, CONNECTION_TIMEOUT));
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        zk.setData("/tnode", "We're in the quorum now".getBytes(), -1);
        zk.close();
    }

    @Test(timeout=90000L)
    public void testConnectionEvents() throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        boolean success = false;
        for (int i = 0; i < 30; ++i) {
            try {
                zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                success = true;
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                Thread.sleep(1000L);
                continue;
            }
        }
        Assert.assertTrue((String)"Did not succeed in connecting in 30s", (boolean)success);
        Assert.assertFalse((String)"The connection should not be read-only yet", (boolean)watcher.readOnlyConnected);
        this.qu.shutdown(2);
        long start = Time.currentElapsedTime();
        while (zk.getState() != ZooKeeper.States.CONNECTEDREADONLY) {
            Thread.sleep(200L);
            Assert.assertTrue((String)"Can't connect to the server", (Time.currentElapsedTime() - start < 30000L ? 1 : 0) != 0);
        }
        watcher.waitForReadOnlyConnected(5000L);
        zk.close();
    }

    @Test(timeout=90000L)
    public void testSessionEstablishment() throws Exception {
        this.qu.shutdown(2);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        LOG.debug("Connection string: {}", (Object)this.qu.getConnString());
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        Assert.assertSame((String)"should be in r/o mode", (Object)ZooKeeper.States.CONNECTEDREADONLY, (Object)zk.getState());
        long fakeId = zk.getSessionId();
        LOG.info("Connected as r/o mode with state {} and session id {}", (Object)zk.getState(), (Object)fakeId);
        watcher.reset();
        this.qu.start(2);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.qu.getPeer((int)2).clientPort, CONNECTION_TIMEOUT));
        LOG.info("Server 127.0.0.1:{} is up", (Object)this.qu.getPeer((int)2).clientPort);
        watcher.waitForSyncConnected(CONNECTION_TIMEOUT);
        Assert.assertEquals((String)"Should be in read-write mode", (Object)ZooKeeper.States.CONNECTED, (Object)zk.getState());
        LOG.info("Connected as rw mode with state {} and session id {}", (Object)zk.getState(), (Object)zk.getSessionId());
        zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertFalse((String)"fake session and real session have same id", (zk.getSessionId() == fakeId ? 1 : 0) != 0);
        zk.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testSeekForRwServer() throws Exception {
        String line;
        Layout layout = org.apache.log4j.Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setImmediateFlush(true);
        appender.setThreshold((Priority)Level.INFO);
        org.apache.log4j.Logger zlogger = org.apache.log4j.Logger.getLogger((String)"org.apache.zookeeper");
        zlogger.addAppender((Appender)appender);
        try {
            this.qu.shutdown(2);
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            this.qu.getPeer((int)1).peer.suspend();
            watcher.reset();
            this.qu.start(2);
            this.qu.start(3);
            ClientBase.waitForServerUp(this.qu.getConnString(), 2000L);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.qu.getPeer((int)1).peer.resume();
        }
        finally {
            zlogger.removeAppender((Appender)appender);
        }
        os.close();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        Pattern p = Pattern.compile(".*Majority server found.*");
        boolean found = false;
        while ((line = r.readLine()) != null) {
            if (!p.matcher(line).matches()) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Majority server wasn't found while connected to r/o server", (boolean)found);
    }
}

