/*
OpenIO SDS meta0v2
Copyright (C) 2014 Worldine, original work as part of Redcurrant
Copyright (C) 2015 OpenIO, modified as part of OpenIO Software Defined Storage

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef OIO_SDS__meta0v2__meta0_gridd_dispatcher_h
# define OIO_SDS__meta0v2__meta0_gridd_dispatcher_h 1

#include <sqliterepo/zk_manager.h>
/**
 * @addtogroup meta0v2_gridd 
 * @{
 */

struct gridd_request_descr_s;

struct meta0_disp_s;

/**
 * The easiest way to retrieve the set of exported function out of
 * the META0 backend.
 *
 * All these functions take a meta0_disp_s as first argument.
 *
 * @return
 */
const struct gridd_request_descr_s* meta0_gridd_get_requests(void);

/**
 * @param m0disp
 */
void meta0_gridd_free_dispatcher(struct meta0_disp_s *m0disp);

/**
 * @param m0
 * @return
 */
struct meta0_disp_s* meta0_gridd_get_dispatcher(struct meta0_backend_s *m0, struct zk_manager_s *m0zkmanager, gchar *ns_name);

void meta0_gridd_requested_reload(struct meta0_disp_s *m0disp);

/** @} */

#endif /*OIO_SDS__meta0v2__meta0_gridd_dispatcher_h*/