<!--This file was generated from the python source
Please edit the source to make changes
-->
SlabInfoCollector
=====

The SlabInfoCollector collects metrics on process stats from
/proc/slabinfo

#### Dependencies

 * /proc/slabinfo


#### Options

Setting | Default | Description | Type
--------|---------|-------------|-----
byte_unit | byte | Default numeric output(s) | str
enabled | False | Enable collecting these metrics | bool
measure_collector_time | False | Collect the collector run time in ms | bool
metrics_blacklist | None | Regex to match metrics to block. Mutually exclusive with metrics_whitelist | NoneType
metrics_whitelist | None | Regex to match metrics to transmit. Mutually exclusive with metrics_blacklist | NoneType

#### Example Output

```
servers.hostname.slabinfo.Acpi-Namespace.active_objs 1201
servers.hostname.slabinfo.Acpi-Namespace.num_objs 1456
servers.hostname.slabinfo.Acpi-Namespace.objperslab 112
servers.hostname.slabinfo.Acpi-Namespace.objsize 32
servers.hostname.slabinfo.Acpi-Namespace.pagesperslab 1
servers.hostname.slabinfo.Acpi-Namespace.slabdata.active_slabs 13
servers.hostname.slabinfo.Acpi-Namespace.slabdata.num_slabs 13
servers.hostname.slabinfo.Acpi-Namespace.slabdata.sharedavail 0
servers.hostname.slabinfo.Acpi-Namespace.tunables.batchcount 60
servers.hostname.slabinfo.Acpi-Namespace.tunables.limit 120
servers.hostname.slabinfo.Acpi-Namespace.tunables.sharedfactor 8
servers.hostname.slabinfo.Acpi-Operand.active_objs 3831
servers.hostname.slabinfo.Acpi-Operand.num_objs 4897
servers.hostname.slabinfo.Acpi-Operand.objperslab 59
servers.hostname.slabinfo.Acpi-Operand.objsize 64
servers.hostname.slabinfo.Acpi-Operand.pagesperslab 1
servers.hostname.slabinfo.Acpi-Operand.slabdata.active_slabs 83
servers.hostname.slabinfo.Acpi-Operand.slabdata.num_slabs 83
servers.hostname.slabinfo.Acpi-Operand.slabdata.sharedavail 0
servers.hostname.slabinfo.Acpi-Operand.tunables.batchcount 60
servers.hostname.slabinfo.Acpi-Operand.tunables.limit 120
servers.hostname.slabinfo.Acpi-Operand.tunables.sharedfactor 8
servers.hostname.slabinfo.Acpi-Parse.active_objs 0
servers.hostname.slabinfo.Acpi-Parse.num_objs 0
servers.hostname.slabinfo.Acpi-Parse.objperslab 92
servers.hostname.slabinfo.Acpi-Parse.objsize 40
servers.hostname.slabinfo.Acpi-Parse.pagesperslab 1
servers.hostname.slabinfo.Acpi-Parse.slabdata.active_slabs 0
servers.hostname.slabinfo.Acpi-Parse.slabdata.num_slabs 0
servers.hostname.slabinfo.Acpi-Parse.slabdata.sharedavail 0
servers.hostname.slabinfo.Acpi-Parse.tunables.batchcount 60
servers.hostname.slabinfo.Acpi-Parse.tunables.limit 120
servers.hostname.slabinfo.Acpi-Parse.tunables.sharedfactor 8
servers.hostname.slabinfo.Acpi-ParseExt.active_objs 0
servers.hostname.slabinfo.Acpi-ParseExt.num_objs 0
servers.hostname.slabinfo.Acpi-ParseExt.objperslab 59
servers.hostname.slabinfo.Acpi-ParseExt.objsize 64
servers.hostname.slabinfo.Acpi-ParseExt.pagesperslab 1
servers.hostname.slabinfo.Acpi-ParseExt.slabdata.active_slabs 0
servers.hostname.slabinfo.Acpi-ParseExt.slabdata.num_slabs 0
servers.hostname.slabinfo.Acpi-ParseExt.slabdata.sharedavail 0
servers.hostname.slabinfo.Acpi-ParseExt.tunables.batchcount 60
servers.hostname.slabinfo.Acpi-ParseExt.tunables.limit 120
servers.hostname.slabinfo.Acpi-ParseExt.tunables.sharedfactor 8
servers.hostname.slabinfo.Acpi-State.active_objs 0
servers.hostname.slabinfo.Acpi-State.num_objs 0
servers.hostname.slabinfo.Acpi-State.objperslab 48
servers.hostname.slabinfo.Acpi-State.objsize 80
servers.hostname.slabinfo.Acpi-State.pagesperslab 1
servers.hostname.slabinfo.Acpi-State.slabdata.active_slabs 0
servers.hostname.slabinfo.Acpi-State.slabdata.num_slabs 0
servers.hostname.slabinfo.Acpi-State.slabdata.sharedavail 0
servers.hostname.slabinfo.Acpi-State.tunables.batchcount 60
servers.hostname.slabinfo.Acpi-State.tunables.limit 120
servers.hostname.slabinfo.Acpi-State.tunables.sharedfactor 8
servers.hostname.slabinfo.RAW.active_objs 25
servers.hostname.slabinfo.RAW.num_objs 25
servers.hostname.slabinfo.RAW.objperslab 5
servers.hostname.slabinfo.RAW.objsize 768
servers.hostname.slabinfo.RAW.pagesperslab 1
servers.hostname.slabinfo.RAW.slabdata.active_slabs 5
servers.hostname.slabinfo.RAW.slabdata.num_slabs 5
servers.hostname.slabinfo.RAW.slabdata.sharedavail 0
servers.hostname.slabinfo.RAW.tunables.batchcount 27
servers.hostname.slabinfo.RAW.tunables.limit 54
servers.hostname.slabinfo.RAW.tunables.sharedfactor 8
servers.hostname.slabinfo.RAWv6.active_objs 27
servers.hostname.slabinfo.RAWv6.num_objs 28
servers.hostname.slabinfo.RAWv6.objperslab 4
servers.hostname.slabinfo.RAWv6.objsize 960
servers.hostname.slabinfo.RAWv6.pagesperslab 1
servers.hostname.slabinfo.RAWv6.slabdata.active_slabs 7
servers.hostname.slabinfo.RAWv6.slabdata.num_slabs 7
servers.hostname.slabinfo.RAWv6.slabdata.sharedavail 0
servers.hostname.slabinfo.RAWv6.tunables.batchcount 27
servers.hostname.slabinfo.RAWv6.tunables.limit 54
servers.hostname.slabinfo.RAWv6.tunables.sharedfactor 8
servers.hostname.slabinfo.TCP.active_objs 85
servers.hostname.slabinfo.TCP.num_objs 85
servers.hostname.slabinfo.TCP.objperslab 5
servers.hostname.slabinfo.TCP.objsize 1600
servers.hostname.slabinfo.TCP.pagesperslab 2
servers.hostname.slabinfo.TCP.slabdata.active_slabs 17
servers.hostname.slabinfo.TCP.slabdata.num_slabs 17
servers.hostname.slabinfo.TCP.slabdata.sharedavail 0
servers.hostname.slabinfo.TCP.tunables.batchcount 12
servers.hostname.slabinfo.TCP.tunables.limit 24
servers.hostname.slabinfo.TCP.tunables.sharedfactor 8
servers.hostname.slabinfo.TCPv6.active_objs 40
servers.hostname.slabinfo.TCPv6.num_objs 40
servers.hostname.slabinfo.TCPv6.objperslab 4
servers.hostname.slabinfo.TCPv6.objsize 1728
servers.hostname.slabinfo.TCPv6.pagesperslab 2
servers.hostname.slabinfo.TCPv6.slabdata.active_slabs 10
servers.hostname.slabinfo.TCPv6.slabdata.num_slabs 10
servers.hostname.slabinfo.TCPv6.slabdata.sharedavail 0
servers.hostname.slabinfo.TCPv6.tunables.batchcount 12
servers.hostname.slabinfo.TCPv6.tunables.limit 24
servers.hostname.slabinfo.TCPv6.tunables.sharedfactor 8
servers.hostname.slabinfo.UDP.active_objs 120
servers.hostname.slabinfo.UDP.num_objs 120
servers.hostname.slabinfo.UDP.objperslab 5
servers.hostname.slabinfo.UDP.objsize 768
servers.hostname.slabinfo.UDP.pagesperslab 1
servers.hostname.slabinfo.UDP.slabdata.active_slabs 24
servers.hostname.slabinfo.UDP.slabdata.num_slabs 24
servers.hostname.slabinfo.UDP.slabdata.sharedavail 14
servers.hostname.slabinfo.UDP.tunables.batchcount 27
servers.hostname.slabinfo.UDP.tunables.limit 54
servers.hostname.slabinfo.UDP.tunables.sharedfactor 8
servers.hostname.slabinfo.UDPv6.active_objs 4
servers.hostname.slabinfo.UDPv6.num_objs 4
servers.hostname.slabinfo.UDPv6.objperslab 4
servers.hostname.slabinfo.UDPv6.objsize 896
servers.hostname.slabinfo.UDPv6.pagesperslab 1
servers.hostname.slabinfo.UDPv6.slabdata.active_slabs 1
servers.hostname.slabinfo.UDPv6.slabdata.num_slabs 1
servers.hostname.slabinfo.UDPv6.slabdata.sharedavail 0
servers.hostname.slabinfo.UDPv6.tunables.batchcount 27
servers.hostname.slabinfo.UDPv6.tunables.limit 54
servers.hostname.slabinfo.UDPv6.tunables.sharedfactor 8
servers.hostname.slabinfo.UNIX.active_objs 76
servers.hostname.slabinfo.UNIX.num_objs 77
servers.hostname.slabinfo.UNIX.objperslab 11
servers.hostname.slabinfo.UNIX.objsize 704
servers.hostname.slabinfo.UNIX.pagesperslab 2
servers.hostname.slabinfo.UNIX.slabdata.active_slabs 7
servers.hostname.slabinfo.UNIX.slabdata.num_slabs 7
servers.hostname.slabinfo.UNIX.slabdata.sharedavail 3
servers.hostname.slabinfo.UNIX.tunables.batchcount 27
servers.hostname.slabinfo.UNIX.tunables.limit 54
servers.hostname.slabinfo.UNIX.tunables.sharedfactor 8
servers.hostname.slabinfo.anon_vma.active_objs 1469
servers.hostname.slabinfo.anon_vma.num_objs 3168
servers.hostname.slabinfo.anon_vma.objperslab 144
servers.hostname.slabinfo.anon_vma.objsize 24
servers.hostname.slabinfo.anon_vma.pagesperslab 1
servers.hostname.slabinfo.anon_vma.slabdata.active_slabs 22
servers.hostname.slabinfo.anon_vma.slabdata.num_slabs 22
servers.hostname.slabinfo.anon_vma.slabdata.sharedavail 12
servers.hostname.slabinfo.anon_vma.tunables.batchcount 60
servers.hostname.slabinfo.anon_vma.tunables.limit 120
servers.hostname.slabinfo.anon_vma.tunables.sharedfactor 8
servers.hostname.slabinfo.arp_cache.active_objs 23
servers.hostname.slabinfo.arp_cache.num_objs 60
servers.hostname.slabinfo.arp_cache.objperslab 15
servers.hostname.slabinfo.arp_cache.objsize 256
servers.hostname.slabinfo.arp_cache.pagesperslab 1
servers.hostname.slabinfo.arp_cache.slabdata.active_slabs 4
servers.hostname.slabinfo.arp_cache.slabdata.num_slabs 4
servers.hostname.slabinfo.arp_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.arp_cache.tunables.batchcount 60
servers.hostname.slabinfo.arp_cache.tunables.limit 120
servers.hostname.slabinfo.arp_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.as_arq.active_objs 0
servers.hostname.slabinfo.as_arq.num_objs 0
servers.hostname.slabinfo.as_arq.objperslab 40
servers.hostname.slabinfo.as_arq.objsize 96
servers.hostname.slabinfo.as_arq.pagesperslab 1
servers.hostname.slabinfo.as_arq.slabdata.active_slabs 0
servers.hostname.slabinfo.as_arq.slabdata.num_slabs 0
servers.hostname.slabinfo.as_arq.slabdata.sharedavail 0
servers.hostname.slabinfo.as_arq.tunables.batchcount 60
servers.hostname.slabinfo.as_arq.tunables.limit 120
servers.hostname.slabinfo.as_arq.tunables.sharedfactor 8
servers.hostname.slabinfo.avc_node.active_objs 14
servers.hostname.slabinfo.avc_node.num_objs 106
servers.hostname.slabinfo.avc_node.objperslab 53
servers.hostname.slabinfo.avc_node.objsize 72
servers.hostname.slabinfo.avc_node.pagesperslab 1
servers.hostname.slabinfo.avc_node.slabdata.active_slabs 2
servers.hostname.slabinfo.avc_node.slabdata.num_slabs 2
servers.hostname.slabinfo.avc_node.slabdata.sharedavail 0
servers.hostname.slabinfo.avc_node.tunables.batchcount 60
servers.hostname.slabinfo.avc_node.tunables.limit 120
servers.hostname.slabinfo.avc_node.tunables.sharedfactor 8
servers.hostname.slabinfo.bdev_cache.active_objs 22
servers.hostname.slabinfo.bdev_cache.num_objs 28
servers.hostname.slabinfo.bdev_cache.objperslab 4
servers.hostname.slabinfo.bdev_cache.objsize 832
servers.hostname.slabinfo.bdev_cache.pagesperslab 1
servers.hostname.slabinfo.bdev_cache.slabdata.active_slabs 7
servers.hostname.slabinfo.bdev_cache.slabdata.num_slabs 7
servers.hostname.slabinfo.bdev_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.bdev_cache.tunables.batchcount 27
servers.hostname.slabinfo.bdev_cache.tunables.limit 54
servers.hostname.slabinfo.bdev_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.bio.active_objs 824
servers.hostname.slabinfo.bio.num_objs 960
servers.hostname.slabinfo.bio.objperslab 30
servers.hostname.slabinfo.bio.objsize 128
servers.hostname.slabinfo.bio.pagesperslab 1
servers.hostname.slabinfo.bio.slabdata.active_slabs 32
servers.hostname.slabinfo.bio.slabdata.num_slabs 32
servers.hostname.slabinfo.bio.slabdata.sharedavail 411
servers.hostname.slabinfo.bio.tunables.batchcount 60
servers.hostname.slabinfo.bio.tunables.limit 120
servers.hostname.slabinfo.bio.tunables.sharedfactor 8
servers.hostname.slabinfo.bio_map_info.active_objs 100
servers.hostname.slabinfo.bio_map_info.num_objs 105
servers.hostname.slabinfo.bio_map_info.objperslab 7
servers.hostname.slabinfo.bio_map_info.objsize 1064
servers.hostname.slabinfo.bio_map_info.pagesperslab 2
servers.hostname.slabinfo.bio_map_info.slabdata.active_slabs 15
servers.hostname.slabinfo.bio_map_info.slabdata.num_slabs 15
servers.hostname.slabinfo.bio_map_info.slabdata.sharedavail 0
servers.hostname.slabinfo.bio_map_info.tunables.batchcount 12
servers.hostname.slabinfo.bio_map_info.tunables.limit 24
servers.hostname.slabinfo.bio_map_info.tunables.sharedfactor 8
servers.hostname.slabinfo.biovec-1.active_objs 598
servers.hostname.slabinfo.biovec-1.num_objs 808
servers.hostname.slabinfo.biovec-1.objperslab 202
servers.hostname.slabinfo.biovec-1.objsize 16
servers.hostname.slabinfo.biovec-1.pagesperslab 1
servers.hostname.slabinfo.biovec-1.slabdata.active_slabs 4
servers.hostname.slabinfo.biovec-1.slabdata.num_slabs 4
servers.hostname.slabinfo.biovec-1.slabdata.sharedavail 480
servers.hostname.slabinfo.biovec-1.tunables.batchcount 60
servers.hostname.slabinfo.biovec-1.tunables.limit 120
servers.hostname.slabinfo.biovec-1.tunables.sharedfactor 8
servers.hostname.slabinfo.biovec-128.active_objs 7
servers.hostname.slabinfo.biovec-128.num_objs 8
servers.hostname.slabinfo.biovec-128.objperslab 2
servers.hostname.slabinfo.biovec-128.objsize 2048
servers.hostname.slabinfo.biovec-128.pagesperslab 1
servers.hostname.slabinfo.biovec-128.slabdata.active_slabs 4
servers.hostname.slabinfo.biovec-128.slabdata.num_slabs 4
servers.hostname.slabinfo.biovec-128.slabdata.sharedavail 0
servers.hostname.slabinfo.biovec-128.tunables.batchcount 12
servers.hostname.slabinfo.biovec-128.tunables.limit 24
servers.hostname.slabinfo.biovec-128.tunables.sharedfactor 8
servers.hostname.slabinfo.biovec-16.active_objs 19
servers.hostname.slabinfo.biovec-16.num_objs 45
servers.hostname.slabinfo.biovec-16.objperslab 15
servers.hostname.slabinfo.biovec-16.objsize 256
servers.hostname.slabinfo.biovec-16.pagesperslab 1
servers.hostname.slabinfo.biovec-16.slabdata.active_slabs 3
servers.hostname.slabinfo.biovec-16.slabdata.num_slabs 3
servers.hostname.slabinfo.biovec-16.slabdata.sharedavail 0
servers.hostname.slabinfo.biovec-16.tunables.batchcount 60
servers.hostname.slabinfo.biovec-16.tunables.limit 120
servers.hostname.slabinfo.biovec-16.tunables.sharedfactor 8
servers.hostname.slabinfo.biovec-256.active_objs 7
servers.hostname.slabinfo.biovec-256.num_objs 7
servers.hostname.slabinfo.biovec-256.objperslab 1
servers.hostname.slabinfo.biovec-256.objsize 4096
servers.hostname.slabinfo.biovec-256.pagesperslab 1
servers.hostname.slabinfo.biovec-256.slabdata.active_slabs 7
servers.hostname.slabinfo.biovec-256.slabdata.num_slabs 7
servers.hostname.slabinfo.biovec-256.slabdata.sharedavail 0
servers.hostname.slabinfo.biovec-256.tunables.batchcount 12
servers.hostname.slabinfo.biovec-256.tunables.limit 24
servers.hostname.slabinfo.biovec-256.tunables.sharedfactor 8
servers.hostname.slabinfo.biovec-4.active_objs 151
servers.hostname.slabinfo.biovec-4.num_objs 236
servers.hostname.slabinfo.biovec-4.objperslab 59
servers.hostname.slabinfo.biovec-4.objsize 64
servers.hostname.slabinfo.biovec-4.pagesperslab 1
servers.hostname.slabinfo.biovec-4.slabdata.active_slabs 4
servers.hostname.slabinfo.biovec-4.slabdata.num_slabs 4
servers.hostname.slabinfo.biovec-4.slabdata.sharedavail 30
servers.hostname.slabinfo.biovec-4.tunables.batchcount 60
servers.hostname.slabinfo.biovec-4.tunables.limit 120
servers.hostname.slabinfo.biovec-4.tunables.sharedfactor 8
servers.hostname.slabinfo.biovec-64.active_objs 53
servers.hostname.slabinfo.biovec-64.num_objs 76
servers.hostname.slabinfo.biovec-64.objperslab 4
servers.hostname.slabinfo.biovec-64.objsize 1024
servers.hostname.slabinfo.biovec-64.pagesperslab 1
servers.hostname.slabinfo.biovec-64.slabdata.active_slabs 19
servers.hostname.slabinfo.biovec-64.slabdata.num_slabs 19
servers.hostname.slabinfo.biovec-64.slabdata.sharedavail 16
servers.hostname.slabinfo.biovec-64.tunables.batchcount 27
servers.hostname.slabinfo.biovec-64.tunables.limit 54
servers.hostname.slabinfo.biovec-64.tunables.sharedfactor 8
servers.hostname.slabinfo.blkdev_ioc.active_objs 57
servers.hostname.slabinfo.blkdev_ioc.num_objs 295
servers.hostname.slabinfo.blkdev_ioc.objperslab 59
servers.hostname.slabinfo.blkdev_ioc.objsize 64
servers.hostname.slabinfo.blkdev_ioc.pagesperslab 1
servers.hostname.slabinfo.blkdev_ioc.slabdata.active_slabs 5
servers.hostname.slabinfo.blkdev_ioc.slabdata.num_slabs 5
servers.hostname.slabinfo.blkdev_ioc.slabdata.sharedavail 0
servers.hostname.slabinfo.blkdev_ioc.tunables.batchcount 60
servers.hostname.slabinfo.blkdev_ioc.tunables.limit 120
servers.hostname.slabinfo.blkdev_ioc.tunables.sharedfactor 8
servers.hostname.slabinfo.blkdev_queue.active_objs 19
servers.hostname.slabinfo.blkdev_queue.num_objs 25
servers.hostname.slabinfo.blkdev_queue.objperslab 5
servers.hostname.slabinfo.blkdev_queue.objsize 1576
servers.hostname.slabinfo.blkdev_queue.pagesperslab 2
servers.hostname.slabinfo.blkdev_queue.slabdata.active_slabs 5
servers.hostname.slabinfo.blkdev_queue.slabdata.num_slabs 5
servers.hostname.slabinfo.blkdev_queue.slabdata.sharedavail 0
servers.hostname.slabinfo.blkdev_queue.tunables.batchcount 12
servers.hostname.slabinfo.blkdev_queue.tunables.limit 24
servers.hostname.slabinfo.blkdev_queue.tunables.sharedfactor 8
servers.hostname.slabinfo.blkdev_requests.active_objs 275
servers.hostname.slabinfo.blkdev_requests.num_objs 308
servers.hostname.slabinfo.blkdev_requests.objperslab 14
servers.hostname.slabinfo.blkdev_requests.objsize 272
servers.hostname.slabinfo.blkdev_requests.pagesperslab 1
servers.hostname.slabinfo.blkdev_requests.slabdata.active_slabs 22
servers.hostname.slabinfo.blkdev_requests.slabdata.num_slabs 22
servers.hostname.slabinfo.blkdev_requests.slabdata.sharedavail 206
servers.hostname.slabinfo.blkdev_requests.tunables.batchcount 27
servers.hostname.slabinfo.blkdev_requests.tunables.limit 54
servers.hostname.slabinfo.blkdev_requests.tunables.sharedfactor 8
servers.hostname.slabinfo.buffer_head.active_objs 840272
servers.hostname.slabinfo.buffer_head.num_objs 976760
servers.hostname.slabinfo.buffer_head.objperslab 40
servers.hostname.slabinfo.buffer_head.objsize 96
servers.hostname.slabinfo.buffer_head.pagesperslab 1
servers.hostname.slabinfo.buffer_head.slabdata.active_slabs 24419
servers.hostname.slabinfo.buffer_head.slabdata.num_slabs 24419
servers.hostname.slabinfo.buffer_head.slabdata.sharedavail 487
servers.hostname.slabinfo.buffer_head.tunables.batchcount 60
servers.hostname.slabinfo.buffer_head.tunables.limit 120
servers.hostname.slabinfo.buffer_head.tunables.sharedfactor 8
servers.hostname.slabinfo.cfq_ioc_pool.active_objs 56
servers.hostname.slabinfo.cfq_ioc_pool.num_objs 240
servers.hostname.slabinfo.cfq_ioc_pool.objperslab 30
servers.hostname.slabinfo.cfq_ioc_pool.objsize 128
servers.hostname.slabinfo.cfq_ioc_pool.pagesperslab 1
servers.hostname.slabinfo.cfq_ioc_pool.slabdata.active_slabs 8
servers.hostname.slabinfo.cfq_ioc_pool.slabdata.num_slabs 8
servers.hostname.slabinfo.cfq_ioc_pool.slabdata.sharedavail 0
servers.hostname.slabinfo.cfq_ioc_pool.tunables.batchcount 60
servers.hostname.slabinfo.cfq_ioc_pool.tunables.limit 120
servers.hostname.slabinfo.cfq_ioc_pool.tunables.sharedfactor 8
servers.hostname.slabinfo.cfq_pool.active_objs 38
servers.hostname.slabinfo.cfq_pool.num_objs 198
servers.hostname.slabinfo.cfq_pool.objperslab 18
servers.hostname.slabinfo.cfq_pool.objsize 216
servers.hostname.slabinfo.cfq_pool.pagesperslab 1
servers.hostname.slabinfo.cfq_pool.slabdata.active_slabs 11
servers.hostname.slabinfo.cfq_pool.slabdata.num_slabs 11
servers.hostname.slabinfo.cfq_pool.slabdata.sharedavail 0
servers.hostname.slabinfo.cfq_pool.tunables.batchcount 60
servers.hostname.slabinfo.cfq_pool.tunables.limit 120
servers.hostname.slabinfo.cfq_pool.tunables.sharedfactor 8
servers.hostname.slabinfo.crq_pool.active_objs 58
servers.hostname.slabinfo.crq_pool.num_objs 96
servers.hostname.slabinfo.crq_pool.objperslab 48
servers.hostname.slabinfo.crq_pool.objsize 80
servers.hostname.slabinfo.crq_pool.pagesperslab 1
servers.hostname.slabinfo.crq_pool.slabdata.active_slabs 2
servers.hostname.slabinfo.crq_pool.slabdata.num_slabs 2
servers.hostname.slabinfo.crq_pool.slabdata.sharedavail 10
servers.hostname.slabinfo.crq_pool.tunables.batchcount 60
servers.hostname.slabinfo.crq_pool.tunables.limit 120
servers.hostname.slabinfo.crq_pool.tunables.sharedfactor 8
servers.hostname.slabinfo.deadline_drq.active_objs 605
servers.hostname.slabinfo.deadline_drq.num_objs 672
servers.hostname.slabinfo.deadline_drq.objperslab 48
servers.hostname.slabinfo.deadline_drq.objsize 80
servers.hostname.slabinfo.deadline_drq.pagesperslab 1
servers.hostname.slabinfo.deadline_drq.slabdata.active_slabs 14
servers.hostname.slabinfo.deadline_drq.slabdata.num_slabs 14
servers.hostname.slabinfo.deadline_drq.slabdata.sharedavail 457
servers.hostname.slabinfo.deadline_drq.tunables.batchcount 60
servers.hostname.slabinfo.deadline_drq.tunables.limit 120
servers.hostname.slabinfo.deadline_drq.tunables.sharedfactor 8
servers.hostname.slabinfo.delayacct_cache.active_objs 1026
servers.hostname.slabinfo.delayacct_cache.num_objs 1534
servers.hostname.slabinfo.delayacct_cache.objperslab 59
servers.hostname.slabinfo.delayacct_cache.objsize 64
servers.hostname.slabinfo.delayacct_cache.pagesperslab 1
servers.hostname.slabinfo.delayacct_cache.slabdata.active_slabs 26
servers.hostname.slabinfo.delayacct_cache.slabdata.num_slabs 26
servers.hostname.slabinfo.delayacct_cache.slabdata.sharedavail 24
servers.hostname.slabinfo.delayacct_cache.tunables.batchcount 60
servers.hostname.slabinfo.delayacct_cache.tunables.limit 120
servers.hostname.slabinfo.delayacct_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.dentry_cache.active_objs 37161
servers.hostname.slabinfo.dentry_cache.num_objs 40626
servers.hostname.slabinfo.dentry_cache.objperslab 18
servers.hostname.slabinfo.dentry_cache.objsize 216
servers.hostname.slabinfo.dentry_cache.pagesperslab 1
servers.hostname.slabinfo.dentry_cache.slabdata.active_slabs 2257
servers.hostname.slabinfo.dentry_cache.slabdata.num_slabs 2257
servers.hostname.slabinfo.dentry_cache.slabdata.sharedavail 24
servers.hostname.slabinfo.dentry_cache.tunables.batchcount 60
servers.hostname.slabinfo.dentry_cache.tunables.limit 120
servers.hostname.slabinfo.dentry_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.dm_io.active_objs 0
servers.hostname.slabinfo.dm_io.num_objs 0
servers.hostname.slabinfo.dm_io.objperslab 92
servers.hostname.slabinfo.dm_io.objsize 40
servers.hostname.slabinfo.dm_io.pagesperslab 1
servers.hostname.slabinfo.dm_io.slabdata.active_slabs 0
servers.hostname.slabinfo.dm_io.slabdata.num_slabs 0
servers.hostname.slabinfo.dm_io.slabdata.sharedavail 0
servers.hostname.slabinfo.dm_io.tunables.batchcount 60
servers.hostname.slabinfo.dm_io.tunables.limit 120
servers.hostname.slabinfo.dm_io.tunables.sharedfactor 8
servers.hostname.slabinfo.dm_mpath.active_objs 0
servers.hostname.slabinfo.dm_mpath.num_objs 0
servers.hostname.slabinfo.dm_mpath.objperslab 7
servers.hostname.slabinfo.dm_mpath.objsize 1064
servers.hostname.slabinfo.dm_mpath.pagesperslab 2
servers.hostname.slabinfo.dm_mpath.slabdata.active_slabs 0
servers.hostname.slabinfo.dm_mpath.slabdata.num_slabs 0
servers.hostname.slabinfo.dm_mpath.slabdata.sharedavail 0
servers.hostname.slabinfo.dm_mpath.tunables.batchcount 12
servers.hostname.slabinfo.dm_mpath.tunables.limit 24
servers.hostname.slabinfo.dm_mpath.tunables.sharedfactor 8
servers.hostname.slabinfo.dm_tio.active_objs 0
servers.hostname.slabinfo.dm_tio.num_objs 0
servers.hostname.slabinfo.dm_tio.objperslab 144
servers.hostname.slabinfo.dm_tio.objsize 24
servers.hostname.slabinfo.dm_tio.pagesperslab 1
servers.hostname.slabinfo.dm_tio.slabdata.active_slabs 0
servers.hostname.slabinfo.dm_tio.slabdata.num_slabs 0
servers.hostname.slabinfo.dm_tio.slabdata.sharedavail 0
servers.hostname.slabinfo.dm_tio.tunables.batchcount 60
servers.hostname.slabinfo.dm_tio.tunables.limit 120
servers.hostname.slabinfo.dm_tio.tunables.sharedfactor 8
servers.hostname.slabinfo.dm_uevent.active_objs 0
servers.hostname.slabinfo.dm_uevent.num_objs 0
servers.hostname.slabinfo.dm_uevent.objperslab 3
servers.hostname.slabinfo.dm_uevent.objsize 2608
servers.hostname.slabinfo.dm_uevent.pagesperslab 2
servers.hostname.slabinfo.dm_uevent.slabdata.active_slabs 0
servers.hostname.slabinfo.dm_uevent.slabdata.num_slabs 0
servers.hostname.slabinfo.dm_uevent.slabdata.sharedavail 0
servers.hostname.slabinfo.dm_uevent.tunables.batchcount 12
servers.hostname.slabinfo.dm_uevent.tunables.limit 24
servers.hostname.slabinfo.dm_uevent.tunables.sharedfactor 8
servers.hostname.slabinfo.dnotify_cache.active_objs 0
servers.hostname.slabinfo.dnotify_cache.num_objs 0
servers.hostname.slabinfo.dnotify_cache.objperslab 92
servers.hostname.slabinfo.dnotify_cache.objsize 40
servers.hostname.slabinfo.dnotify_cache.pagesperslab 1
servers.hostname.slabinfo.dnotify_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.dnotify_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.dnotify_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.dnotify_cache.tunables.batchcount 60
servers.hostname.slabinfo.dnotify_cache.tunables.limit 120
servers.hostname.slabinfo.dnotify_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.dquot.active_objs 0
servers.hostname.slabinfo.dquot.num_objs 0
servers.hostname.slabinfo.dquot.objperslab 15
servers.hostname.slabinfo.dquot.objsize 256
servers.hostname.slabinfo.dquot.pagesperslab 1
servers.hostname.slabinfo.dquot.slabdata.active_slabs 0
servers.hostname.slabinfo.dquot.slabdata.num_slabs 0
servers.hostname.slabinfo.dquot.slabdata.sharedavail 0
servers.hostname.slabinfo.dquot.tunables.batchcount 60
servers.hostname.slabinfo.dquot.tunables.limit 120
servers.hostname.slabinfo.dquot.tunables.sharedfactor 8
servers.hostname.slabinfo.eventpoll_epi.active_objs 140
servers.hostname.slabinfo.eventpoll_epi.num_objs 140
servers.hostname.slabinfo.eventpoll_epi.objperslab 20
servers.hostname.slabinfo.eventpoll_epi.objsize 192
servers.hostname.slabinfo.eventpoll_epi.pagesperslab 1
servers.hostname.slabinfo.eventpoll_epi.slabdata.active_slabs 7
servers.hostname.slabinfo.eventpoll_epi.slabdata.num_slabs 7
servers.hostname.slabinfo.eventpoll_epi.slabdata.sharedavail 16
servers.hostname.slabinfo.eventpoll_epi.tunables.batchcount 60
servers.hostname.slabinfo.eventpoll_epi.tunables.limit 120
servers.hostname.slabinfo.eventpoll_epi.tunables.sharedfactor 8
servers.hostname.slabinfo.eventpoll_pwq.active_objs 191
servers.hostname.slabinfo.eventpoll_pwq.num_objs 212
servers.hostname.slabinfo.eventpoll_pwq.objperslab 53
servers.hostname.slabinfo.eventpoll_pwq.objsize 72
servers.hostname.slabinfo.eventpoll_pwq.pagesperslab 1
servers.hostname.slabinfo.eventpoll_pwq.slabdata.active_slabs 4
servers.hostname.slabinfo.eventpoll_pwq.slabdata.num_slabs 4
servers.hostname.slabinfo.eventpoll_pwq.slabdata.sharedavail 16
servers.hostname.slabinfo.eventpoll_pwq.tunables.batchcount 60
servers.hostname.slabinfo.eventpoll_pwq.tunables.limit 120
servers.hostname.slabinfo.eventpoll_pwq.tunables.sharedfactor 8
servers.hostname.slabinfo.ext2_inode_cache.active_objs 0
servers.hostname.slabinfo.ext2_inode_cache.num_objs 0
servers.hostname.slabinfo.ext2_inode_cache.objperslab 5
servers.hostname.slabinfo.ext2_inode_cache.objsize 720
servers.hostname.slabinfo.ext2_inode_cache.pagesperslab 1
servers.hostname.slabinfo.ext2_inode_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.ext2_inode_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.ext2_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.ext2_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.ext2_inode_cache.tunables.limit 54
servers.hostname.slabinfo.ext2_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.ext2_xattr.active_objs 0
servers.hostname.slabinfo.ext2_xattr.num_objs 0
servers.hostname.slabinfo.ext2_xattr.objperslab 44
servers.hostname.slabinfo.ext2_xattr.objsize 88
servers.hostname.slabinfo.ext2_xattr.pagesperslab 1
servers.hostname.slabinfo.ext2_xattr.slabdata.active_slabs 0
servers.hostname.slabinfo.ext2_xattr.slabdata.num_slabs 0
servers.hostname.slabinfo.ext2_xattr.slabdata.sharedavail 0
servers.hostname.slabinfo.ext2_xattr.tunables.batchcount 60
servers.hostname.slabinfo.ext2_xattr.tunables.limit 120
servers.hostname.slabinfo.ext2_xattr.tunables.sharedfactor 8
servers.hostname.slabinfo.ext3_inode_cache.active_objs 20908
servers.hostname.slabinfo.ext3_inode_cache.num_objs 21160
servers.hostname.slabinfo.ext3_inode_cache.objperslab 5
servers.hostname.slabinfo.ext3_inode_cache.objsize 760
servers.hostname.slabinfo.ext3_inode_cache.pagesperslab 1
servers.hostname.slabinfo.ext3_inode_cache.slabdata.active_slabs 4232
servers.hostname.slabinfo.ext3_inode_cache.slabdata.num_slabs 4232
servers.hostname.slabinfo.ext3_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.ext3_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.ext3_inode_cache.tunables.limit 54
servers.hostname.slabinfo.ext3_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.ext3_xattr.active_objs 98
servers.hostname.slabinfo.ext3_xattr.num_objs 132
servers.hostname.slabinfo.ext3_xattr.objperslab 44
servers.hostname.slabinfo.ext3_xattr.objsize 88
servers.hostname.slabinfo.ext3_xattr.pagesperslab 1
servers.hostname.slabinfo.ext3_xattr.slabdata.active_slabs 3
servers.hostname.slabinfo.ext3_xattr.slabdata.num_slabs 3
servers.hostname.slabinfo.ext3_xattr.slabdata.sharedavail 0
servers.hostname.slabinfo.ext3_xattr.tunables.batchcount 60
servers.hostname.slabinfo.ext3_xattr.tunables.limit 120
servers.hostname.slabinfo.ext3_xattr.tunables.sharedfactor 8
servers.hostname.slabinfo.ext4_alloc_context.active_objs 2
servers.hostname.slabinfo.ext4_alloc_context.num_objs 27
servers.hostname.slabinfo.ext4_alloc_context.objperslab 27
servers.hostname.slabinfo.ext4_alloc_context.objsize 144
servers.hostname.slabinfo.ext4_alloc_context.pagesperslab 1
servers.hostname.slabinfo.ext4_alloc_context.slabdata.active_slabs 1
servers.hostname.slabinfo.ext4_alloc_context.slabdata.num_slabs 1
servers.hostname.slabinfo.ext4_alloc_context.slabdata.sharedavail 0
servers.hostname.slabinfo.ext4_alloc_context.tunables.batchcount 60
servers.hostname.slabinfo.ext4_alloc_context.tunables.limit 120
servers.hostname.slabinfo.ext4_alloc_context.tunables.sharedfactor 8
servers.hostname.slabinfo.ext4_free_block_extents.active_objs 0
servers.hostname.slabinfo.ext4_free_block_extents.num_objs 0
servers.hostname.slabinfo.ext4_free_block_extents.objperslab 67
servers.hostname.slabinfo.ext4_free_block_extents.objsize 56
servers.hostname.slabinfo.ext4_free_block_extents.pagesperslab 1
servers.hostname.slabinfo.ext4_free_block_extents.slabdata.active_slabs 0
servers.hostname.slabinfo.ext4_free_block_extents.slabdata.num_slabs 0
servers.hostname.slabinfo.ext4_free_block_extents.slabdata.sharedavail 0
servers.hostname.slabinfo.ext4_free_block_extents.tunables.batchcount 60
servers.hostname.slabinfo.ext4_free_block_extents.tunables.limit 120
servers.hostname.slabinfo.ext4_free_block_extents.tunables.sharedfactor 8
servers.hostname.slabinfo.ext4_inode_cache.active_objs 3816
servers.hostname.slabinfo.ext4_inode_cache.num_objs 4148
servers.hostname.slabinfo.ext4_inode_cache.objperslab 4
servers.hostname.slabinfo.ext4_inode_cache.objsize 944
servers.hostname.slabinfo.ext4_inode_cache.pagesperslab 1
servers.hostname.slabinfo.ext4_inode_cache.slabdata.active_slabs 1037
servers.hostname.slabinfo.ext4_inode_cache.slabdata.num_slabs 1037
servers.hostname.slabinfo.ext4_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.ext4_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.ext4_inode_cache.tunables.limit 54
servers.hostname.slabinfo.ext4_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.ext4_prealloc_space.active_objs 73
servers.hostname.slabinfo.ext4_prealloc_space.num_objs 518
servers.hostname.slabinfo.ext4_prealloc_space.objperslab 37
servers.hostname.slabinfo.ext4_prealloc_space.objsize 104
servers.hostname.slabinfo.ext4_prealloc_space.pagesperslab 1
servers.hostname.slabinfo.ext4_prealloc_space.slabdata.active_slabs 14
servers.hostname.slabinfo.ext4_prealloc_space.slabdata.num_slabs 14
servers.hostname.slabinfo.ext4_prealloc_space.slabdata.sharedavail 0
servers.hostname.slabinfo.ext4_prealloc_space.tunables.batchcount 60
servers.hostname.slabinfo.ext4_prealloc_space.tunables.limit 120
servers.hostname.slabinfo.ext4_prealloc_space.tunables.sharedfactor 8
servers.hostname.slabinfo.ext4_system_zone.active_objs 0
servers.hostname.slabinfo.ext4_system_zone.num_objs 0
servers.hostname.slabinfo.ext4_system_zone.objperslab 92
servers.hostname.slabinfo.ext4_system_zone.objsize 40
servers.hostname.slabinfo.ext4_system_zone.pagesperslab 1
servers.hostname.slabinfo.ext4_system_zone.slabdata.active_slabs 0
servers.hostname.slabinfo.ext4_system_zone.slabdata.num_slabs 0
servers.hostname.slabinfo.ext4_system_zone.slabdata.sharedavail 0
servers.hostname.slabinfo.ext4_system_zone.tunables.batchcount 60
servers.hostname.slabinfo.ext4_system_zone.tunables.limit 120
servers.hostname.slabinfo.ext4_system_zone.tunables.sharedfactor 8
servers.hostname.slabinfo.ext4_xattr.active_objs 0
servers.hostname.slabinfo.ext4_xattr.num_objs 0
servers.hostname.slabinfo.ext4_xattr.objperslab 44
servers.hostname.slabinfo.ext4_xattr.objsize 88
servers.hostname.slabinfo.ext4_xattr.pagesperslab 1
servers.hostname.slabinfo.ext4_xattr.slabdata.active_slabs 0
servers.hostname.slabinfo.ext4_xattr.slabdata.num_slabs 0
servers.hostname.slabinfo.ext4_xattr.slabdata.sharedavail 0
servers.hostname.slabinfo.ext4_xattr.tunables.batchcount 60
servers.hostname.slabinfo.ext4_xattr.tunables.limit 120
servers.hostname.slabinfo.ext4_xattr.tunables.sharedfactor 8
servers.hostname.slabinfo.fasync_cache.active_objs 0
servers.hostname.slabinfo.fasync_cache.num_objs 0
servers.hostname.slabinfo.fasync_cache.objperslab 144
servers.hostname.slabinfo.fasync_cache.objsize 24
servers.hostname.slabinfo.fasync_cache.pagesperslab 1
servers.hostname.slabinfo.fasync_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.fasync_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.fasync_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.fasync_cache.tunables.batchcount 60
servers.hostname.slabinfo.fasync_cache.tunables.limit 120
servers.hostname.slabinfo.fasync_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.fib6_nodes.active_objs 22
servers.hostname.slabinfo.fib6_nodes.num_objs 118
servers.hostname.slabinfo.fib6_nodes.objperslab 59
servers.hostname.slabinfo.fib6_nodes.objsize 64
servers.hostname.slabinfo.fib6_nodes.pagesperslab 1
servers.hostname.slabinfo.fib6_nodes.slabdata.active_slabs 2
servers.hostname.slabinfo.fib6_nodes.slabdata.num_slabs 2
servers.hostname.slabinfo.fib6_nodes.slabdata.sharedavail 0
servers.hostname.slabinfo.fib6_nodes.tunables.batchcount 60
servers.hostname.slabinfo.fib6_nodes.tunables.limit 120
servers.hostname.slabinfo.fib6_nodes.tunables.sharedfactor 8
servers.hostname.slabinfo.file_lock_cache.active_objs 254
servers.hostname.slabinfo.file_lock_cache.num_objs 286
servers.hostname.slabinfo.file_lock_cache.objperslab 22
servers.hostname.slabinfo.file_lock_cache.objsize 176
servers.hostname.slabinfo.file_lock_cache.pagesperslab 1
servers.hostname.slabinfo.file_lock_cache.slabdata.active_slabs 13
servers.hostname.slabinfo.file_lock_cache.slabdata.num_slabs 13
servers.hostname.slabinfo.file_lock_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.file_lock_cache.tunables.batchcount 60
servers.hostname.slabinfo.file_lock_cache.tunables.limit 120
servers.hostname.slabinfo.file_lock_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.files_cache.active_objs 253
servers.hostname.slabinfo.files_cache.num_objs 265
servers.hostname.slabinfo.files_cache.objperslab 5
servers.hostname.slabinfo.files_cache.objsize 768
servers.hostname.slabinfo.files_cache.pagesperslab 1
servers.hostname.slabinfo.files_cache.slabdata.active_slabs 53
servers.hostname.slabinfo.files_cache.slabdata.num_slabs 53
servers.hostname.slabinfo.files_cache.slabdata.sharedavail 20
servers.hostname.slabinfo.files_cache.tunables.batchcount 27
servers.hostname.slabinfo.files_cache.tunables.limit 54
servers.hostname.slabinfo.files_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.filp.active_objs 1833
servers.hostname.slabinfo.filp.num_objs 2325
servers.hostname.slabinfo.filp.objperslab 15
servers.hostname.slabinfo.filp.objsize 256
servers.hostname.slabinfo.filp.pagesperslab 1
servers.hostname.slabinfo.filp.slabdata.active_slabs 155
servers.hostname.slabinfo.filp.slabdata.num_slabs 155
servers.hostname.slabinfo.filp.slabdata.sharedavail 28
servers.hostname.slabinfo.filp.tunables.batchcount 60
servers.hostname.slabinfo.filp.tunables.limit 120
servers.hostname.slabinfo.filp.tunables.sharedfactor 8
servers.hostname.slabinfo.flow_cache.active_objs 0
servers.hostname.slabinfo.flow_cache.num_objs 0
servers.hostname.slabinfo.flow_cache.objperslab 30
servers.hostname.slabinfo.flow_cache.objsize 128
servers.hostname.slabinfo.flow_cache.pagesperslab 1
servers.hostname.slabinfo.flow_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.flow_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.flow_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.flow_cache.tunables.batchcount 60
servers.hostname.slabinfo.flow_cache.tunables.limit 120
servers.hostname.slabinfo.flow_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.fs_cache.active_objs 453
servers.hostname.slabinfo.fs_cache.num_objs 649
servers.hostname.slabinfo.fs_cache.objperslab 59
servers.hostname.slabinfo.fs_cache.objsize 64
servers.hostname.slabinfo.fs_cache.pagesperslab 1
servers.hostname.slabinfo.fs_cache.slabdata.active_slabs 11
servers.hostname.slabinfo.fs_cache.slabdata.num_slabs 11
servers.hostname.slabinfo.fs_cache.slabdata.sharedavail 20
servers.hostname.slabinfo.fs_cache.tunables.batchcount 60
servers.hostname.slabinfo.fs_cache.tunables.limit 120
servers.hostname.slabinfo.fs_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.hugetlbfs_inode_cache.active_objs 1
servers.hostname.slabinfo.hugetlbfs_inode_cache.num_objs 7
servers.hostname.slabinfo.hugetlbfs_inode_cache.objperslab 7
servers.hostname.slabinfo.hugetlbfs_inode_cache.objsize 576
servers.hostname.slabinfo.hugetlbfs_inode_cache.pagesperslab 1
servers.hostname.slabinfo.hugetlbfs_inode_cache.slabdata.active_slabs 1
servers.hostname.slabinfo.hugetlbfs_inode_cache.slabdata.num_slabs 1
servers.hostname.slabinfo.hugetlbfs_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.hugetlbfs_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.hugetlbfs_inode_cache.tunables.limit 54
servers.hostname.slabinfo.hugetlbfs_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.idr_layer_cache.active_objs 94
servers.hostname.slabinfo.idr_layer_cache.num_objs 105
servers.hostname.slabinfo.idr_layer_cache.objperslab 7
servers.hostname.slabinfo.idr_layer_cache.objsize 528
servers.hostname.slabinfo.idr_layer_cache.pagesperslab 1
servers.hostname.slabinfo.idr_layer_cache.slabdata.active_slabs 15
servers.hostname.slabinfo.idr_layer_cache.slabdata.num_slabs 15
servers.hostname.slabinfo.idr_layer_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.idr_layer_cache.tunables.batchcount 27
servers.hostname.slabinfo.idr_layer_cache.tunables.limit 54
servers.hostname.slabinfo.idr_layer_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.inet_peer_cache.active_objs 4
servers.hostname.slabinfo.inet_peer_cache.num_objs 60
servers.hostname.slabinfo.inet_peer_cache.objperslab 30
servers.hostname.slabinfo.inet_peer_cache.objsize 128
servers.hostname.slabinfo.inet_peer_cache.pagesperslab 1
servers.hostname.slabinfo.inet_peer_cache.slabdata.active_slabs 2
servers.hostname.slabinfo.inet_peer_cache.slabdata.num_slabs 2
servers.hostname.slabinfo.inet_peer_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.inet_peer_cache.tunables.batchcount 60
servers.hostname.slabinfo.inet_peer_cache.tunables.limit 120
servers.hostname.slabinfo.inet_peer_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.inode_cache.active_objs 2138
servers.hostname.slabinfo.inode_cache.num_objs 2142
servers.hostname.slabinfo.inode_cache.objperslab 7
servers.hostname.slabinfo.inode_cache.objsize 560
servers.hostname.slabinfo.inode_cache.pagesperslab 1
servers.hostname.slabinfo.inode_cache.slabdata.active_slabs 306
servers.hostname.slabinfo.inode_cache.slabdata.num_slabs 306
servers.hostname.slabinfo.inode_cache.slabdata.sharedavail 20
servers.hostname.slabinfo.inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.inode_cache.tunables.limit 54
servers.hostname.slabinfo.inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.inotify_event_cache.active_objs 0
servers.hostname.slabinfo.inotify_event_cache.num_objs 0
servers.hostname.slabinfo.inotify_event_cache.objperslab 92
servers.hostname.slabinfo.inotify_event_cache.objsize 40
servers.hostname.slabinfo.inotify_event_cache.pagesperslab 1
servers.hostname.slabinfo.inotify_event_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.inotify_event_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.inotify_event_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.inotify_event_cache.tunables.batchcount 60
servers.hostname.slabinfo.inotify_event_cache.tunables.limit 120
servers.hostname.slabinfo.inotify_event_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.inotify_watch_cache.active_objs 1
servers.hostname.slabinfo.inotify_watch_cache.num_objs 53
servers.hostname.slabinfo.inotify_watch_cache.objperslab 53
servers.hostname.slabinfo.inotify_watch_cache.objsize 72
servers.hostname.slabinfo.inotify_watch_cache.pagesperslab 1
servers.hostname.slabinfo.inotify_watch_cache.slabdata.active_slabs 1
servers.hostname.slabinfo.inotify_watch_cache.slabdata.num_slabs 1
servers.hostname.slabinfo.inotify_watch_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.inotify_watch_cache.tunables.batchcount 60
servers.hostname.slabinfo.inotify_watch_cache.tunables.limit 120
servers.hostname.slabinfo.inotify_watch_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.ip6_dst_cache.active_objs 13
servers.hostname.slabinfo.ip6_dst_cache.num_objs 72
servers.hostname.slabinfo.ip6_dst_cache.objperslab 12
servers.hostname.slabinfo.ip6_dst_cache.objsize 320
servers.hostname.slabinfo.ip6_dst_cache.pagesperslab 1
servers.hostname.slabinfo.ip6_dst_cache.slabdata.active_slabs 6
servers.hostname.slabinfo.ip6_dst_cache.slabdata.num_slabs 6
servers.hostname.slabinfo.ip6_dst_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.ip6_dst_cache.tunables.batchcount 27
servers.hostname.slabinfo.ip6_dst_cache.tunables.limit 54
servers.hostname.slabinfo.ip6_dst_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.ip_dst_cache.active_objs 43
servers.hostname.slabinfo.ip_dst_cache.num_objs 90
servers.hostname.slabinfo.ip_dst_cache.objperslab 10
servers.hostname.slabinfo.ip_dst_cache.objsize 384
servers.hostname.slabinfo.ip_dst_cache.pagesperslab 1
servers.hostname.slabinfo.ip_dst_cache.slabdata.active_slabs 9
servers.hostname.slabinfo.ip_dst_cache.slabdata.num_slabs 9
servers.hostname.slabinfo.ip_dst_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.ip_dst_cache.tunables.batchcount 27
servers.hostname.slabinfo.ip_dst_cache.tunables.limit 54
servers.hostname.slabinfo.ip_dst_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.ip_fib_alias.active_objs 10
servers.hostname.slabinfo.ip_fib_alias.num_objs 118
servers.hostname.slabinfo.ip_fib_alias.objperslab 59
servers.hostname.slabinfo.ip_fib_alias.objsize 64
servers.hostname.slabinfo.ip_fib_alias.pagesperslab 1
servers.hostname.slabinfo.ip_fib_alias.slabdata.active_slabs 2
servers.hostname.slabinfo.ip_fib_alias.slabdata.num_slabs 2
servers.hostname.slabinfo.ip_fib_alias.slabdata.sharedavail 0
servers.hostname.slabinfo.ip_fib_alias.tunables.batchcount 60
servers.hostname.slabinfo.ip_fib_alias.tunables.limit 120
servers.hostname.slabinfo.ip_fib_alias.tunables.sharedfactor 8
servers.hostname.slabinfo.ip_fib_hash.active_objs 10
servers.hostname.slabinfo.ip_fib_hash.num_objs 118
servers.hostname.slabinfo.ip_fib_hash.objperslab 59
servers.hostname.slabinfo.ip_fib_hash.objsize 64
servers.hostname.slabinfo.ip_fib_hash.pagesperslab 1
servers.hostname.slabinfo.ip_fib_hash.slabdata.active_slabs 2
servers.hostname.slabinfo.ip_fib_hash.slabdata.num_slabs 2
servers.hostname.slabinfo.ip_fib_hash.slabdata.sharedavail 0
servers.hostname.slabinfo.ip_fib_hash.tunables.batchcount 60
servers.hostname.slabinfo.ip_fib_hash.tunables.limit 120
servers.hostname.slabinfo.ip_fib_hash.tunables.sharedfactor 8
servers.hostname.slabinfo.ip_mrt_cache.active_objs 0
servers.hostname.slabinfo.ip_mrt_cache.num_objs 0
servers.hostname.slabinfo.ip_mrt_cache.objperslab 30
servers.hostname.slabinfo.ip_mrt_cache.objsize 128
servers.hostname.slabinfo.ip_mrt_cache.pagesperslab 1
servers.hostname.slabinfo.ip_mrt_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.ip_mrt_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.ip_mrt_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.ip_mrt_cache.tunables.batchcount 60
servers.hostname.slabinfo.ip_mrt_cache.tunables.limit 120
servers.hostname.slabinfo.ip_mrt_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.isofs_inode_cache.active_objs 0
servers.hostname.slabinfo.isofs_inode_cache.num_objs 0
servers.hostname.slabinfo.isofs_inode_cache.objperslab 6
servers.hostname.slabinfo.isofs_inode_cache.objsize 608
servers.hostname.slabinfo.isofs_inode_cache.pagesperslab 1
servers.hostname.slabinfo.isofs_inode_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.isofs_inode_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.isofs_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.isofs_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.isofs_inode_cache.tunables.limit 54
servers.hostname.slabinfo.isofs_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.jbd2_journal_handle.active_objs 64
servers.hostname.slabinfo.jbd2_journal_handle.num_objs 144
servers.hostname.slabinfo.jbd2_journal_handle.objperslab 144
servers.hostname.slabinfo.jbd2_journal_handle.objsize 24
servers.hostname.slabinfo.jbd2_journal_handle.pagesperslab 1
servers.hostname.slabinfo.jbd2_journal_handle.slabdata.active_slabs 1
servers.hostname.slabinfo.jbd2_journal_handle.slabdata.num_slabs 1
servers.hostname.slabinfo.jbd2_journal_handle.slabdata.sharedavail 0
servers.hostname.slabinfo.jbd2_journal_handle.tunables.batchcount 60
servers.hostname.slabinfo.jbd2_journal_handle.tunables.limit 120
servers.hostname.slabinfo.jbd2_journal_handle.tunables.sharedfactor 8
servers.hostname.slabinfo.jbd2_journal_head.active_objs 495
servers.hostname.slabinfo.jbd2_journal_head.num_objs 600
servers.hostname.slabinfo.jbd2_journal_head.objperslab 40
servers.hostname.slabinfo.jbd2_journal_head.objsize 96
servers.hostname.slabinfo.jbd2_journal_head.pagesperslab 1
servers.hostname.slabinfo.jbd2_journal_head.slabdata.active_slabs 15
servers.hostname.slabinfo.jbd2_journal_head.slabdata.num_slabs 15
servers.hostname.slabinfo.jbd2_journal_head.slabdata.sharedavail 468
servers.hostname.slabinfo.jbd2_journal_head.tunables.batchcount 60
servers.hostname.slabinfo.jbd2_journal_head.tunables.limit 120
servers.hostname.slabinfo.jbd2_journal_head.tunables.sharedfactor 8
servers.hostname.slabinfo.jbd2_revoke_record.active_objs 0
servers.hostname.slabinfo.jbd2_revoke_record.num_objs 0
servers.hostname.slabinfo.jbd2_revoke_record.objperslab 112
servers.hostname.slabinfo.jbd2_revoke_record.objsize 32
servers.hostname.slabinfo.jbd2_revoke_record.pagesperslab 1
servers.hostname.slabinfo.jbd2_revoke_record.slabdata.active_slabs 0
servers.hostname.slabinfo.jbd2_revoke_record.slabdata.num_slabs 0
servers.hostname.slabinfo.jbd2_revoke_record.slabdata.sharedavail 0
servers.hostname.slabinfo.jbd2_revoke_record.tunables.batchcount 60
servers.hostname.slabinfo.jbd2_revoke_record.tunables.limit 120
servers.hostname.slabinfo.jbd2_revoke_record.tunables.sharedfactor 8
servers.hostname.slabinfo.jbd2_revoke_table.active_objs 2
servers.hostname.slabinfo.jbd2_revoke_table.num_objs 202
servers.hostname.slabinfo.jbd2_revoke_table.objperslab 202
servers.hostname.slabinfo.jbd2_revoke_table.objsize 16
servers.hostname.slabinfo.jbd2_revoke_table.pagesperslab 1
servers.hostname.slabinfo.jbd2_revoke_table.slabdata.active_slabs 1
servers.hostname.slabinfo.jbd2_revoke_table.slabdata.num_slabs 1
servers.hostname.slabinfo.jbd2_revoke_table.slabdata.sharedavail 0
servers.hostname.slabinfo.jbd2_revoke_table.tunables.batchcount 60
servers.hostname.slabinfo.jbd2_revoke_table.tunables.limit 120
servers.hostname.slabinfo.jbd2_revoke_table.tunables.sharedfactor 8
servers.hostname.slabinfo.jbd_4k.active_objs 0
servers.hostname.slabinfo.jbd_4k.num_objs 1
servers.hostname.slabinfo.jbd_4k.objperslab 1
servers.hostname.slabinfo.jbd_4k.objsize 4096
servers.hostname.slabinfo.jbd_4k.pagesperslab 1
servers.hostname.slabinfo.jbd_4k.slabdata.active_slabs 0
servers.hostname.slabinfo.jbd_4k.slabdata.num_slabs 1
servers.hostname.slabinfo.jbd_4k.slabdata.sharedavail 0
servers.hostname.slabinfo.jbd_4k.tunables.batchcount 12
servers.hostname.slabinfo.jbd_4k.tunables.limit 24
servers.hostname.slabinfo.jbd_4k.tunables.sharedfactor 8
servers.hostname.slabinfo.journal_handle.active_objs 224
servers.hostname.slabinfo.journal_handle.num_objs 288
servers.hostname.slabinfo.journal_handle.objperslab 144
servers.hostname.slabinfo.journal_handle.objsize 24
servers.hostname.slabinfo.journal_handle.pagesperslab 1
servers.hostname.slabinfo.journal_handle.slabdata.active_slabs 2
servers.hostname.slabinfo.journal_handle.slabdata.num_slabs 2
servers.hostname.slabinfo.journal_handle.slabdata.sharedavail 0
servers.hostname.slabinfo.journal_handle.tunables.batchcount 60
servers.hostname.slabinfo.journal_handle.tunables.limit 120
servers.hostname.slabinfo.journal_handle.tunables.sharedfactor 8
servers.hostname.slabinfo.journal_head.active_objs 304
servers.hostname.slabinfo.journal_head.num_objs 320
servers.hostname.slabinfo.journal_head.objperslab 40
servers.hostname.slabinfo.journal_head.objsize 96
servers.hostname.slabinfo.journal_head.pagesperslab 1
servers.hostname.slabinfo.journal_head.slabdata.active_slabs 8
servers.hostname.slabinfo.journal_head.slabdata.num_slabs 8
servers.hostname.slabinfo.journal_head.slabdata.sharedavail 47
servers.hostname.slabinfo.journal_head.tunables.batchcount 60
servers.hostname.slabinfo.journal_head.tunables.limit 120
servers.hostname.slabinfo.journal_head.tunables.sharedfactor 8
servers.hostname.slabinfo.key_jar.active_objs 63
servers.hostname.slabinfo.key_jar.num_objs 100
servers.hostname.slabinfo.key_jar.objperslab 20
servers.hostname.slabinfo.key_jar.objsize 192
servers.hostname.slabinfo.key_jar.pagesperslab 1
servers.hostname.slabinfo.key_jar.slabdata.active_slabs 5
servers.hostname.slabinfo.key_jar.slabdata.num_slabs 5
servers.hostname.slabinfo.key_jar.slabdata.sharedavail 2
servers.hostname.slabinfo.key_jar.tunables.batchcount 60
servers.hostname.slabinfo.key_jar.tunables.limit 120
servers.hostname.slabinfo.key_jar.tunables.sharedfactor 8
servers.hostname.slabinfo.kiocb.active_objs 0
servers.hostname.slabinfo.kiocb.num_objs 0
servers.hostname.slabinfo.kiocb.objperslab 15
servers.hostname.slabinfo.kiocb.objsize 256
servers.hostname.slabinfo.kiocb.pagesperslab 1
servers.hostname.slabinfo.kiocb.slabdata.active_slabs 0
servers.hostname.slabinfo.kiocb.slabdata.num_slabs 0
servers.hostname.slabinfo.kiocb.slabdata.sharedavail 0
servers.hostname.slabinfo.kiocb.tunables.batchcount 60
servers.hostname.slabinfo.kiocb.tunables.limit 120
servers.hostname.slabinfo.kiocb.tunables.sharedfactor 8
servers.hostname.slabinfo.kioctx.active_objs 0
servers.hostname.slabinfo.kioctx.num_objs 0
servers.hostname.slabinfo.kioctx.objperslab 12
servers.hostname.slabinfo.kioctx.objsize 320
servers.hostname.slabinfo.kioctx.pagesperslab 1
servers.hostname.slabinfo.kioctx.slabdata.active_slabs 0
servers.hostname.slabinfo.kioctx.slabdata.num_slabs 0
servers.hostname.slabinfo.kioctx.slabdata.sharedavail 0
servers.hostname.slabinfo.kioctx.tunables.batchcount 27
servers.hostname.slabinfo.kioctx.tunables.limit 54
servers.hostname.slabinfo.kioctx.tunables.sharedfactor 8
servers.hostname.slabinfo.kmem_cache.active_objs 155
servers.hostname.slabinfo.kmem_cache.num_objs 155
servers.hostname.slabinfo.kmem_cache.objperslab 1
servers.hostname.slabinfo.kmem_cache.objsize 2688
servers.hostname.slabinfo.kmem_cache.pagesperslab 1
servers.hostname.slabinfo.kmem_cache.slabdata.active_slabs 155
servers.hostname.slabinfo.kmem_cache.slabdata.num_slabs 155
servers.hostname.slabinfo.kmem_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.kmem_cache.tunables.batchcount 12
servers.hostname.slabinfo.kmem_cache.tunables.limit 24
servers.hostname.slabinfo.kmem_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.mm_struct.active_objs 238
servers.hostname.slabinfo.mm_struct.num_objs 240
servers.hostname.slabinfo.mm_struct.objperslab 4
servers.hostname.slabinfo.mm_struct.objsize 896
servers.hostname.slabinfo.mm_struct.pagesperslab 1
servers.hostname.slabinfo.mm_struct.slabdata.active_slabs 60
servers.hostname.slabinfo.mm_struct.slabdata.num_slabs 60
servers.hostname.slabinfo.mm_struct.slabdata.sharedavail 22
servers.hostname.slabinfo.mm_struct.tunables.batchcount 27
servers.hostname.slabinfo.mm_struct.tunables.limit 54
servers.hostname.slabinfo.mm_struct.tunables.sharedfactor 8
servers.hostname.slabinfo.mnt_cache.active_objs 28
servers.hostname.slabinfo.mnt_cache.num_objs 75
servers.hostname.slabinfo.mnt_cache.objperslab 15
servers.hostname.slabinfo.mnt_cache.objsize 256
servers.hostname.slabinfo.mnt_cache.pagesperslab 1
servers.hostname.slabinfo.mnt_cache.slabdata.active_slabs 5
servers.hostname.slabinfo.mnt_cache.slabdata.num_slabs 5
servers.hostname.slabinfo.mnt_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.mnt_cache.tunables.batchcount 60
servers.hostname.slabinfo.mnt_cache.tunables.limit 120
servers.hostname.slabinfo.mnt_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.mqueue_inode_cache.active_objs 1
servers.hostname.slabinfo.mqueue_inode_cache.num_objs 4
servers.hostname.slabinfo.mqueue_inode_cache.objperslab 4
servers.hostname.slabinfo.mqueue_inode_cache.objsize 896
servers.hostname.slabinfo.mqueue_inode_cache.pagesperslab 1
servers.hostname.slabinfo.mqueue_inode_cache.slabdata.active_slabs 1
servers.hostname.slabinfo.mqueue_inode_cache.slabdata.num_slabs 1
servers.hostname.slabinfo.mqueue_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.mqueue_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.mqueue_inode_cache.tunables.limit 54
servers.hostname.slabinfo.mqueue_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.msi_cache.active_objs 26
servers.hostname.slabinfo.msi_cache.num_objs 118
servers.hostname.slabinfo.msi_cache.objperslab 59
servers.hostname.slabinfo.msi_cache.objsize 64
servers.hostname.slabinfo.msi_cache.pagesperslab 1
servers.hostname.slabinfo.msi_cache.slabdata.active_slabs 2
servers.hostname.slabinfo.msi_cache.slabdata.num_slabs 2
servers.hostname.slabinfo.msi_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.msi_cache.tunables.batchcount 60
servers.hostname.slabinfo.msi_cache.tunables.limit 120
servers.hostname.slabinfo.msi_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.names_cache.active_objs 137
servers.hostname.slabinfo.names_cache.num_objs 137
servers.hostname.slabinfo.names_cache.objperslab 1
servers.hostname.slabinfo.names_cache.objsize 4096
servers.hostname.slabinfo.names_cache.pagesperslab 1
servers.hostname.slabinfo.names_cache.slabdata.active_slabs 137
servers.hostname.slabinfo.names_cache.slabdata.num_slabs 137
servers.hostname.slabinfo.names_cache.slabdata.sharedavail 14
servers.hostname.slabinfo.names_cache.tunables.batchcount 12
servers.hostname.slabinfo.names_cache.tunables.limit 24
servers.hostname.slabinfo.names_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.ndisc_cache.active_objs 2
servers.hostname.slabinfo.ndisc_cache.num_objs 15
servers.hostname.slabinfo.ndisc_cache.objperslab 15
servers.hostname.slabinfo.ndisc_cache.objsize 256
servers.hostname.slabinfo.ndisc_cache.pagesperslab 1
servers.hostname.slabinfo.ndisc_cache.slabdata.active_slabs 1
servers.hostname.slabinfo.ndisc_cache.slabdata.num_slabs 1
servers.hostname.slabinfo.ndisc_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.ndisc_cache.tunables.batchcount 60
servers.hostname.slabinfo.ndisc_cache.tunables.limit 120
servers.hostname.slabinfo.ndisc_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.numa_policy.active_objs 314
servers.hostname.slabinfo.numa_policy.num_objs 864
servers.hostname.slabinfo.numa_policy.objperslab 144
servers.hostname.slabinfo.numa_policy.objsize 24
servers.hostname.slabinfo.numa_policy.pagesperslab 1
servers.hostname.slabinfo.numa_policy.slabdata.active_slabs 6
servers.hostname.slabinfo.numa_policy.slabdata.num_slabs 6
servers.hostname.slabinfo.numa_policy.slabdata.sharedavail 0
servers.hostname.slabinfo.numa_policy.tunables.batchcount 60
servers.hostname.slabinfo.numa_policy.tunables.limit 120
servers.hostname.slabinfo.numa_policy.tunables.sharedfactor 8
servers.hostname.slabinfo.pid.active_objs 1007
servers.hostname.slabinfo.pid.num_objs 1593
servers.hostname.slabinfo.pid.objperslab 59
servers.hostname.slabinfo.pid.objsize 64
servers.hostname.slabinfo.pid.pagesperslab 1
servers.hostname.slabinfo.pid.slabdata.active_slabs 27
servers.hostname.slabinfo.pid.slabdata.num_slabs 27
servers.hostname.slabinfo.pid.slabdata.sharedavail 24
servers.hostname.slabinfo.pid.tunables.batchcount 60
servers.hostname.slabinfo.pid.tunables.limit 120
servers.hostname.slabinfo.pid.tunables.sharedfactor 8
servers.hostname.slabinfo.posix_timers_cache.active_objs 0
servers.hostname.slabinfo.posix_timers_cache.num_objs 0
servers.hostname.slabinfo.posix_timers_cache.objperslab 30
servers.hostname.slabinfo.posix_timers_cache.objsize 128
servers.hostname.slabinfo.posix_timers_cache.pagesperslab 1
servers.hostname.slabinfo.posix_timers_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.posix_timers_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.posix_timers_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.posix_timers_cache.tunables.batchcount 60
servers.hostname.slabinfo.posix_timers_cache.tunables.limit 120
servers.hostname.slabinfo.posix_timers_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.proc_inode_cache.active_objs 2162
servers.hostname.slabinfo.proc_inode_cache.num_objs 2868
servers.hostname.slabinfo.proc_inode_cache.objperslab 6
servers.hostname.slabinfo.proc_inode_cache.objsize 592
servers.hostname.slabinfo.proc_inode_cache.pagesperslab 1
servers.hostname.slabinfo.proc_inode_cache.slabdata.active_slabs 478
servers.hostname.slabinfo.proc_inode_cache.slabdata.num_slabs 478
servers.hostname.slabinfo.proc_inode_cache.slabdata.sharedavail 24
servers.hostname.slabinfo.proc_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.proc_inode_cache.tunables.limit 54
servers.hostname.slabinfo.proc_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.radix_tree_node.active_objs 29455
servers.hostname.slabinfo.radix_tree_node.num_objs 34006
servers.hostname.slabinfo.radix_tree_node.objperslab 7
servers.hostname.slabinfo.radix_tree_node.objsize 536
servers.hostname.slabinfo.radix_tree_node.pagesperslab 1
servers.hostname.slabinfo.radix_tree_node.slabdata.active_slabs 4858
servers.hostname.slabinfo.radix_tree_node.slabdata.num_slabs 4858
servers.hostname.slabinfo.radix_tree_node.slabdata.sharedavail 0
servers.hostname.slabinfo.radix_tree_node.tunables.batchcount 27
servers.hostname.slabinfo.radix_tree_node.tunables.limit 54
servers.hostname.slabinfo.radix_tree_node.tunables.sharedfactor 8
servers.hostname.slabinfo.request_sock_TCP.active_objs 16
servers.hostname.slabinfo.request_sock_TCP.num_objs 30
servers.hostname.slabinfo.request_sock_TCP.objperslab 30
servers.hostname.slabinfo.request_sock_TCP.objsize 128
servers.hostname.slabinfo.request_sock_TCP.pagesperslab 1
servers.hostname.slabinfo.request_sock_TCP.slabdata.active_slabs 1
servers.hostname.slabinfo.request_sock_TCP.slabdata.num_slabs 1
servers.hostname.slabinfo.request_sock_TCP.slabdata.sharedavail 0
servers.hostname.slabinfo.request_sock_TCP.tunables.batchcount 60
servers.hostname.slabinfo.request_sock_TCP.tunables.limit 120
servers.hostname.slabinfo.request_sock_TCP.tunables.sharedfactor 8
servers.hostname.slabinfo.request_sock_TCPv6.active_objs 0
servers.hostname.slabinfo.request_sock_TCPv6.num_objs 0
servers.hostname.slabinfo.request_sock_TCPv6.objperslab 20
servers.hostname.slabinfo.request_sock_TCPv6.objsize 192
servers.hostname.slabinfo.request_sock_TCPv6.pagesperslab 1
servers.hostname.slabinfo.request_sock_TCPv6.slabdata.active_slabs 0
servers.hostname.slabinfo.request_sock_TCPv6.slabdata.num_slabs 0
servers.hostname.slabinfo.request_sock_TCPv6.slabdata.sharedavail 0
servers.hostname.slabinfo.request_sock_TCPv6.tunables.batchcount 60
servers.hostname.slabinfo.request_sock_TCPv6.tunables.limit 120
servers.hostname.slabinfo.request_sock_TCPv6.tunables.sharedfactor 8
servers.hostname.slabinfo.revoke_record.active_objs 0
servers.hostname.slabinfo.revoke_record.num_objs 0
servers.hostname.slabinfo.revoke_record.objperslab 112
servers.hostname.slabinfo.revoke_record.objsize 32
servers.hostname.slabinfo.revoke_record.pagesperslab 1
servers.hostname.slabinfo.revoke_record.slabdata.active_slabs 0
servers.hostname.slabinfo.revoke_record.slabdata.num_slabs 0
servers.hostname.slabinfo.revoke_record.slabdata.sharedavail 0
servers.hostname.slabinfo.revoke_record.tunables.batchcount 60
servers.hostname.slabinfo.revoke_record.tunables.limit 120
servers.hostname.slabinfo.revoke_record.tunables.sharedfactor 8
servers.hostname.slabinfo.revoke_table.active_objs 2
servers.hostname.slabinfo.revoke_table.num_objs 202
servers.hostname.slabinfo.revoke_table.objperslab 202
servers.hostname.slabinfo.revoke_table.objsize 16
servers.hostname.slabinfo.revoke_table.pagesperslab 1
servers.hostname.slabinfo.revoke_table.slabdata.active_slabs 1
servers.hostname.slabinfo.revoke_table.slabdata.num_slabs 1
servers.hostname.slabinfo.revoke_table.slabdata.sharedavail 0
servers.hostname.slabinfo.revoke_table.tunables.batchcount 60
servers.hostname.slabinfo.revoke_table.tunables.limit 120
servers.hostname.slabinfo.revoke_table.tunables.sharedfactor 8
servers.hostname.slabinfo.rpc_buffers.active_objs 8
servers.hostname.slabinfo.rpc_buffers.num_objs 8
servers.hostname.slabinfo.rpc_buffers.objperslab 2
servers.hostname.slabinfo.rpc_buffers.objsize 2048
servers.hostname.slabinfo.rpc_buffers.pagesperslab 1
servers.hostname.slabinfo.rpc_buffers.slabdata.active_slabs 4
servers.hostname.slabinfo.rpc_buffers.slabdata.num_slabs 4
servers.hostname.slabinfo.rpc_buffers.slabdata.sharedavail 0
servers.hostname.slabinfo.rpc_buffers.tunables.batchcount 12
servers.hostname.slabinfo.rpc_buffers.tunables.limit 24
servers.hostname.slabinfo.rpc_buffers.tunables.sharedfactor 8
servers.hostname.slabinfo.rpc_inode_cache.active_objs 6
servers.hostname.slabinfo.rpc_inode_cache.num_objs 10
servers.hostname.slabinfo.rpc_inode_cache.objperslab 5
servers.hostname.slabinfo.rpc_inode_cache.objsize 768
servers.hostname.slabinfo.rpc_inode_cache.pagesperslab 1
servers.hostname.slabinfo.rpc_inode_cache.slabdata.active_slabs 2
servers.hostname.slabinfo.rpc_inode_cache.slabdata.num_slabs 2
servers.hostname.slabinfo.rpc_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.rpc_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.rpc_inode_cache.tunables.limit 54
servers.hostname.slabinfo.rpc_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.rpc_tasks.active_objs 8
servers.hostname.slabinfo.rpc_tasks.num_objs 10
servers.hostname.slabinfo.rpc_tasks.objperslab 10
servers.hostname.slabinfo.rpc_tasks.objsize 384
servers.hostname.slabinfo.rpc_tasks.pagesperslab 1
servers.hostname.slabinfo.rpc_tasks.slabdata.active_slabs 1
servers.hostname.slabinfo.rpc_tasks.slabdata.num_slabs 1
servers.hostname.slabinfo.rpc_tasks.slabdata.sharedavail 0
servers.hostname.slabinfo.rpc_tasks.tunables.batchcount 27
servers.hostname.slabinfo.rpc_tasks.tunables.limit 54
servers.hostname.slabinfo.rpc_tasks.tunables.sharedfactor 8
servers.hostname.slabinfo.scsi_cmd_cache.active_objs 275
servers.hostname.slabinfo.scsi_cmd_cache.num_objs 290
servers.hostname.slabinfo.scsi_cmd_cache.objperslab 10
servers.hostname.slabinfo.scsi_cmd_cache.objsize 384
servers.hostname.slabinfo.scsi_cmd_cache.pagesperslab 1
servers.hostname.slabinfo.scsi_cmd_cache.slabdata.active_slabs 29
servers.hostname.slabinfo.scsi_cmd_cache.slabdata.num_slabs 29
servers.hostname.slabinfo.scsi_cmd_cache.slabdata.sharedavail 209
servers.hostname.slabinfo.scsi_cmd_cache.tunables.batchcount 27
servers.hostname.slabinfo.scsi_cmd_cache.tunables.limit 54
servers.hostname.slabinfo.scsi_cmd_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.scsi_io_context.active_objs 0
servers.hostname.slabinfo.scsi_io_context.num_objs 0
servers.hostname.slabinfo.scsi_io_context.objperslab 34
servers.hostname.slabinfo.scsi_io_context.objsize 112
servers.hostname.slabinfo.scsi_io_context.pagesperslab 1
servers.hostname.slabinfo.scsi_io_context.slabdata.active_slabs 0
servers.hostname.slabinfo.scsi_io_context.slabdata.num_slabs 0
servers.hostname.slabinfo.scsi_io_context.slabdata.sharedavail 0
servers.hostname.slabinfo.scsi_io_context.tunables.batchcount 60
servers.hostname.slabinfo.scsi_io_context.tunables.limit 120
servers.hostname.slabinfo.scsi_io_context.tunables.sharedfactor 8
servers.hostname.slabinfo.secpath_cache.active_objs 0
servers.hostname.slabinfo.secpath_cache.num_objs 0
servers.hostname.slabinfo.secpath_cache.objperslab 59
servers.hostname.slabinfo.secpath_cache.objsize 64
servers.hostname.slabinfo.secpath_cache.pagesperslab 1
servers.hostname.slabinfo.secpath_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.secpath_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.secpath_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.secpath_cache.tunables.batchcount 60
servers.hostname.slabinfo.secpath_cache.tunables.limit 120
servers.hostname.slabinfo.secpath_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.selinux_inode_security.active_objs 1691
servers.hostname.slabinfo.selinux_inode_security.num_objs 2112
servers.hostname.slabinfo.selinux_inode_security.objperslab 48
servers.hostname.slabinfo.selinux_inode_security.objsize 80
servers.hostname.slabinfo.selinux_inode_security.pagesperslab 1
servers.hostname.slabinfo.selinux_inode_security.slabdata.active_slabs 44
servers.hostname.slabinfo.selinux_inode_security.slabdata.num_slabs 44
servers.hostname.slabinfo.selinux_inode_security.slabdata.sharedavail 0
servers.hostname.slabinfo.selinux_inode_security.tunables.batchcount 60
servers.hostname.slabinfo.selinux_inode_security.tunables.limit 120
servers.hostname.slabinfo.selinux_inode_security.tunables.sharedfactor 8
servers.hostname.slabinfo.sgpool-128.active_objs 32
servers.hostname.slabinfo.sgpool-128.num_objs 32
servers.hostname.slabinfo.sgpool-128.objperslab 1
servers.hostname.slabinfo.sgpool-128.objsize 4096
servers.hostname.slabinfo.sgpool-128.pagesperslab 1
servers.hostname.slabinfo.sgpool-128.slabdata.active_slabs 32
servers.hostname.slabinfo.sgpool-128.slabdata.num_slabs 32
servers.hostname.slabinfo.sgpool-128.slabdata.sharedavail 0
servers.hostname.slabinfo.sgpool-128.tunables.batchcount 12
servers.hostname.slabinfo.sgpool-128.tunables.limit 24
servers.hostname.slabinfo.sgpool-128.tunables.sharedfactor 8
servers.hostname.slabinfo.sgpool-16.active_objs 41
servers.hostname.slabinfo.sgpool-16.num_objs 56
servers.hostname.slabinfo.sgpool-16.objperslab 8
servers.hostname.slabinfo.sgpool-16.objsize 512
servers.hostname.slabinfo.sgpool-16.pagesperslab 1
servers.hostname.slabinfo.sgpool-16.slabdata.active_slabs 6
servers.hostname.slabinfo.sgpool-16.slabdata.num_slabs 7
servers.hostname.slabinfo.sgpool-16.slabdata.sharedavail 4
servers.hostname.slabinfo.sgpool-16.tunables.batchcount 27
servers.hostname.slabinfo.sgpool-16.tunables.limit 54
servers.hostname.slabinfo.sgpool-16.tunables.sharedfactor 8
servers.hostname.slabinfo.sgpool-32.active_objs 34
servers.hostname.slabinfo.sgpool-32.num_objs 36
servers.hostname.slabinfo.sgpool-32.objperslab 4
servers.hostname.slabinfo.sgpool-32.objsize 1024
servers.hostname.slabinfo.sgpool-32.pagesperslab 1
servers.hostname.slabinfo.sgpool-32.slabdata.active_slabs 9
servers.hostname.slabinfo.sgpool-32.slabdata.num_slabs 9
servers.hostname.slabinfo.sgpool-32.slabdata.sharedavail 2
servers.hostname.slabinfo.sgpool-32.tunables.batchcount 27
servers.hostname.slabinfo.sgpool-32.tunables.limit 54
servers.hostname.slabinfo.sgpool-32.tunables.sharedfactor 8
servers.hostname.slabinfo.sgpool-64.active_objs 32
servers.hostname.slabinfo.sgpool-64.num_objs 32
servers.hostname.slabinfo.sgpool-64.objperslab 2
servers.hostname.slabinfo.sgpool-64.objsize 2048
servers.hostname.slabinfo.sgpool-64.pagesperslab 1
servers.hostname.slabinfo.sgpool-64.slabdata.active_slabs 16
servers.hostname.slabinfo.sgpool-64.slabdata.num_slabs 16
servers.hostname.slabinfo.sgpool-64.slabdata.sharedavail 0
servers.hostname.slabinfo.sgpool-64.tunables.batchcount 12
servers.hostname.slabinfo.sgpool-64.tunables.limit 24
servers.hostname.slabinfo.sgpool-64.tunables.sharedfactor 8
servers.hostname.slabinfo.sgpool-8.active_objs 571
servers.hostname.slabinfo.sgpool-8.num_objs 660
servers.hostname.slabinfo.sgpool-8.objperslab 15
servers.hostname.slabinfo.sgpool-8.objsize 256
servers.hostname.slabinfo.sgpool-8.pagesperslab 1
servers.hostname.slabinfo.sgpool-8.slabdata.active_slabs 44
servers.hostname.slabinfo.sgpool-8.slabdata.num_slabs 44
servers.hostname.slabinfo.sgpool-8.slabdata.sharedavail 404
servers.hostname.slabinfo.sgpool-8.tunables.batchcount 60
servers.hostname.slabinfo.sgpool-8.tunables.limit 120
servers.hostname.slabinfo.sgpool-8.tunables.sharedfactor 8
servers.hostname.slabinfo.shared_policy_node.active_objs 0
servers.hostname.slabinfo.shared_policy_node.num_objs 0
servers.hostname.slabinfo.shared_policy_node.objperslab 77
servers.hostname.slabinfo.shared_policy_node.objsize 48
servers.hostname.slabinfo.shared_policy_node.pagesperslab 1
servers.hostname.slabinfo.shared_policy_node.slabdata.active_slabs 0
servers.hostname.slabinfo.shared_policy_node.slabdata.num_slabs 0
servers.hostname.slabinfo.shared_policy_node.slabdata.sharedavail 0
servers.hostname.slabinfo.shared_policy_node.tunables.batchcount 60
servers.hostname.slabinfo.shared_policy_node.tunables.limit 120
servers.hostname.slabinfo.shared_policy_node.tunables.sharedfactor 8
servers.hostname.slabinfo.shmem_inode_cache.active_objs 456
servers.hostname.slabinfo.shmem_inode_cache.num_objs 585
servers.hostname.slabinfo.shmem_inode_cache.objperslab 5
servers.hostname.slabinfo.shmem_inode_cache.objsize 768
servers.hostname.slabinfo.shmem_inode_cache.pagesperslab 1
servers.hostname.slabinfo.shmem_inode_cache.slabdata.active_slabs 117
servers.hostname.slabinfo.shmem_inode_cache.slabdata.num_slabs 117
servers.hostname.slabinfo.shmem_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.shmem_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.shmem_inode_cache.tunables.limit 54
servers.hostname.slabinfo.shmem_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.sighand_cache.active_objs 524
servers.hostname.slabinfo.sighand_cache.num_objs 528
servers.hostname.slabinfo.sighand_cache.objperslab 3
servers.hostname.slabinfo.sighand_cache.objsize 2112
servers.hostname.slabinfo.sighand_cache.pagesperslab 2
servers.hostname.slabinfo.sighand_cache.slabdata.active_slabs 176
servers.hostname.slabinfo.sighand_cache.slabdata.num_slabs 176
servers.hostname.slabinfo.sighand_cache.slabdata.sharedavail 12
servers.hostname.slabinfo.sighand_cache.tunables.batchcount 12
servers.hostname.slabinfo.sighand_cache.tunables.limit 24
servers.hostname.slabinfo.sighand_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.signal_cache.active_objs 598
servers.hostname.slabinfo.signal_cache.num_objs 621
servers.hostname.slabinfo.signal_cache.objperslab 9
servers.hostname.slabinfo.signal_cache.objsize 832
servers.hostname.slabinfo.signal_cache.pagesperslab 2
servers.hostname.slabinfo.signal_cache.slabdata.active_slabs 69
servers.hostname.slabinfo.signal_cache.slabdata.num_slabs 69
servers.hostname.slabinfo.signal_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.signal_cache.tunables.batchcount 27
servers.hostname.slabinfo.signal_cache.tunables.limit 54
servers.hostname.slabinfo.signal_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.sigqueue.active_objs 278
servers.hostname.slabinfo.sigqueue.num_objs 288
servers.hostname.slabinfo.sigqueue.objperslab 24
servers.hostname.slabinfo.sigqueue.objsize 160
servers.hostname.slabinfo.sigqueue.pagesperslab 1
servers.hostname.slabinfo.sigqueue.slabdata.active_slabs 12
servers.hostname.slabinfo.sigqueue.slabdata.num_slabs 12
servers.hostname.slabinfo.sigqueue.slabdata.sharedavail 25
servers.hostname.slabinfo.sigqueue.tunables.batchcount 60
servers.hostname.slabinfo.sigqueue.tunables.limit 120
servers.hostname.slabinfo.sigqueue.tunables.sharedfactor 8
servers.hostname.slabinfo.size-1024(DMA).active_objs 0
servers.hostname.slabinfo.size-1024(DMA).num_objs 0
servers.hostname.slabinfo.size-1024(DMA).objperslab 4
servers.hostname.slabinfo.size-1024(DMA).objsize 1024
servers.hostname.slabinfo.size-1024(DMA).pagesperslab 1
servers.hostname.slabinfo.size-1024(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-1024(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-1024(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-1024(DMA).tunables.batchcount 27
servers.hostname.slabinfo.size-1024(DMA).tunables.limit 54
servers.hostname.slabinfo.size-1024(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-1024.active_objs 2838
servers.hostname.slabinfo.size-1024.num_objs 2844
servers.hostname.slabinfo.size-1024.objperslab 4
servers.hostname.slabinfo.size-1024.objsize 1024
servers.hostname.slabinfo.size-1024.pagesperslab 1
servers.hostname.slabinfo.size-1024.slabdata.active_slabs 711
servers.hostname.slabinfo.size-1024.slabdata.num_slabs 711
servers.hostname.slabinfo.size-1024.slabdata.sharedavail 14
servers.hostname.slabinfo.size-1024.tunables.batchcount 27
servers.hostname.slabinfo.size-1024.tunables.limit 54
servers.hostname.slabinfo.size-1024.tunables.sharedfactor 8
servers.hostname.slabinfo.size-128(DMA).active_objs 0
servers.hostname.slabinfo.size-128(DMA).num_objs 0
servers.hostname.slabinfo.size-128(DMA).objperslab 30
servers.hostname.slabinfo.size-128(DMA).objsize 128
servers.hostname.slabinfo.size-128(DMA).pagesperslab 1
servers.hostname.slabinfo.size-128(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-128(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-128(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-128(DMA).tunables.batchcount 60
servers.hostname.slabinfo.size-128(DMA).tunables.limit 120
servers.hostname.slabinfo.size-128(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-128.active_objs 27752
servers.hostname.slabinfo.size-128.num_objs 27990
servers.hostname.slabinfo.size-128.objperslab 30
servers.hostname.slabinfo.size-128.objsize 128
servers.hostname.slabinfo.size-128.pagesperslab 1
servers.hostname.slabinfo.size-128.slabdata.active_slabs 933
servers.hostname.slabinfo.size-128.slabdata.num_slabs 933
servers.hostname.slabinfo.size-128.slabdata.sharedavail 29
servers.hostname.slabinfo.size-128.tunables.batchcount 60
servers.hostname.slabinfo.size-128.tunables.limit 120
servers.hostname.slabinfo.size-128.tunables.sharedfactor 8
servers.hostname.slabinfo.size-131072(DMA).active_objs 0
servers.hostname.slabinfo.size-131072(DMA).num_objs 0
servers.hostname.slabinfo.size-131072(DMA).objperslab 1
servers.hostname.slabinfo.size-131072(DMA).objsize 131072
servers.hostname.slabinfo.size-131072(DMA).pagesperslab 32
servers.hostname.slabinfo.size-131072(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-131072(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-131072(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-131072(DMA).tunables.batchcount 4
servers.hostname.slabinfo.size-131072(DMA).tunables.limit 8
servers.hostname.slabinfo.size-131072(DMA).tunables.sharedfactor 0
servers.hostname.slabinfo.size-131072.active_objs 2
servers.hostname.slabinfo.size-131072.num_objs 2
servers.hostname.slabinfo.size-131072.objperslab 1
servers.hostname.slabinfo.size-131072.objsize 131072
servers.hostname.slabinfo.size-131072.pagesperslab 32
servers.hostname.slabinfo.size-131072.slabdata.active_slabs 2
servers.hostname.slabinfo.size-131072.slabdata.num_slabs 2
servers.hostname.slabinfo.size-131072.slabdata.sharedavail 0
servers.hostname.slabinfo.size-131072.tunables.batchcount 4
servers.hostname.slabinfo.size-131072.tunables.limit 8
servers.hostname.slabinfo.size-131072.tunables.sharedfactor 0
servers.hostname.slabinfo.size-16384(DMA).active_objs 0
servers.hostname.slabinfo.size-16384(DMA).num_objs 0
servers.hostname.slabinfo.size-16384(DMA).objperslab 1
servers.hostname.slabinfo.size-16384(DMA).objsize 16384
servers.hostname.slabinfo.size-16384(DMA).pagesperslab 4
servers.hostname.slabinfo.size-16384(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-16384(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-16384(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-16384(DMA).tunables.batchcount 4
servers.hostname.slabinfo.size-16384(DMA).tunables.limit 8
servers.hostname.slabinfo.size-16384(DMA).tunables.sharedfactor 0
servers.hostname.slabinfo.size-16384.active_objs 37
servers.hostname.slabinfo.size-16384.num_objs 37
servers.hostname.slabinfo.size-16384.objperslab 1
servers.hostname.slabinfo.size-16384.objsize 16384
servers.hostname.slabinfo.size-16384.pagesperslab 4
servers.hostname.slabinfo.size-16384.slabdata.active_slabs 37
servers.hostname.slabinfo.size-16384.slabdata.num_slabs 37
servers.hostname.slabinfo.size-16384.slabdata.sharedavail 0
servers.hostname.slabinfo.size-16384.tunables.batchcount 4
servers.hostname.slabinfo.size-16384.tunables.limit 8
servers.hostname.slabinfo.size-16384.tunables.sharedfactor 0
servers.hostname.slabinfo.size-2048(DMA).active_objs 0
servers.hostname.slabinfo.size-2048(DMA).num_objs 0
servers.hostname.slabinfo.size-2048(DMA).objperslab 2
servers.hostname.slabinfo.size-2048(DMA).objsize 2048
servers.hostname.slabinfo.size-2048(DMA).pagesperslab 1
servers.hostname.slabinfo.size-2048(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-2048(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-2048(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-2048(DMA).tunables.batchcount 12
servers.hostname.slabinfo.size-2048(DMA).tunables.limit 24
servers.hostname.slabinfo.size-2048(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-2048.active_objs 3265
servers.hostname.slabinfo.size-2048.num_objs 3276
servers.hostname.slabinfo.size-2048.objperslab 2
servers.hostname.slabinfo.size-2048.objsize 2048
servers.hostname.slabinfo.size-2048.pagesperslab 1
servers.hostname.slabinfo.size-2048.slabdata.active_slabs 1638
servers.hostname.slabinfo.size-2048.slabdata.num_slabs 1638
servers.hostname.slabinfo.size-2048.slabdata.sharedavail 32
servers.hostname.slabinfo.size-2048.tunables.batchcount 12
servers.hostname.slabinfo.size-2048.tunables.limit 24
servers.hostname.slabinfo.size-2048.tunables.sharedfactor 8
servers.hostname.slabinfo.size-256(DMA).active_objs 0
servers.hostname.slabinfo.size-256(DMA).num_objs 0
servers.hostname.slabinfo.size-256(DMA).objperslab 15
servers.hostname.slabinfo.size-256(DMA).objsize 256
servers.hostname.slabinfo.size-256(DMA).pagesperslab 1
servers.hostname.slabinfo.size-256(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-256(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-256(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-256(DMA).tunables.batchcount 60
servers.hostname.slabinfo.size-256(DMA).tunables.limit 120
servers.hostname.slabinfo.size-256(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-256.active_objs 2844
servers.hostname.slabinfo.size-256.num_objs 2985
servers.hostname.slabinfo.size-256.objperslab 15
servers.hostname.slabinfo.size-256.objsize 256
servers.hostname.slabinfo.size-256.pagesperslab 1
servers.hostname.slabinfo.size-256.slabdata.active_slabs 199
servers.hostname.slabinfo.size-256.slabdata.num_slabs 199
servers.hostname.slabinfo.size-256.slabdata.sharedavail 1
servers.hostname.slabinfo.size-256.tunables.batchcount 60
servers.hostname.slabinfo.size-256.tunables.limit 120
servers.hostname.slabinfo.size-256.tunables.sharedfactor 8
servers.hostname.slabinfo.size-32(DMA).active_objs 0
servers.hostname.slabinfo.size-32(DMA).num_objs 0
servers.hostname.slabinfo.size-32(DMA).objperslab 112
servers.hostname.slabinfo.size-32(DMA).objsize 32
servers.hostname.slabinfo.size-32(DMA).pagesperslab 1
servers.hostname.slabinfo.size-32(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-32(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-32(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-32(DMA).tunables.batchcount 60
servers.hostname.slabinfo.size-32(DMA).tunables.limit 120
servers.hostname.slabinfo.size-32(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-32.active_objs 3927
servers.hostname.slabinfo.size-32.num_objs 4256
servers.hostname.slabinfo.size-32.objperslab 112
servers.hostname.slabinfo.size-32.objsize 32
servers.hostname.slabinfo.size-32.pagesperslab 1
servers.hostname.slabinfo.size-32.slabdata.active_slabs 38
servers.hostname.slabinfo.size-32.slabdata.num_slabs 38
servers.hostname.slabinfo.size-32.slabdata.sharedavail 2
servers.hostname.slabinfo.size-32.tunables.batchcount 60
servers.hostname.slabinfo.size-32.tunables.limit 120
servers.hostname.slabinfo.size-32.tunables.sharedfactor 8
servers.hostname.slabinfo.size-32768(DMA).active_objs 0
servers.hostname.slabinfo.size-32768(DMA).num_objs 0
servers.hostname.slabinfo.size-32768(DMA).objperslab 1
servers.hostname.slabinfo.size-32768(DMA).objsize 32768
servers.hostname.slabinfo.size-32768(DMA).pagesperslab 8
servers.hostname.slabinfo.size-32768(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-32768(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-32768(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-32768(DMA).tunables.batchcount 4
servers.hostname.slabinfo.size-32768(DMA).tunables.limit 8
servers.hostname.slabinfo.size-32768(DMA).tunables.sharedfactor 0
servers.hostname.slabinfo.size-32768.active_objs 4
servers.hostname.slabinfo.size-32768.num_objs 4
servers.hostname.slabinfo.size-32768.objperslab 1
servers.hostname.slabinfo.size-32768.objsize 32768
servers.hostname.slabinfo.size-32768.pagesperslab 8
servers.hostname.slabinfo.size-32768.slabdata.active_slabs 4
servers.hostname.slabinfo.size-32768.slabdata.num_slabs 4
servers.hostname.slabinfo.size-32768.slabdata.sharedavail 0
servers.hostname.slabinfo.size-32768.tunables.batchcount 4
servers.hostname.slabinfo.size-32768.tunables.limit 8
servers.hostname.slabinfo.size-32768.tunables.sharedfactor 0
servers.hostname.slabinfo.size-4096(DMA).active_objs 0
servers.hostname.slabinfo.size-4096(DMA).num_objs 0
servers.hostname.slabinfo.size-4096(DMA).objperslab 1
servers.hostname.slabinfo.size-4096(DMA).objsize 4096
servers.hostname.slabinfo.size-4096(DMA).pagesperslab 1
servers.hostname.slabinfo.size-4096(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-4096(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-4096(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-4096(DMA).tunables.batchcount 12
servers.hostname.slabinfo.size-4096(DMA).tunables.limit 24
servers.hostname.slabinfo.size-4096(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-4096.active_objs 421
servers.hostname.slabinfo.size-4096.num_objs 421
servers.hostname.slabinfo.size-4096.objperslab 1
servers.hostname.slabinfo.size-4096.objsize 4096
servers.hostname.slabinfo.size-4096.pagesperslab 1
servers.hostname.slabinfo.size-4096.slabdata.active_slabs 421
servers.hostname.slabinfo.size-4096.slabdata.num_slabs 421
servers.hostname.slabinfo.size-4096.slabdata.sharedavail 0
servers.hostname.slabinfo.size-4096.tunables.batchcount 12
servers.hostname.slabinfo.size-4096.tunables.limit 24
servers.hostname.slabinfo.size-4096.tunables.sharedfactor 8
servers.hostname.slabinfo.size-512(DMA).active_objs 0
servers.hostname.slabinfo.size-512(DMA).num_objs 0
servers.hostname.slabinfo.size-512(DMA).objperslab 8
servers.hostname.slabinfo.size-512(DMA).objsize 512
servers.hostname.slabinfo.size-512(DMA).pagesperslab 1
servers.hostname.slabinfo.size-512(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-512(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-512(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-512(DMA).tunables.batchcount 27
servers.hostname.slabinfo.size-512(DMA).tunables.limit 54
servers.hostname.slabinfo.size-512(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-512.active_objs 1836
servers.hostname.slabinfo.size-512.num_objs 1872
servers.hostname.slabinfo.size-512.objperslab 8
servers.hostname.slabinfo.size-512.objsize 512
servers.hostname.slabinfo.size-512.pagesperslab 1
servers.hostname.slabinfo.size-512.slabdata.active_slabs 234
servers.hostname.slabinfo.size-512.slabdata.num_slabs 234
servers.hostname.slabinfo.size-512.slabdata.sharedavail 32
servers.hostname.slabinfo.size-512.tunables.batchcount 27
servers.hostname.slabinfo.size-512.tunables.limit 54
servers.hostname.slabinfo.size-512.tunables.sharedfactor 8
servers.hostname.slabinfo.size-64(DMA).active_objs 0
servers.hostname.slabinfo.size-64(DMA).num_objs 0
servers.hostname.slabinfo.size-64(DMA).objperslab 59
servers.hostname.slabinfo.size-64(DMA).objsize 64
servers.hostname.slabinfo.size-64(DMA).pagesperslab 1
servers.hostname.slabinfo.size-64(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-64(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-64(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-64(DMA).tunables.batchcount 60
servers.hostname.slabinfo.size-64(DMA).tunables.limit 120
servers.hostname.slabinfo.size-64(DMA).tunables.sharedfactor 8
servers.hostname.slabinfo.size-64.active_objs 8143
servers.hostname.slabinfo.size-64.num_objs 12508
servers.hostname.slabinfo.size-64.objperslab 59
servers.hostname.slabinfo.size-64.objsize 64
servers.hostname.slabinfo.size-64.pagesperslab 1
servers.hostname.slabinfo.size-64.slabdata.active_slabs 212
servers.hostname.slabinfo.size-64.slabdata.num_slabs 212
servers.hostname.slabinfo.size-64.slabdata.sharedavail 33
servers.hostname.slabinfo.size-64.tunables.batchcount 60
servers.hostname.slabinfo.size-64.tunables.limit 120
servers.hostname.slabinfo.size-64.tunables.sharedfactor 8
servers.hostname.slabinfo.size-65536(DMA).active_objs 0
servers.hostname.slabinfo.size-65536(DMA).num_objs 0
servers.hostname.slabinfo.size-65536(DMA).objperslab 1
servers.hostname.slabinfo.size-65536(DMA).objsize 65536
servers.hostname.slabinfo.size-65536(DMA).pagesperslab 16
servers.hostname.slabinfo.size-65536(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-65536(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-65536(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-65536(DMA).tunables.batchcount 4
servers.hostname.slabinfo.size-65536(DMA).tunables.limit 8
servers.hostname.slabinfo.size-65536(DMA).tunables.sharedfactor 0
servers.hostname.slabinfo.size-65536.active_objs 0
servers.hostname.slabinfo.size-65536.num_objs 0
servers.hostname.slabinfo.size-65536.objperslab 1
servers.hostname.slabinfo.size-65536.objsize 65536
servers.hostname.slabinfo.size-65536.pagesperslab 16
servers.hostname.slabinfo.size-65536.slabdata.active_slabs 0
servers.hostname.slabinfo.size-65536.slabdata.num_slabs 0
servers.hostname.slabinfo.size-65536.slabdata.sharedavail 0
servers.hostname.slabinfo.size-65536.tunables.batchcount 4
servers.hostname.slabinfo.size-65536.tunables.limit 8
servers.hostname.slabinfo.size-65536.tunables.sharedfactor 0
servers.hostname.slabinfo.size-8192(DMA).active_objs 0
servers.hostname.slabinfo.size-8192(DMA).num_objs 0
servers.hostname.slabinfo.size-8192(DMA).objperslab 1
servers.hostname.slabinfo.size-8192(DMA).objsize 8192
servers.hostname.slabinfo.size-8192(DMA).pagesperslab 2
servers.hostname.slabinfo.size-8192(DMA).slabdata.active_slabs 0
servers.hostname.slabinfo.size-8192(DMA).slabdata.num_slabs 0
servers.hostname.slabinfo.size-8192(DMA).slabdata.sharedavail 0
servers.hostname.slabinfo.size-8192(DMA).tunables.batchcount 4
servers.hostname.slabinfo.size-8192(DMA).tunables.limit 8
servers.hostname.slabinfo.size-8192(DMA).tunables.sharedfactor 0
servers.hostname.slabinfo.size-8192.active_objs 21
servers.hostname.slabinfo.size-8192.num_objs 21
servers.hostname.slabinfo.size-8192.objperslab 1
servers.hostname.slabinfo.size-8192.objsize 8192
servers.hostname.slabinfo.size-8192.pagesperslab 2
servers.hostname.slabinfo.size-8192.slabdata.active_slabs 21
servers.hostname.slabinfo.size-8192.slabdata.num_slabs 21
servers.hostname.slabinfo.size-8192.slabdata.sharedavail 0
servers.hostname.slabinfo.size-8192.tunables.batchcount 4
servers.hostname.slabinfo.size-8192.tunables.limit 8
servers.hostname.slabinfo.size-8192.tunables.sharedfactor 0
servers.hostname.slabinfo.skbuff_fclone_cache.active_objs 70
servers.hostname.slabinfo.skbuff_fclone_cache.num_objs 70
servers.hostname.slabinfo.skbuff_fclone_cache.objperslab 7
servers.hostname.slabinfo.skbuff_fclone_cache.objsize 512
servers.hostname.slabinfo.skbuff_fclone_cache.pagesperslab 1
servers.hostname.slabinfo.skbuff_fclone_cache.slabdata.active_slabs 10
servers.hostname.slabinfo.skbuff_fclone_cache.slabdata.num_slabs 10
servers.hostname.slabinfo.skbuff_fclone_cache.slabdata.sharedavail 1
servers.hostname.slabinfo.skbuff_fclone_cache.tunables.batchcount 27
servers.hostname.slabinfo.skbuff_fclone_cache.tunables.limit 54
servers.hostname.slabinfo.skbuff_fclone_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.skbuff_head_cache.active_objs 2924
servers.hostname.slabinfo.skbuff_head_cache.num_objs 3945
servers.hostname.slabinfo.skbuff_head_cache.objperslab 15
servers.hostname.slabinfo.skbuff_head_cache.objsize 256
servers.hostname.slabinfo.skbuff_head_cache.pagesperslab 1
servers.hostname.slabinfo.skbuff_head_cache.slabdata.active_slabs 263
servers.hostname.slabinfo.skbuff_head_cache.slabdata.num_slabs 263
servers.hostname.slabinfo.skbuff_head_cache.slabdata.sharedavail 10
servers.hostname.slabinfo.skbuff_head_cache.tunables.batchcount 60
servers.hostname.slabinfo.skbuff_head_cache.tunables.limit 120
servers.hostname.slabinfo.skbuff_head_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.sock_inode_cache.active_objs 318
servers.hostname.slabinfo.sock_inode_cache.num_objs 318
servers.hostname.slabinfo.sock_inode_cache.objperslab 6
servers.hostname.slabinfo.sock_inode_cache.objsize 640
servers.hostname.slabinfo.sock_inode_cache.pagesperslab 1
servers.hostname.slabinfo.sock_inode_cache.slabdata.active_slabs 53
servers.hostname.slabinfo.sock_inode_cache.slabdata.num_slabs 53
servers.hostname.slabinfo.sock_inode_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.sock_inode_cache.tunables.batchcount 27
servers.hostname.slabinfo.sock_inode_cache.tunables.limit 54
servers.hostname.slabinfo.sock_inode_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.sysfs_dir_cache.active_objs 9096
servers.hostname.slabinfo.sysfs_dir_cache.num_objs 9328
servers.hostname.slabinfo.sysfs_dir_cache.objperslab 44
servers.hostname.slabinfo.sysfs_dir_cache.objsize 88
servers.hostname.slabinfo.sysfs_dir_cache.pagesperslab 1
servers.hostname.slabinfo.sysfs_dir_cache.slabdata.active_slabs 212
servers.hostname.slabinfo.sysfs_dir_cache.slabdata.num_slabs 212
servers.hostname.slabinfo.sysfs_dir_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.sysfs_dir_cache.tunables.batchcount 60
servers.hostname.slabinfo.sysfs_dir_cache.tunables.limit 120
servers.hostname.slabinfo.sysfs_dir_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.task_struct.active_objs 616
servers.hostname.slabinfo.task_struct.num_objs 620
servers.hostname.slabinfo.task_struct.objperslab 2
servers.hostname.slabinfo.task_struct.objsize 1888
servers.hostname.slabinfo.task_struct.pagesperslab 1
servers.hostname.slabinfo.task_struct.slabdata.active_slabs 310
servers.hostname.slabinfo.task_struct.slabdata.num_slabs 310
servers.hostname.slabinfo.task_struct.slabdata.sharedavail 36
servers.hostname.slabinfo.task_struct.tunables.batchcount 12
servers.hostname.slabinfo.task_struct.tunables.limit 24
servers.hostname.slabinfo.task_struct.tunables.sharedfactor 8
servers.hostname.slabinfo.taskstats_cache.active_objs 313
servers.hostname.slabinfo.taskstats_cache.num_objs 318
servers.hostname.slabinfo.taskstats_cache.objperslab 53
servers.hostname.slabinfo.taskstats_cache.objsize 72
servers.hostname.slabinfo.taskstats_cache.pagesperslab 1
servers.hostname.slabinfo.taskstats_cache.slabdata.active_slabs 6
servers.hostname.slabinfo.taskstats_cache.slabdata.num_slabs 6
servers.hostname.slabinfo.taskstats_cache.slabdata.sharedavail 17
servers.hostname.slabinfo.taskstats_cache.tunables.batchcount 60
servers.hostname.slabinfo.taskstats_cache.tunables.limit 120
servers.hostname.slabinfo.taskstats_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.tcp_bind_bucket.active_objs 9
servers.hostname.slabinfo.tcp_bind_bucket.num_objs 224
servers.hostname.slabinfo.tcp_bind_bucket.objperslab 112
servers.hostname.slabinfo.tcp_bind_bucket.objsize 32
servers.hostname.slabinfo.tcp_bind_bucket.pagesperslab 1
servers.hostname.slabinfo.tcp_bind_bucket.slabdata.active_slabs 2
servers.hostname.slabinfo.tcp_bind_bucket.slabdata.num_slabs 2
servers.hostname.slabinfo.tcp_bind_bucket.slabdata.sharedavail 0
servers.hostname.slabinfo.tcp_bind_bucket.tunables.batchcount 60
servers.hostname.slabinfo.tcp_bind_bucket.tunables.limit 120
servers.hostname.slabinfo.tcp_bind_bucket.tunables.sharedfactor 8
servers.hostname.slabinfo.tw_sock_TCP.active_objs 1
servers.hostname.slabinfo.tw_sock_TCP.num_objs 20
servers.hostname.slabinfo.tw_sock_TCP.objperslab 20
servers.hostname.slabinfo.tw_sock_TCP.objsize 192
servers.hostname.slabinfo.tw_sock_TCP.pagesperslab 1
servers.hostname.slabinfo.tw_sock_TCP.slabdata.active_slabs 1
servers.hostname.slabinfo.tw_sock_TCP.slabdata.num_slabs 1
servers.hostname.slabinfo.tw_sock_TCP.slabdata.sharedavail 0
servers.hostname.slabinfo.tw_sock_TCP.tunables.batchcount 60
servers.hostname.slabinfo.tw_sock_TCP.tunables.limit 120
servers.hostname.slabinfo.tw_sock_TCP.tunables.sharedfactor 8
servers.hostname.slabinfo.tw_sock_TCPv6.active_objs 0
servers.hostname.slabinfo.tw_sock_TCPv6.num_objs 0
servers.hostname.slabinfo.tw_sock_TCPv6.objperslab 20
servers.hostname.slabinfo.tw_sock_TCPv6.objsize 192
servers.hostname.slabinfo.tw_sock_TCPv6.pagesperslab 1
servers.hostname.slabinfo.tw_sock_TCPv6.slabdata.active_slabs 0
servers.hostname.slabinfo.tw_sock_TCPv6.slabdata.num_slabs 0
servers.hostname.slabinfo.tw_sock_TCPv6.slabdata.sharedavail 0
servers.hostname.slabinfo.tw_sock_TCPv6.tunables.batchcount 60
servers.hostname.slabinfo.tw_sock_TCPv6.tunables.limit 120
servers.hostname.slabinfo.tw_sock_TCPv6.tunables.sharedfactor 8
servers.hostname.slabinfo.uhci_urb_priv.active_objs 1
servers.hostname.slabinfo.uhci_urb_priv.num_objs 67
servers.hostname.slabinfo.uhci_urb_priv.objperslab 67
servers.hostname.slabinfo.uhci_urb_priv.objsize 56
servers.hostname.slabinfo.uhci_urb_priv.pagesperslab 1
servers.hostname.slabinfo.uhci_urb_priv.slabdata.active_slabs 1
servers.hostname.slabinfo.uhci_urb_priv.slabdata.num_slabs 1
servers.hostname.slabinfo.uhci_urb_priv.slabdata.sharedavail 0
servers.hostname.slabinfo.uhci_urb_priv.tunables.batchcount 60
servers.hostname.slabinfo.uhci_urb_priv.tunables.limit 120
servers.hostname.slabinfo.uhci_urb_priv.tunables.sharedfactor 8
servers.hostname.slabinfo.uid_cache.active_objs 21
servers.hostname.slabinfo.uid_cache.num_objs 90
servers.hostname.slabinfo.uid_cache.objperslab 30
servers.hostname.slabinfo.uid_cache.objsize 128
servers.hostname.slabinfo.uid_cache.pagesperslab 1
servers.hostname.slabinfo.uid_cache.slabdata.active_slabs 3
servers.hostname.slabinfo.uid_cache.slabdata.num_slabs 3
servers.hostname.slabinfo.uid_cache.slabdata.sharedavail 1
servers.hostname.slabinfo.uid_cache.tunables.batchcount 60
servers.hostname.slabinfo.uid_cache.tunables.limit 120
servers.hostname.slabinfo.uid_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.utrace_cache.active_objs 0
servers.hostname.slabinfo.utrace_cache.num_objs 0
servers.hostname.slabinfo.utrace_cache.objperslab 59
servers.hostname.slabinfo.utrace_cache.objsize 64
servers.hostname.slabinfo.utrace_cache.pagesperslab 1
servers.hostname.slabinfo.utrace_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.utrace_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.utrace_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.utrace_cache.tunables.batchcount 60
servers.hostname.slabinfo.utrace_cache.tunables.limit 120
servers.hostname.slabinfo.utrace_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.utrace_engine_cache.active_objs 0
servers.hostname.slabinfo.utrace_engine_cache.num_objs 0
servers.hostname.slabinfo.utrace_engine_cache.objperslab 59
servers.hostname.slabinfo.utrace_engine_cache.objsize 64
servers.hostname.slabinfo.utrace_engine_cache.pagesperslab 1
servers.hostname.slabinfo.utrace_engine_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.utrace_engine_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.utrace_engine_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.utrace_engine_cache.tunables.batchcount 60
servers.hostname.slabinfo.utrace_engine_cache.tunables.limit 120
servers.hostname.slabinfo.utrace_engine_cache.tunables.sharedfactor 8
servers.hostname.slabinfo.vm_area_struct.active_objs 3329
servers.hostname.slabinfo.vm_area_struct.num_objs 6182
servers.hostname.slabinfo.vm_area_struct.objperslab 22
servers.hostname.slabinfo.vm_area_struct.objsize 176
servers.hostname.slabinfo.vm_area_struct.pagesperslab 1
servers.hostname.slabinfo.vm_area_struct.slabdata.active_slabs 281
servers.hostname.slabinfo.vm_area_struct.slabdata.num_slabs 281
servers.hostname.slabinfo.vm_area_struct.slabdata.sharedavail 199
servers.hostname.slabinfo.vm_area_struct.tunables.batchcount 60
servers.hostname.slabinfo.vm_area_struct.tunables.limit 120
servers.hostname.slabinfo.vm_area_struct.tunables.sharedfactor 8
servers.hostname.slabinfo.xfrm_dst_cache.active_objs 0
servers.hostname.slabinfo.xfrm_dst_cache.num_objs 0
servers.hostname.slabinfo.xfrm_dst_cache.objperslab 10
servers.hostname.slabinfo.xfrm_dst_cache.objsize 384
servers.hostname.slabinfo.xfrm_dst_cache.pagesperslab 1
servers.hostname.slabinfo.xfrm_dst_cache.slabdata.active_slabs 0
servers.hostname.slabinfo.xfrm_dst_cache.slabdata.num_slabs 0
servers.hostname.slabinfo.xfrm_dst_cache.slabdata.sharedavail 0
servers.hostname.slabinfo.xfrm_dst_cache.tunables.batchcount 27
servers.hostname.slabinfo.xfrm_dst_cache.tunables.limit 54
servers.hostname.slabinfo.xfrm_dst_cache.tunables.sharedfactor 8
```

